CREATE OR REPLACE FUNCTION public.fc_nr_nf (
  _id_emp integer,
  _ser integer
)
RETURNS integer AS
$body$
declare
    _nr_nf integer;
BEGIN
    select max(tb_nf.num) + 1 into _nr_nf
    from tb_nf
    where
        tb_nf.id_emp = _id_emp and
        tb_nf.tp_emis = '[P]' and
        tb_nf.ser = _ser;
    
    if (not found) then
        _nr_nf := 1;
    end if;
    
    return _nr_nf;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE TABLE public.tb_blt_ret (
  id_emp INTEGER NOT NULL, 
  id_blt INTEGER NOT NULL, 
  arq VARCHAR(100) NOT NULL, 
  cd_ocor VARCHAR(10), 
  descr_ocor VARCHAR(255), 
  dt_hr TIMESTAMP WITHOUT TIME ZONE, 
  dt_arq DATE, 
  vl_desp_cobr NUMERIC(12,4), 
  vl_abat NUMERIC(12,4), 
  vl_desc NUMERIC(12,4), 
  vl_acr NUMERIC(12,4), 
  vl_iof NUMERIC(12,4), 
  vl_out_desp NUMERIC(12,4), 
  vl_out_cred NUMERIC(12,4), 
  vl_rec NUMERIC(12,4)
) WITHOUT OIDS;

ALTER TABLE public.tb_nf_item
  ADD COLUMN tot_nf_item BOOLEAN;

ALTER TABLE public.tb_nf_item
  DROP COLUMN tp_tot;

ALTER TABLE public.tb_blt_ret
  ADD CONSTRAINT pk_blt_ret 
    PRIMARY KEY (id_emp, id_blt, arq);

ALTER TABLE public.tb_blt_ret
  ADD CONSTRAINT fk__blt_ret__blt FOREIGN KEY (id_emp, id_blt)
    REFERENCES public.tb_blt(id_emp, id_blt)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

