CREATE OR REPLACE FUNCTION public.fc_tr_pdc_colab_item_bf (
)
RETURNS trigger AS
$body$
declare
    _item record;
BEGIN
    if (tg_op = 'DELETE') or (tg_op = 'UPDATE') then
        select mov_estq into _item 
        from tb_item 
        where
            id_item = old.id_item;
            
        if (_item.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 's', old.vl_qtd);
        end if;
    end if;
    
    
        
    if (tg_op = 'INSERT') or (tg_op = 'UPDATE') then
        select mov_estq into _item 
        from tb_item 
        where
            id_item = new.id_item;
        
        if (_item.mov_estq) then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'e', new.vl_qtd);
        end if;
    end if;
    
    

    if (tg_op = 'DELETE') then
        return old;
    else
        return new;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;