CREATE OR REPLACE FUNCTION public.fc_gera_nf_vnd (
  _id_emp integer,
  _id_vnd integer,
  _mod_nf varchar
)
RETURNS boolean AS
$body$
DECLARE
    _vnd record;
    _vnd_item_list refcursor;
    _vnd_item record;
    _id_nf integer;
    _aux varchar;
    
    _ser_nf integer;
    _num_nf integer;
    _id_mod_nf varchar;
    _id_nat_op integer;
    
    _vl_bc_icms numeric;
    _vl_icms numeric;
    _vl_bc_icms_st numeric;
    _vl_icms_st numeric;
    -- _vl_frete numeric;
    -- _vl_seg numeric;
    _vl_desc numeric;
    _vl_ipi numeric;
    _vl_pis numeric;
    _vl_cofins numeric;
    _vl_out numeric;
    _vl_item numeric;
    _vl_nf numeric;
    
    
    
    _vl_bc_icms_item numeric;
    _vl_aliq_icms_item numeric;
    _vl_icms_item numeric;
    
    _vl_bc_ipi_item numeric;
    _vl_aliq_ipi_item numeric;
    _vl_ipi_item numeric;
    
    _vl_bc_pis_item numeric;
    _vl_aliq_pis_item numeric;
    _vl_pis_item numeric;
    
    _vl_bc_cofins_item numeric;
    _vl_aliq_cofins_item numeric;
    _vl_cofins_item numeric;
    
    _vl_bc_icms_st_item numeric;
    _vl_aliq_icms_st_item numeric;
    _vl_icms_st_item numeric;
    
    _vl_tot_trib numeric;
    
    
    _id_nf_item integer;
    _id_cfop integer;
    _und_med_trib record;
    
    _id_und_med_trib varchar;
    _cd_bar_trib varchar;
    _vl_qtd_trib numeric;
    _vl_unt_trib numeric;
    
    _id_reg_trib_item varchar;
BEGIN
    select 
        tb_vnd.*,
        tb_cond_pagto.fm_pagto_nfe,
        emp.id_munic as id_munic_emp,
        munic_emp.id_uf as id_uf_emp,
        munic_dst.id_uf as id_uf_dst
    into _vnd
    from tb_vnd
    left outer join tb_cond_pagto on
        (tb_vnd.id_cond_pagto = tb_cond_pagto.id_cond_pagto)
    join tb_part emp on
        (tb_vnd.id_emp = emp.id_part)
    left outer join tb_munic munic_emp on
        (emp.id_munic = munic_emp.id_munic)
    left outer join tb_munic munic_dst on
        (tb_vnd.id_munic = munic_dst.id_munic)
    where
        tb_vnd.id_emp = _id_emp and
        tb_vnd.id_vnd = _id_vnd;
        
    
    raise notice 'teste 1';
    
    select nextval('sq_nf') into _id_nf;
    
    if (_mod_nf = 'NFE') then
        select fc_get_emp_cnf(_id_emp, 2003) into _aux;
        select fc_get_emp_cnf(_id_emp, 2001) into _id_mod_nf;
        
        if (_aux = '') then
            raise exception 'Serie para NFe nao definida';
        end if;
        
        _ser_nf = cast(_aux as integer);
        
        select fc_get_emp_cnf(_id_emp, 2002) into _aux;
        
        if (_aux = '') then
            raise exception 'Natureza de operacao para NFe nao definida';
        end if;
        
        _id_nat_op = cast(_aux as integer);
        
    elsif (_mod_nf = 'NFCE') then
        select fc_get_emp_cnf(_id_emp, 3000) into _aux;
        select fc_get_emp_cnf(_id_emp, 3001) into _id_mod_nf;
        
        if (_aux = '') then
            raise exception 'Serie para NFCe nao informada';
        end if;
        
        _ser_nf = cast(_aux as integer);
        
        select fc_get_emp_cnf(_id_emp, 3002) into _aux;
        
        if (_aux = '') then
            raise exception 'Natureza de operacao para NFCe nao definida';
        end if;
        
        _id_nat_op = cast(_aux as integer);
    end if;
    
    raise notice 'teste 2';
    
    select fc_get_num_nf(_id_emp, _ser_nf) into _num_nf;
    
    insert into tb_nf 
        (id_emp, id_nf, id_mod_nf, tp_emis, ser, num, dt_emis, tp_op, dt_op, hr_op, 
         fm_pagto, fm_emis, fin_emis, tp_imp,
         id_nat_op, id_munic_fg, 
         id_part_dst, cpf_cnpj_dst, nome_dst, insc_dst, email_dst, 
         cep_dst, logr_dst, num_dst, compl_dst, bairro_dst, id_munic_dst, fone_dst,  
         num_fat, vl_fat, vl_desc_fat, vl_liq_fat, inf_ad_cont)
    values
        (_id_emp, _id_nf, _id_mod_nf, '[P]', _ser_nf, _num_nf, _vnd.dt_vnd, '[S]', current_date, current_time,
         _vnd.fm_pagto_nfe, 'N', 'N', 'R',
         _id_nat_op, _vnd.id_munic_emp,
         _vnd.id_cli, _vnd.cpf_cnpj, _vnd.nome, _vnd.insc, _vnd.email,
         _vnd.cep, _vnd.logr, _vnd.num, _vnd.compl, _vnd.bairro, _vnd.id_munic, _vnd.fone,
         _vnd.id_vnd, _vnd.vl_tot, 0, _vnd.vl_tot, '');
         

    raise notice 'teste 3';
    
    _vl_bc_icms := 0;
    _vl_icms := 0;
    _vl_bc_icms_st := 0;
    _vl_icms_st := 0;
    _vl_ipi := 0;
    _vl_pis := 0;
    _vl_cofins := 0;
    _vl_desc := 0;
    _vl_out := 0;
    _vl_item := 0;
    _vl_nf := 0;
    _vl_tot_trib := 0;
    
    raise notice 'teste 4';
    
    open _vnd_item_list for
        select
            tb_vnd_item.*,
            tb_item.mov_estq,
            tb_item.id_ncm,
            tb_item.cd_bar,
            tb_item.prod_esp,
            tb_item.vl_peso_liq * tb_vnd_item.vl_qtd_mov as vl_peso_liq,
            tb_item.vl_peso_brt * tb_vnd_item.vl_qtd_mov as vl_peso_brt,
            tb_tp_item.item_nf,
            tb_grp_cfop_nat_op.id_cfop_d,
            tb_grp_cfop_nat_op.id_cfop_f,
            tb_grp_trib_nat_op.*,
            (tb_vnd_item.vl_tot * tb_ncm.vl_aliq_nac / 100) as  vl_tot_trib
        from tb_vnd_item
        join tb_item on
            (tb_vnd_item.id_item = tb_item.id_item)
        left outer join tb_grp_trib_nat_op on
            (tb_item.id_grp_trib = tb_grp_trib_nat_op.id_grp_trib and
             tb_grp_trib_nat_op.id_nat_op = _id_nat_op)
        left outer join tb_grp_cfop_nat_op on
            (tb_item.id_grp_cfop = tb_grp_cfop_nat_op.id_grp_cfop and
             tb_grp_cfop_nat_op.id_nat_op = _id_nat_op)
        left outer join tb_tp_item on
            (tb_item.id_tp_item = tb_tp_item.id_tp_item)
        left outer join tb_ncm on
            (tb_item.id_ncm = tb_ncm.id_ncm)
        where
            tb_vnd_item.id_emp = _id_emp and
            tb_vnd_item.id_vnd = _id_vnd;
            
    raise notice 'teste 5';

    fetch _vnd_item_list into _vnd_item;
    
    _id_nf_item := 1;
    _id_reg_trib_item := fc_get_emp_cnf(_id_emp, 2000);
    
    while found loop
        if (_vnd_item.item_nf) then
            
            raise notice 'teste 5.1';
            --
            -- Cfop
            --
            if (_mod_nf = 'NFCE') or (_vnd.id_uf_emp = _vnd.id_uf_dst) then
                _id_cfop := _vnd_item.id_cfop_d;
            else
                _id_cfop := _vnd_item.id_cfop_f;
            end if;
            
            raise notice 'teste 5.2';
            
            --
            -- Unidade de medida tributada
            --
            select
                tb_item_und_med.id_und_med,
                tb_item_und_med.vl_conv,
                tb_item_und_med.cd_bar 
            into _und_med_trib
            from tb_item_und_med
            where
                tb_item_und_med.id_item = _vnd_item.id_item and
                tb_item_und_med.op like '%[NF_EMT]%'
            limit 1;
            
            raise notice 'teste 5.3';
            
            if not found then
                raise notice 'teste 5.3.1';
                
                select 
                    tb_item.id_und_med,
                    cast(1 as numeric(12,4)) as vl_conv,
                    tb_item.cd_bar
                into _und_med_trib
                from tb_item
                where
                    tb_item.id_item = _vnd_item.id_item;
            end if;
            
            if (_und_med_trib.id_und_med is null or _und_med_trib.id_und_med = '') then
                raise exception 'Unidade de medida do item "%" nao esta defidina', _vnd_item.id_item;
            end if;
            
            _id_und_med_trib := _und_med_trib.id_und_med;
            _vl_qtd_trib := _vnd_item.vl_qtd_mov * _und_med_trib.vl_conv;
            _vl_unt_trib := _vnd_item.vl_tot / _vl_qtd_trib;
            _cd_bar_trib := _und_med_trib.cd_bar;
            
        
            --
            -- Calucla icms, icms st, ipi, pis e cofins
            --
            
            _vl_bc_icms_item   := 0;
            _vl_aliq_icms_item := 0;
            _vl_icms_item      := 0;
            if (_vnd_item.vl_aliq_icms <> 0) then
                _vl_bc_icms_item   := _vnd_item.vl_tot;
                _vl_aliq_icms_item := _vnd_item.vl_aliq_icms;
                _vl_icms_item      := cast(_vnd_item.vl_tot * _vnd_item.vl_aliq_icms / 100 as numeric(12,2));
                
                _vl_bc_icms := _vl_bc_icms + _vl_bc_ipi_item;
                _vl_icms := _vl_icms + _vl_icms_item;
            end if;
            
            raise notice 'teste 5.5';
            
            _vl_bc_ipi_item   := 0;
            _vl_aliq_ipi_item := 0;
            _vl_ipi_item      := 0;
            if (_vnd_item.vl_aliq_ipi <> 0) then
                _vl_bc_ipi_item   := _vnd_item.vl_tot;
                _vl_aliq_ipi_item := _vnd_item.vl_aliq_ipi;
                _vl_ipi_item      := cast(_vnd_item.vl_tot * _vnd_item.vl_aliq_ipi / 100 as numeric(12,2));
                
                _vl_ipi := _vl_ipi + _vl_ipi_item;
            end if;
            
            raise notice 'teste 5.6';
            
            _vl_bc_pis_item   := 0;
            _vl_aliq_pis_item := 0;
            _vl_pis_item      := 0;
            if (_vnd_item.vl_aliq_pis <> 0) then
                _vl_bc_pis_item   := _vnd_item.vl_tot;
                _vl_aliq_pis_item := _vnd_item.vl_aliq_pis;
                _vl_pis_item      := cast(_vnd_item.vl_tot * _vnd_item.vl_aliq_pis / 100 as numeric(12,2));
                
                _vl_pis := _vl_pis + _vl_pis_item;
            end if;
            
            raise notice 'teste 5.7';
            
            _vl_bc_cofins_item   := 0;
            _vl_aliq_cofins_item := 0;
            _vl_cofins_item      := 0;
            if (_vnd_item.vl_aliq_cofins <> 0) then
                _vl_bc_cofins_item   := _vnd_item.vl_tot;
                _vl_aliq_cofins_item := _vnd_item.vl_aliq_cofins;
                _vl_cofins_item      := cast(_vnd_item.vl_tot * _vnd_item.vl_aliq_cofins / 100 as numeric(12,2));
                
                _vl_cofins := _vl_cofins + _vl_cofins_item;
            end if;
            
            raise notice 'teste 5.8';
            
            _vl_bc_icms_st_item   := 0;
            _vl_aliq_icms_st_item := 0;
            _vl_icms_st_item      := 0;
            /*
             configurar para calcular o valor do icms st pelo cnae
             
            if (_vnd_item.vl_aliq_icms_st <> 0) then
                _vl_bc_icms_st_item   := _vnd_item.vl_tot;
                _vl_aliq_icms_st_item := _vnd_item.vl_aliq_icms_st;
                _vl_icms_st_item      := _vnd_item.vl_tot * _vnd_item.vl_aliq_icms_st / 100;
                
                _vl_bc_icms_st := _vl_bc_icms_st + _vl_bc_icms_st_item;
                _vl_icms_st := _vl_icms_st + _vl_icms_st_item;
            end if;
            */
            
            _vl_desc := _vl_desc + _vnd_item.vl_desc;
            _vl_out  := _vl_out + _vnd_item.vl_acr;
            
            raise notice 'teste 5.9';
            
            _vl_item := cast(_vl_item + _vnd_item.vl_tot as numeric(12,2));
            _vl_nf := cast(_vl_nf + 
                _vnd_item.vl_tot -
                _vnd_item.vl_desc +
                _vnd_item.vl_acr +
                _vl_ipi_item +
                _vl_pis_item +
                _vl_cofins_item +
                _vl_icms_st_item as numeric(12,2));
                
            _vl_tot_trib := _vl_tot_trib + _vnd_item.vl_tot_trib;
                
            raise notice 'teste 5.10';
            
            insert into tb_nf_item
                (id_emp, id_nf, id_nf_item, id_dep, id_grd_estq, id_item, descr_item,
                 id_ncm, id_cfop, 
                 id_und_med_com, cd_bar_com, vl_qtd_com, vl_unt_com,
                 id_und_med_trib, cd_bar_trib, vl_qtd_trib, vl_unt_trib,
                 -- vl_seg, vl_frete, 
                 vl_tot, vl_desc, vl_out, 
                 prod_esp, id_grp_trib, 
                 id_trib_icms, mod_bc_icms, vl_bc_icms, vl_aliq_icms, vl_icms, -- vl_perc_red_bc_icms,
                 mod_bc_icms_st, vl_bc_icms_st, vl_aliq_icms_st, vl_icms_st,
                 id_trib_ipi, vl_bc_ipi, vl_aliq_ipi, vl_ipi,
                 id_trib_pis, vl_bc_pis, vl_aliq_pis, vl_pis,
                 id_trib_cofins, vl_bc_cofins, vl_aliq_cofins, vl_cofins, 
                 vl_peso_liq, vl_peso_brt, id_reg_trib,
                 vl_tot_trib,
                 
                 mov_estq, id_und_med_mov, vl_qtd_mov, tot_nf_item)
            values
                (_id_emp, _id_nf, _id_nf_item, _vnd_item.id_dep, _vnd_item.id_grd_estq, _vnd_item.id_item, _vnd_item.descr,
                 _vnd_item.id_ncm, _id_cfop,
                 _vnd_item.id_und_med, _vnd_item.cd_bar, _vnd_item.vl_qtd, _vnd_item.vl_prc_unt,
                 _id_und_med_trib, _cd_bar_trib, _vl_qtd_trib, _vl_unt_trib,
                 _vnd_item.vl_tot, _vnd_item.vl_desc, _vnd_item.vl_acr,
                 _vnd_item.prod_esp, _vnd_item.id_grp_trib,
                 _vnd_item.id_trib_icms, _vnd_item.mod_bc_icms, _vl_bc_icms_item, _vl_aliq_icms_item, _vl_icms_item,
                 _vnd_item.mod_bc_icms_st, _vl_bc_icms_st_item, _vl_aliq_icms_st_item, _vl_icms_st_item,
                 _vnd_item.id_trib_ipi, _vl_bc_ipi_item, _vl_aliq_ipi_item, _vl_ipi_item,
                 _vnd_item.id_trib_pis, _vl_bc_pis_item, _vl_aliq_pis_item, _vl_pis_item,
                 _vnd_item.id_trib_cofins, _vl_bc_cofins_item, _vl_aliq_cofins_item, _vl_cofins_item,
                 _vnd_item.vl_peso_liq, _vnd_item.vl_peso_brt, _id_reg_trib_item,
                 _vnd_item.vl_tot_trib,
                 false, _vnd_item.id_und_med_mov, _vnd_item.vl_qtd_mov, true
            );  
            
            raise notice 'teste 7 %', _id_nf_item;
          
            _id_nf_item := _id_nf_item + 1;
        end if;
        
        raise notice 'teste 7.1 %', _id_nf_item;
    
        fetch _vnd_item_list into _vnd_item;
        
        raise notice 'teste 7.2 %', _id_nf_item;
    end loop;
    
    
    raise notice 'teste 8';
    
    close _vnd_item_list;

    update tb_nf set
        vl_bc_icms = _vl_bc_icms,
        vl_icms = _vl_icms,
        vl_bc_icms_st = _vl_bc_icms_st,
        vl_icms_st = _vl_icms_st,
        vl_ipi = _vl_ipi,
        vl_pis = _vl_pis,
        vl_cofins = _vl_cofins,
        vl_desc = _vl_desc,
        vl_out = _vl_out,
        vl_item = _vl_item,
        vl_nf = _vl_nf,
        vl_tot_trib = _vl_tot_trib
    where
        id_emp = _id_emp and
        id_nf = _id_nf;

    raise notice 'teste 9';
    
    
    
    insert into tb_nfe
        (id_emp, id_nf, sit)
    values
        (_id_emp, _id_nf, '0');
  /*       
         
  id_mod_frete, 
  id_part_trp,
  cpf_cnpj_trp,
  nome_trp,
  insc_trp,
  logr_trp,
  id_munic_trp,
  placa_trp,
  vl_peso_liq_trp,
  vl_peso_brt_trp,
  vl_qtd_vol_trp,
  entreg_trp,
  */
  
        
    
    -- fetch _vnd_item_list into _vnd_
            

    return true;    
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_get_emp_cnf (
  _id_emp integer,
  _id_cnf integer
)
RETURNS varchar AS
$body$
declare
    _result varchar;
BEGIN
    select val into _result
    from tb_emp_cnf
    where
        id_emp = _id_emp and
        id_cnf = _id_cnf;
    if found then
        return _result;
    else
        return '';
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_get_num_nf (
  _id_emp integer,
  _ser integer
)
RETURNS integer AS
$body$
declare
    _num_nf integer;
BEGIN
    select max(num) into _num_nf
    from tb_nf
    where
        id_emp = _id_emp and
        tp_emis = '[P]' and
        ser = _ser;
    
    if (not _num_nf is null) then
        return _num_nf + 1;
    else
        return 1;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_bf (
)
RETURNS trigger AS
$body$
declare
    _nf_item_list refcursor;
    _nf_item record;
    _op_inv varchar;
BEGIN
    if (tg_op in ('INSERT', 'UPDATE')) then
        if (tg_op  = 'INSERT' and new.tp_emis = '[P]') then
            new.num := "fc_get_num_nf"(new.id_emp, new.ser);
        end if;
    
        return new;
    elsif (tg_op = 'DELETE') then
    
        if (old.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
        
        open _nf_item_list for
            select *
            from tb_nf_item
            where
                id_emp = old.id_emp and
                id_nf = old.id_nf;
    
        fetch _nf_item_list into _nf_item;
        
        
    
        while found loop
            if (_nf_item.mov_estq) then
                perform fc_item_estq(_nf_item.id_item, _nf_item.id_emp, _nf_item.id_dep, _nf_item.id_grd_estq, _op_inv, _nf_item.vl_qtd_mov);
            end if;
            
            fetch _nf_item_list into _nf_item;    
        end loop;
        
        close _nf_item_list;
    
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq) then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _vnd record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq) then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        if (old.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_cond_pagto
  ADD COLUMN fm_pagto_nfe CHAR(1);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_icms TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_icms_st TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_frete TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_seg TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_desc TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_ipi TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_pis TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_cofins TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_out TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ALTER COLUMN vl_nf TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf
  ADD COLUMN vl_tot_trib NUMERIC(12,2);

ALTER TABLE public.tb_nf_item
  RENAME COLUMN cod_bar_com TO cd_bar_com;

ALTER TABLE public.tb_nf_item
  RENAME COLUMN cod_bar_trib TO cd_bar_trib;

ALTER TABLE public.tb_nf_item
  ALTER COLUMN vl_icms TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf_item
  ALTER COLUMN vl_ipi TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf_item
  ALTER COLUMN vl_pis TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf_item
  ALTER COLUMN vl_cofins TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf_item
  ALTER COLUMN vl_icms_st TYPE NUMERIC(12,2);

ALTER TABLE public.tb_nf_item
  ADD COLUMN id_grd_estq VARCHAR(20);

ALTER TABLE public.tb_nfe
  ALTER COLUMN num_prot TYPE VARCHAR(20);

ALTER TABLE public.tb_nfe
  ALTER COLUMN descr_sit_nfe TYPE VARCHAR(500);

ALTER TABLE public.tb_nfe
  ADD COLUMN descr_sit TEXT;

ALTER TABLE public.tb_op_fnc
  ADD COLUMN cd_nfe_pagto VARCHAR(2);

ALTER TABLE public.tb_op_fnc
  ADD COLUMN cd_nfe_band_cart VARCHAR(2);

ALTER TABLE public.tb_tp_item
  ADD COLUMN item_nf BOOLEAN;

ALTER TABLE public.tb_nf_item
  ADD CONSTRAINT fk__nf_item__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_nf_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_nf FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_nf_bf();

CREATE TRIGGER tr_nf_item_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_nf_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_nf_item_bf();

