CREATE SEQUENCE public.sq_disp
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE SEQUENCE public.sq_grp_disp
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_grp_disp (
  id_grp_disp INTEGER NOT NULL, 
  descr VARCHAR(100), 
  CONSTRAINT pk_grp_disp PRIMARY KEY(id_grp_disp)
) ;

CREATE TABLE public.tb_disp (
  id_disp INTEGER NOT NULL, 
  descr VARCHAR(100), 
  tp VARCHAR(1), 
  vl_disp NUMERIC(12,2), 
  abat_ir BOOLEAN, 
  CONSTRAINT pk_disp PRIMARY KEY(id_disp)
) ;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_calc_dif (
  _vl_ant numeric,
  _vl_atu numeric
)
RETURNS numeric [] AS
$body$
declare
    _vl_dif numeric;
    _vl_perc_dif numeric;
begin
    if (_vl_atu > _vl_ant) then
        _vl_dif := cast(_vl_atu - _vl_ant as numeric(12,2));
        if (_vl_ant = 0) then
            _vl_perc_dif := 100.00;
        else
            _vl_perc_dif := cast(_vl_dif * 100 / _vl_ant as numeric(12,2));
        end if;
    else
        _vl_dif := cast(_vl_ant - _vl_atu as numeric(12,2));
        
        if (_vl_atu = 0) then
            _vl_perc_dif := 100.00;
        else
            _vl_perc_dif := cast(_vl_dif * 100 / _vl_atu as numeric(12,2));
        end if;
        
        _vl_dif := _vl_dif * -1;
        _vl_perc_dif := _vl_perc_dif * -1;
    end if;
    
    return array[_vl_dif, _vl_perc_dif];
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_grp_disp_item (
  id_grp_disp INTEGER NOT NULL, 
  id_grp_disp_item INTEGER NOT NULL, 
  id_disp INTEGER, 
  vl_disp NUMERIC(12,2), 
  cst_op BOOLEAN, 
  CONSTRAINT pk_grp_disp_item PRIMARY KEY(id_grp_disp, id_grp_disp_item)
) ;

ALTER TABLE public.tb_part
  ADD COLUMN num_matr_colab INTEGER;

ALTER TABLE public.tb_part
  ADD COLUMN id_grp_disp INTEGER;

ALTER TABLE public.tb_part
  ADD CONSTRAINT fk__part__grp_disp FOREIGN KEY (id_grp_disp)
    REFERENCES public.tb_grp_disp(id_grp_disp)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_disp_item
  ADD CONSTRAINT fk__grp_disp_item__disp FOREIGN KEY (id_disp)
    REFERENCES public.tb_disp(id_disp)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_disp_item
  ADD CONSTRAINT fk__grp_disp_item__grp_disp FOREIGN KEY (id_grp_disp)
    REFERENCES public.tb_grp_disp(id_grp_disp)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;
