CREATE SEQUENCE public.sq_cmp_vnd
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_cmp_vnd RESTART WITH 4;

CREATE OR REPLACE FUNCTION public.fc_restart_sequence (
)
RETURNS boolean AS
$body$
declare
    v_cur refcursor;
    v_rec record;
    v_op varchar;
    v_id_max integer;
    v_aux integer;
    v_sql varchar;
begin

    select count(*) into v_aux
    from tb_est;
    
    if (v_aux > 1) then
        raise exception 'Existe mais de uma estação cadastrada, execute a funcao de iniciar estação';
        return false;
    end if;

 
    open v_cur for
        select relname, substring(relname, 4, length(relname)) as "entidade"
        from pg_class
        where 
            relname like 'sq_%';
     
    fetch v_cur into v_rec;
     
    while found loop
     
        select count(*) into v_aux
        from pg_class
        where
            relname = 'tb_' || v_rec."entidade";
         
        if (v_aux > 0) then
            v_sql := 'select max("id_' || v_rec."entidade" || '")::integer ' ||
                'from "tb_' || v_rec."entidade" || '"';
            if (v_rec.entidade = 'tb_cmp_cst') then
                v_sql := v_sql + ' where id_cmp_cst < 1000';
            end if;
                
                
            execute v_sql into v_id_max;
         
            raise notice '[% %]   ', v_rec."relname", v_id_max;
             
            if (v_id_max is not null) then
                execute 'alter sequence "' || v_rec."relname" || '" restart with ' || v_id_max + 1;
            else
                execute 'alter sequence "' || v_rec."relname" || '" restart with 1';
            end if;
        end if;
         
        fetch v_cur into v_rec;
    end loop;
     
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_cmp_vnd (
  id_cmp_vnd INTEGER NOT NULL, 
  descr VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  CONSTRAINT pk_cmp_vnd PRIMARY KEY(id_cmp_vnd)
) ;

CREATE TABLE public.tb_vnd_item_cmp_vnd (
  id_emp INTEGER NOT NULL, 
  id_vnd INTEGER NOT NULL, 
  id_vnd_item INTEGER NOT NULL, 
  id_cmp_vnd INTEGER NOT NULL, 
  vl_perc NUMERIC(12,4), 
  vl_tot NUMERIC(12,4), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  CONSTRAINT pk_vnd_item_cmp_vnd PRIMARY KEY(id_emp, id_vnd, id_vnd_item, id_cmp_vnd)
) ;

ALTER TABLE public.tb_vnd_item_cmp_vnd
  ADD CONSTRAINT fk__vnd_item_cmp_vnd__cmp_vnd FOREIGN KEY (id_cmp_vnd)
    REFERENCES public.tb_cmp_vnd(id_cmp_vnd)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd_item_cmp_vnd
  ADD CONSTRAINT fk__vnd_item_cmp_vnd__vnd_item FOREIGN KEY (id_emp, id_vnd, id_vnd_item)
    REFERENCES public.tb_vnd_item(id_emp, id_vnd, id_vnd_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;
