CREATE SEQUENCE public.sq_fml
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE SEQUENCE public.sq_pdc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

-- ALTER TABLE public.tb_cest
--   ADD COLUMN id_usr_ult_alt INTEGER;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_pdc_item_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'INSERT') then
            
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd);
        
        return new;
        
    elsif (tg_op = 'DELETE') then
    
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd);
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_pdc_bf (
)
RETURNS trigger AS
$body$
declare
    _vl_cst_med_calc numeric;
    _vl_estq numeric;
    _vl_ult_cst_med numeric;
    _vl_cst_med numeric;
begin
    if (tg_op = 'INSERT') then
    
        select 
            ((tb_item_estq.vl_estq * coalesce(tb_item_emp.vl_ult_cst_med, 0)) + (new.vl_qtd * new.vl_prc_cst)) / (tb_item_estq.vl_estq + new.vl_qtd) as vl_cst_med_calc,
            tb_item_estq.vl_estq,
            coalesce(tb_item_emp.vl_ult_cst_med, 0) as vl_ult_cst_med
        into 
            _vl_cst_med_calc, 
            _vl_estq,
            _vl_ult_cst_med
        from tb_item_estq
        join tb_item_emp on
            (tb_item_estq.id_item = tb_item_emp.id_item and
             tb_item_estq.id_emp = tb_item_emp.id_emp)
        where
            tb_item_estq.id_item = new.id_item and
            tb_item_estq.id_emp = new.id_emp and
            tb_item_estq.id_dep = new.id_dep and
            tb_item_estq.id_grd_estq = new.id_grd_estq;
        
        if (_vl_estq > 0 and _vl_ult_cst_med > 0) then
            _vl_cst_med := _vl_cst_med_calc;
        else
            _vl_cst_med := new.vl_prc_cst;
        end if;
            
        update tb_item_emp set
            vl_cst_rep = new.vl_prc_cst,
            vl_cst_med = _vl_cst_med,
            vl_out = new.vl_out_imp,
            vl_perc_desp_op = new.vl_perc_desp_op,
            vl_desp_op = new.vl_desp_op,
            vl_perc_luc = new.vl_perc_luc,
            vl_luc = new.vl_luc,
            vl_prc_vnd = new.vl_prc_vnd,
            id_usr_ult_alt = new.id_usr_ult_alt
        where
            id_emp = new.id_emp and
            id_item = new.id_item;
            
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'E', new.vl_qtd);
        
        return new;
        
    elsif (tg_op = 'DELETE') then
    
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'S', old.vl_qtd);
        
        return old;
        
    end if;
        
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_org_fone (
  _fone varchar
)
RETURNS varchar AS
$body$
declare
    _fone_ddd varchar;
    _prefix varchar;
begin
    
    if (length(_fone) <> 8) and (length(_fone) <> 10) then
        return _fone;
    end if;

    if (length(_fone) = 8) then 
        _fone_ddd := '65' || _fone;
    else
        _fone_ddd := _fone;
    end if;
    
    if (substr(_fone_ddd, 3, 1) = '3') then
        _prefix := '3';
    else
        _prefix := '9';
    end if;
    
    return 
        substr(_fone_ddd, 1, 2) || _prefix || substr(_fone_ddd, 3, 8);
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_fml (
  id_fml INTEGER NOT NULL, 
  id_item INTEGER, 
  vl_qtd NUMERIC(12,4), 
  vl_prc_cst NUMERIC(12,4), 
  vl_out_imp NUMERIC(12,4), 
  vl_perc_desp_op NUMERIC(12,4), 
  vl_desp_op NUMERIC(12,4), 
  vl_perc_luc NUMERIC(12,4), 
  vl_luc NUMERIC(12,4), 
  vl_prc_vnd NUMERIC(12,4),
--  id_usr_ult_alt INTEGER, 
  CONSTRAINT pk_fml PRIMARY KEY(id_fml)
) ;

CREATE TABLE public.tb_fml_item (
  id_fml INTEGER NOT NULL, 
  id_fml_item INTEGER NOT NULL, 
  id_item INTEGER, 
  vl_qtd NUMERIC(12,4), 
  vl_prc_unt NUMERIC(12,4), 
  vl_tot NUMERIC(12,4),
--  id_usr_ult_alt INTEGER, 
  CONSTRAINT pk_fml_item PRIMARY KEY(id_fml, id_fml_item)
) ;

ALTER TABLE public.tb_req
  ADD COLUMN id_usr_ult_alt INTEGER;

CREATE TABLE public.tb_pdc (
  id_emp INTEGER NOT NULL, 
  id_pdc INTEGER NOT NULL, 
  dt_pdc DATE, 
  id_fml INTEGER, 
  id_item INTEGER, 
  vl_qtd NUMERIC(12,4), 
  vl_prc_cst NUMERIC(12,4), 
  vl_out_imp NUMERIC(12,4), 
  vl_perc_desp_op NUMERIC(12,4), 
  vl_desp_op NUMERIC(12,4), 
  vl_perc_luc NUMERIC(12,4), 
  vl_luc NUMERIC(12,4), 
  vl_prc_vnd NUMERIC(12,4), 
  id_dep INTEGER, 
  id_grd_estq VARCHAR(20),
--  id_usr_ult_alt INTEGER, 
  CONSTRAINT pk_pdc PRIMARY KEY(id_emp, id_pdc)
) ;

CREATE TRIGGER tr_pdc_bf
  BEFORE INSERT OR DELETE 
  ON public.tb_pdc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_pdc_bf();

--ALTER TABLE public.tb_req_item
--  ADD COLUMN id_usr_ult_alt INTEGER;

CREATE TABLE public.tb_pdc_item (
  id_emp INTEGER NOT NULL, 
  id_pdc INTEGER NOT NULL, 
  id_pdc_item INTEGER NOT NULL, 
  id_item INTEGER, 
  id_dep INTEGER, 
  id_grd_estq VARCHAR(20), 
  vl_qtd NUMERIC(12,4), 
  vl_prc_unt NUMERIC(12,4), 
  vl_tot NUMERIC(12,4),
--  id_usr_ult_alt INTEGER, 
  CONSTRAINT pk_pdc_item PRIMARY KEY(id_emp, id_pdc, id_pdc_item)
) ;

CREATE TRIGGER tr_pdc_item_bf
  BEFORE INSERT OR DELETE 
  ON public.tb_pdc_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_pdc_item_bf();

ALTER TABLE public.tb_vnd_dev
  ADD COLUMN id_usr_ult_alt INTEGER;

ALTER TABLE public.tb_pdc_item
  ADD CONSTRAINT fk__pdc_item__dep FOREIGN KEY (id_emp, id_dep)
    REFERENCES public.tb_dep(id_emp, id_dep)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc_item
  ADD CONSTRAINT fk__pdc_item__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc_item
  ADD CONSTRAINT fk__pdc_item__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc_item
  ADD CONSTRAINT fk__pdc_item__pdc FOREIGN KEY (id_emp, id_pdc)
    REFERENCES public.tb_pdc(id_emp, id_pdc)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc
  ADD CONSTRAINT fk__pdc__dep FOREIGN KEY (id_emp, id_dep)
    REFERENCES public.tb_dep(id_emp, id_dep)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc
  ADD CONSTRAINT fk__pdc__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc
  ADD CONSTRAINT fk__pdc__fml FOREIGN KEY (id_fml)
    REFERENCES public.tb_fml(id_fml)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc
  ADD CONSTRAINT fk__pdc__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc
  ADD CONSTRAINT fk__pdc__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_fml_item
  ADD CONSTRAINT fk__fml_item__fml FOREIGN KEY (id_fml)
    REFERENCES public.tb_fml(id_fml)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_fml_item
  ADD CONSTRAINT fk__fml_item__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_fml
  ADD CONSTRAINT fk__fml__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

	
	
	
select fc_add_col('public.' || pg_tables.tablename, 'id_usr_ult_alt', 'integer')
from pg_tables
where
    pg_tables.schemaname = 'public';


select fc_add_col('public.' || pg_tables.tablename, 'dt_hr_ult_alt', 'timestamp')
from pg_tables
where
    pg_tables.schemaname = 'public';


select fc_add_col('public.' || pg_tables.tablename, 'id_usr_cad', 'integer')
from pg_tables
where
    pg_tables.schemaname = 'public';


    
select fc_add_col('public.' || pg_tables.tablename, 'dt_hr_cad', 'timestamp')
from pg_tables
where
    pg_tables.schemaname = 'public';