CREATE OR REPLACE FUNCTION public.fc_tr_ch_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'DELETE' and old.tp_ch = 'E') then
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'ch' and
            id_org = old.id_ch;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        if (new.tp_ch = 'E' and tg_op = 'INSERT') then

            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr, 'D', new.vl_ch, new.obs, false, 'ch', new.id_ch, new.id_part);

        elseif (tg_op = 'UPDATE' and (old.sit = 'P' or old.sit = 'D') and new.sit = 'DEP' and new.tp_ch = 'R') then
            
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_sit, new.dt_sit, new.nr, 'C', new.vl_ch, 'DEPOSITO', false, 'ch', new.id_ch, new.id_part);

        elseif (tg_op = 'UPDATE' and new.sit = 'P' and old.sit <> 'P' and new.tp_ch = 'R') then
            delete from tb_mov_bnc
            where
                id_emp = new.id_emp and
                org = 'ch' and
                id_org = new.id_ch;
        end if;

        return new;

    elsif (tg_op = 'DELETE') then

        return old;

    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
            end if;
            
            if (new.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        
            
                
        if (new.at_prc_item) then
            update tb_item_emp set
                vl_cst_rep = new.vl_cst_rep,
                vl_cst_med = new.vl_cst_med,
                dt_ult_cmp = _nf.dt_op,
                vl_out = new.vl_out_prc,
                vl_perc_desp_op = new.vl_perc_desp_op_prc,
                vl_desp_op = new.vl_desp_op_prc,
                vl_perc_luc = new.vl_perc_luc_prc,
                vl_luc = new.vl_luc_prc,
                vl_prc_vnd = new.vl_prc_vnd
            where
                id_emp = new.id_emp and
                id_item = new.id_item;
        else
            update tb_item_emp set
                vl_cst_rep = new.vl_cst_rep,
                vl_cst_med = new.vl_cst_med,
                dt_ult_cmp = _nf.dt_op
            where
                id_emp = new.id_emp and
                id_item = new.id_item;
            
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _vnd record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
            end if;
            
            if (new.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        if (old.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

