CREATE SEQUENCE public.sq_blt
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_blt RESTART WITH 39;

CREATE SEQUENCE public.sq_cnt_bnc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_cnt_bnc RESTART WITH 3;

CREATE SEQUENCE public.sq_emis_blt
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_emis_blt RESTART WITH 3;

CREATE TABLE public.tb_blt (
  id_emp INTEGER NOT NULL, 
  id_blt INTEGER NOT NULL, 
  id_part INTEGER, 
  tp_pes VARCHAR(20), 
  nome VARCHAR(150), 
  cpf_cnpj VARCHAR(20), 
  cep VARCHAR(10), 
  logr VARCHAR(200), 
  num VARCHAR(20), 
  compl VARCHAR(200), 
  bairro VARCHAR(200), 
  id_munic INTEGER, 
  vl_dup NUMERIC(12,4), 
  dt_emis_dup DATE, 
  dt_venc_dup DATE, 
  loc_pagto VARCHAR(255), 
  esp_doc_cobr VARCHAR(10), 
  esp_moeda_cobr VARCHAR(5), 
  aceite_cobr BOOLEAN, 
  cart_cobr VARCHAR(10), 
  msg VARCHAR(255), 
  instr1 VARCHAR(100), 
  instr2 VARCHAR(100), 
  id_cnt_bnc INTEGER, 
  sit VARCHAR(50), 
  vl_pag NUMERIC(12,4), 
  dt_pag DATE, 
  email VARCHAR(255)
) WITHOUT OIDS;

CREATE TABLE public.tb_bnc_blt (
  id_bnc CHAR(3) NOT NULL, 
  id_emp INTEGER NOT NULL, 
  esp_doc VARCHAR(10), 
  esp_moeda VARCHAR(5), 
  cart VARCHAR(10), 
  aceite BOOLEAN, 
  loc_pagto VARCHAR(255), 
  msg VARCHAR(255), 
  instr1 VARCHAR(255), 
  instr2 VARCHAR(255), 
  conv VARCHAR(50), 
  cd_ced VARCHAR(20), 
  mod VARCHAR(20), 
  lay_arq VARCHAR(20)
) WITHOUT OIDS;

CREATE TABLE public.tb_cnt_bnc (
  id_emp INTEGER NOT NULL, 
  id_cnt_bnc INTEGER NOT NULL, 
  id_bnc CHAR(3), 
  ag VARCHAR(20), 
  ag_dig VARCHAR(5), 
  cnt VARCHAR(20), 
  cnt_dig VARCHAR(5)
) WITHOUT OIDS;

CREATE TABLE public.tb_emis_blt (
  id_emp INTEGER NOT NULL, 
  id_emis_blt INTEGER NOT NULL, 
  descr VARCHAR(255), 
  id_cnt_bnc INTEGER
) WITHOUT OIDS;

CREATE TABLE public.tb_emis_blt_part (
  id_emp INTEGER NOT NULL, 
  id_emis_blt INTEGER NOT NULL, 
  id_part INTEGER NOT NULL, 
  vl_dup NUMERIC(12,4), 
  dt_emis DATE, 
  qtd INTEGER, 
  tp_interv CHAR(1), 
  interv INTEGER, 
  dt_venc DATE, 
  id_blt INTEGER
) WITHOUT OIDS;

ALTER TABLE public.tb_grp_trib_nat_op
  ADD COLUMN mod_bc_icms CHAR(1);

ALTER TABLE public.tb_grp_trib_nat_op
  ADD COLUMN vl_perc_red_bc_icms NUMERIC(12,4);

ALTER TABLE public.tb_grp_trib_nat_op
  ADD COLUMN mod_bc_icms_st CHAR(1);

ALTER TABLE public.tb_grp_trib_nat_op
  ADD COLUMN vl_perc_red_bc_icms_st NUMERIC(12,4);

COMMENT ON COLUMN public.tb_nf.id_munic_fg
IS 'Municpio de Ocorrncia do Fato Gerador';

COMMENT ON COLUMN public.tb_nf.im_emt
IS 'Inscrio municipal';

COMMENT ON COLUMN public.tb_nf.isuf_dst
IS 'Inscrio Suframa';

ALTER TABLE public.tb_nf_item
  ADD COLUMN id_und_med_mov VARCHAR(5);

ALTER TABLE public.tb_nf_item
  ADD COLUMN vl_qtd_mov NUMERIC(12,4);

CREATE TABLE public.tb_script (
  id_script INTEGER NOT NULL, 
  dt_hr TIMESTAMP WITHOUT TIME ZONE, 
  arq VARCHAR(255)
) WITHOUT OIDS;

COMMENT ON COLUMN public.tb_vnd.tp_vnd
IS '[V] Venda [O] Oramento [C] Condicional';

ALTER TABLE public.tb_script
  ADD CONSTRAINT pk_script 
    PRIMARY KEY (id_script);

ALTER TABLE public.tb_emis_blt_part
  ADD CONSTRAINT pk_emis_blt_part 
    PRIMARY KEY (id_emp, id_emis_blt, id_part);

ALTER TABLE public.tb_emis_blt
  ADD CONSTRAINT pk_emis_blt 
    PRIMARY KEY (id_emp, id_emis_blt);

ALTER TABLE public.tb_cnt_bnc
  ADD CONSTRAINT pk_cnt_bnc 
    PRIMARY KEY (id_emp, id_cnt_bnc);

ALTER TABLE public.tb_bnc_blt
  ADD CONSTRAINT pk_bnc_blt 
    PRIMARY KEY (id_bnc, id_emp);

ALTER TABLE public.tb_blt
  ADD CONSTRAINT pk_blt 
    PRIMARY KEY (id_emp, id_blt);

ALTER TABLE public.tb_vnd_parc
  ADD CONSTRAINT fk__vnd_parc__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd_item
  ADD CONSTRAINT fk__vnd_item__und_med_mov FOREIGN KEY (id_und_med_mov)
    REFERENCES public.tb_und_med(id_und_med)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd_item
  ADD CONSTRAINT fk__vnd_item__und_med FOREIGN KEY (id_und_med)
    REFERENCES public.tb_und_med(id_und_med)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd_item
  ADD CONSTRAINT fk__vnd_item__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd
  ADD CONSTRAINT fk__vnd__munic FOREIGN KEY (id_munic)
    REFERENCES public.tb_munic(id_munic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd
  ADD CONSTRAINT fk__vnd__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd
  ADD CONSTRAINT fk__vnd__cli FOREIGN KEY (id_cli)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_ref
  ADD CONSTRAINT fk__part_ref__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_op_fnc
  ADD CONSTRAINT fk__part_op_fnc__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_op_fnc
  ADD CONSTRAINT fk__part_op_fnc__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_obs
  ADD CONSTRAINT fk__part_obs__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_cred
  ADD CONSTRAINT fk__part_cred__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_nf_item
  ADD CONSTRAINT fk__nf_item__und_med_mov FOREIGN KEY (id_und_med_mov)
    REFERENCES public.tb_und_med(id_und_med)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mnt_estq_item
  ADD CONSTRAINT fk__mnt_estq_item__und_med_mov FOREIGN KEY (id_und_med_mov)
    REFERENCES public.tb_und_med(id_und_med)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mnt_estq_item
  ADD CONSTRAINT fk__mnt_estq_item__und_med FOREIGN KEY (id_und_med)
    REFERENCES public.tb_und_med(id_und_med)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mnt_estq_item
  ADD CONSTRAINT fk__mnt_estq_item__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_und_med
  ADD CONSTRAINT fk__item_und_med__und_med FOREIGN KEY (id_und_med)
    REFERENCES public.tb_und_med(id_und_med)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_estq
  ADD CONSTRAINT fk__item_estq__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_estq
  ADD CONSTRAINT fk__item_estq__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_emp
  ADD CONSTRAINT tfk__item_prc_cst__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item
  ADD CONSTRAINT fk__item__tp_item FOREIGN KEY (id_tp_item)
    REFERENCES public.tb_tp_item(id_tp_item)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item
  ADD CONSTRAINT fk__item__ncm FOREIGN KEY (id_ncm)
    REFERENCES public.tb_ncm(id_ncm)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_trib_nat_op
  ADD CONSTRAINT fk__grp_trib_nat_op__trib_pis FOREIGN KEY (id_trib_pis)
    REFERENCES public.tb_trib_pis(id_trib_pis)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_trib_nat_op
  ADD CONSTRAINT fk__grp_trib_nat_op__trib_ipi FOREIGN KEY (id_trib_ipi)
    REFERENCES public.tb_trib_ipi(id_trib_ipi)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_trib_nat_op
  ADD CONSTRAINT fk__grp_trib_nat_op__trib_icms FOREIGN KEY (id_trib_icms)
    REFERENCES public.tb_trib_icms(id_trib_icms)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_trib_nat_op
  ADD CONSTRAINT fk__grp_trib_nat_op__trib_cofins FOREIGN KEY (id_trib_cofins)
    REFERENCES public.tb_trib_cofins(id_trib_cofins)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_trib_nat_op
  ADD CONSTRAINT fk__grp_trib_nat_op__nat_op FOREIGN KEY (id_nat_op)
    REFERENCES public.tb_nat_op(id_nat_op)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_cfop_nat_op
  ADD CONSTRAINT fk__grp_cfop_nat_op__nat_op FOREIGN KEY (id_nat_op)
    REFERENCES public.tb_nat_op(id_nat_op)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_cfop_nat_op
  ADD CONSTRAINT fk__grp_cfop_nat_op__cfop_f FOREIGN KEY (id_cfop_f)
    REFERENCES public.tb_cfop(id_cfop)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_cfop_nat_op
  ADD CONSTRAINT fk__grp_cfop_nat_op__cfop_d FOREIGN KEY (id_cfop_d)
    REFERENCES public.tb_cfop(id_cfop)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_emp_cnf
  ADD CONSTRAINT fk__emp_cnf__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_emis_blt_part
  ADD CONSTRAINT fk__emis_blt_part__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_emis_blt_part
  ADD CONSTRAINT fk__emis_blt_part__emis_blt FOREIGN KEY (id_emp, id_emis_blt)
    REFERENCES public.tb_emis_blt(id_emp, id_emis_blt)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_emis_blt
  ADD CONSTRAINT fk__emis_blt__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_emis_blt
  ADD CONSTRAINT fk__emis_blt__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_dep
  ADD CONSTRAINT fk__dep__part FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ct
  ADD CONSTRAINT fk__ct__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ct
  ADD CONSTRAINT fk__ct__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cnt_bnc
  ADD CONSTRAINT fk__cnt_bnc__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cnt_bnc
  ADD CONSTRAINT fk__cnt_bnc__bnc FOREIGN KEY (id_bnc)
    REFERENCES public.tb_bnc(id_bnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ch
  ADD CONSTRAINT fk__ch__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ch
  ADD CONSTRAINT fk__ch__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ch
  ADD CONSTRAINT fk__ch__bnc FOREIGN KEY (id_bnc)
    REFERENCES public.tb_bnc(id_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_bnc_blt
  ADD CONSTRAINT fk__bnc_blt__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_bnc_blt
  ADD CONSTRAINT fk__bnc_blt__bnc FOREIGN KEY (id_bnc)
    REFERENCES public.tb_bnc(id_bnc)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_blt
  ADD CONSTRAINT fk__blt__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_blt
  ADD CONSTRAINT fk__blt__munic FOREIGN KEY (id_munic)
    REFERENCES public.tb_munic(id_munic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_blt
  ADD CONSTRAINT fk__blt__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_blt
  ADD CONSTRAINT fk__blt__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

