CREATE SEQUENCE public.sq_setor
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_setor (
  id_setor INTEGER NOT NULL, 
  descr VARCHAR(150), 
  op VARCHAR(255), 
  imp VARCHAR(150), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_setor PRIMARY KEY(id_setor)
) ;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_rem_act (
  text
)
RETURNS text AS
$body$
    select
        translate($1,'áàâãäéèêëíìïóòôõöúùûüÁÀÂÃÄÉÈÊËÍÌÏÓÒÔÕÖÚÙÛÜçÇ',
            'aaaaaeeeeiiiooooouuuuAAAAAEEEEIIIOOOOOUUUUcC');
$body$
LANGUAGE 'sql'
IMMUTABLE
RETURNS NULL ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_item
  ADD COLUMN id_setor INTEGER;

ALTER TABLE public.tb_vnd_item
  ADD COLUMN sit VARCHAR(10);

ALTER TABLE public.tb_vnd_item
  ADD COLUMN obs VARCHAR(255);

ALTER TABLE public.tb_item
  ADD CONSTRAINT fk__item__setor FOREIGN KEY (id_setor)
    REFERENCES public.tb_setor(id_setor)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

