CREATE TABLE public.tb_ir (
  vl_i NUMERIC(12,2), 
  vl_f NUMERIC(12,2), 
  vl_aliq NUMERIC(12,2), 
  vl_ded NUMERIC(12,2), 
  dt_i DATE, 
  dt_f DATE, 
  vl_depend NUMERIC(12,2)
) ;

ALTER TABLE public.tb_grp_disp
  ADD COLUMN vl_perc_cst_op NUMERIC(12,2);

ALTER TABLE public.tb_grp_disp
  ADD COLUMN vl_perc_bc_ir NUMERIC(12,2);

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_trunc_up (
  p_val numeric,
  p_dig integer
)
RETURNS numeric AS
$body$
declare
    _vl_result numeric;
begin
    _vl_result := trunc("p_val", "p_dig");

    if ("p_val" - _vl_result > 0) then
        return _vl_result + (1 / power(10, "p_dig"));
    else
        return _vl_result;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_calc_ir (
  _id_part integer,
  _dt date,
  _vl numeric
)
RETURNS numeric AS
$body$
declare
    _qtd_depend integer;
    _vl_abat_ir numeric;
    _vl_bc_ir numeric;
    _vl_ir numeric;
    _part record;
    _vl_depend numeric;
begin
    
    select count(*) into _qtd_depend
    from tb_part_cred
    where
        id_part = _id_part;
        
    select 
        distinct tb_ir.vl_depend 
    into _vl_depend
    from tb_ir
    where
        _dt between tb_ir.dt_i and tb_ir.dt_f;
        

    select
        tb_part.id_part,
        tb_part.vl_pa,
        tb_grp_disp.vl_perc_bc_ir,
        sum(
            case 
                when tb_disp.tp = 'V' then tb_grp_disp_item.vl_disp
                else _vl * tb_grp_disp_item.vl_disp / 100
            end 
        ) as vl_abat_ir
    into
        _part
    from tb_part
    join tb_grp_disp on
        (tb_part.id_grp_disp = tb_grp_disp.id_grp_disp)
    join tb_grp_disp_item on
        (tb_part.id_grp_disp = tb_grp_disp_item.id_grp_disp)
    join tb_disp on
        (tb_grp_disp_item.id_disp = tb_disp.id_disp)
    where 
        tb_part.id_part = _id_part and
        tb_disp.abat_ir
    group by
        tb_part.id_part,
        tb_part.vl_pa,
        tb_grp_disp.vl_perc_bc_ir;
        
    
    
    _vl_bc_ir := cast(coalesce(_vl * _part.vl_perc_bc_ir / 100, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - coalesce(_part.vl_pa, 0);
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - cast(coalesce(_vl_depend * _qtd_depend, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - cast(coalesce(_part.vl_abat_ir, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;

    select 
        sum(vl_ir)
    into
        _vl_ir
    from
    (
        select
            *,
            "fc_trunc_up"(
                case
                    when (vl_aliq > 0) then
                        (vl_bc * vl_aliq / 100)
                    else 0
                end 
            , 2) as vl_ir
        from
        (
            select 
                tb_ir.*,
                cast(
                    case 
                        when (_vl_bc_ir > vl_f) then vl_f - vl_i
                        when (_vl_bc_ir between vl_i and vl_f) then _vl_bc_ir - vl_i
                    end 
                as numeric(12,2)) as vl_bc
            from tb_ir
            where
                _dt between tb_ir.dt_i and tb_ir.dt_f
            order by
                vl_i
        ) as "tb"
    ) as "tb";
    
    
    return _vl_ir;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_ctb_cnf (
  id_emp INTEGER NOT NULL, 
  id_cnf INTEGER NOT NULL, 
  val TEXT, 
  CONSTRAINT pk_ctb_cnf PRIMARY KEY(id_emp, id_cnf)
) ;

ALTER TABLE public.tb_part_cred
  ADD COLUMN depend_ir BOOLEAN;

ALTER TABLE public.tb_part
  ADD COLUMN vl_pa NUMERIC(12,2);

ALTER TABLE public.tb_ctb_cnf
  ADD CONSTRAINT fk__ctb_cnf__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

