CREATE SEQUENCE public.sq_agnd
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE OR REPLACE FUNCTION public.fc_limpa_db (
)
RETURNS boolean AS
$body$
declare
    _list refcursor;
    _item record;
begin
    perform fc_en_trg(false, true);
    
    open _list for
        select pg_tables.tablename
        from pg_tables
        where
            pg_tables.schemaname = 'public';
    
    fetch _list into _item;
    
    while (found) loop
        if (_item.tablename not in ('tb_part', 'tb_munic', 'tb_bairro', 'tb_bnc', 'tb_cfop',
            'tb_cnae', 'tb_cond_pagto', 'tb_cond_pagto_parc', 'tb_conv', 'tb_cx', 'tb_dep', 
            'tb_emp_cnf', 'tb_est', 'tb_est_cnf', 'tb_etq', 'tb_etq_cmp', 'tb_grd_estq', 
            'tb_grp_cfop', 'tb_grp_cfop_nat_op', 'tb_grp_trib', 'tb_grp_trib_nat_op',
            'tb_grp_usr', 'tb_grp_usr_op', 'tb_logr', 'tb_mod_frete', 'tb_mod_nf',
            'tb_mtv_dev_ch', 'tb_nat_op', 'tb_ncm', 'tb_op_fnc', 'tb_org_icms', 'tb_plano_ct', 'tb_prio_os',
            'tb_prod_anp', 'tb_reg_trib', 'tb_rel', 'tb_rel_cab', 'tb_rel_col', 'tb_rel_item',
            'tb_rel_item_col', 'tb_rel_item_tot', 'tb_script', 'tb_serv')) then
            
            execute 'delete from "' || _item.tablename || '"';
        end if;
            
    
        fetch _list into _item;
    end loop;
    
    delete from "tb_part" where tp_part not like '%[E]%' or tp_part is null;
    
    perform fc_en_trg(true, false);
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_agnd (
  id_agnd INTEGER NOT NULL, 
  nome VARCHAR(150), 
  fone1 VARCHAR(20), 
  fone2 VARCHAR(20), 
  fone3 VARCHAR(20), 
  email VARCHAR(255), 
  obs VARCHAR(255), 
  CONSTRAINT pk_agnd PRIMARY KEY(id_agnd)
);