SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_get_seq_mov_fnc (
  _id_emp integer,
  _id_cx integer
)
RETURNS integer AS
$body$
declare
    _seq integer;
    _mov_cx record;
begin
    select * into _mov_cx
    from tb_mov_cx
    where
        id_emp = _id_emp and
        id_cx = _id_cx and
        sit = 'A'
    order by
        dt_i desc, 
        hr_i desc
    limit 1;
        
    select max(coalesce(seq, 0)) into _seq
    from tb_mov_fnc
    where
        id_emp = _mov_cx.id_emp and
        id_cx = _mov_cx.id_cx and
        dt_lanc + hr_lanc >= _mov_cx.dt_i + _mov_cx.hr_i;
            
    return coalesce(_seq, 0) + 1;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

