CREATE SEQUENCE public.sq_item_alt_prc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE OR REPLACE FUNCTION public.fc_tr_item_emp_bf (
)
RETURNS trigger AS
$body$
BEGIN
    if (old.vl_cst_med <> new.vl_cst_med or
        old.vl_cst_rep <> new.vl_cst_rep or
        old.vl_prc_vnd <> new.vl_prc_vnd) then
        
        insert into tb_item_alt_prc
            (id_emp, id_item_alt_prc, id_item, dt_hr, 
             vl_cst_rep_ant, vl_cst_rep_atu, 
             vl_cst_med_ant, vl_cst_med_atu, 
             vl_prc_vnd_ant, vl_prc_vnd_atu)
        values 
            (new.id_emp, nextval('sq_item_alt_prc'), new.id_item, current_timestamp,
             old.vl_cst_rep, new.vl_cst_rep,
             old.vl_cst_med, new.vl_cst_med,
             old.vl_prc_vnd, new.vl_prc_vnd);

    end if;
    
    return new;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq) then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        
            
                
        if (new.at_prc_item) then
            update tb_item_emp set
                vl_cst_rep = new.vl_cst_rep,
                vl_cst_med = new.vl_cst_med,
                dt_ult_cmp = _nf.dt_op,
                vl_out = new.vl_out_prc,
                vl_perc_desp_op = new.vl_perc_desp_op_prc,
                vl_desp_op = new.vl_desp_op_prc,
                vl_perc_luc = new.vl_perc_luc_prc,
                vl_luc = new.vl_luc_prc,
                vl_prc_vnd = new.vl_prc_vnd
            where
                id_emp = new.id_emp and
                id_item = new.id_item;
        else
            update tb_item_emp set
                vl_cst_rep = new.vl_cst_rep,
                vl_cst_med = new.vl_cst_med,
                dt_ult_cmp = _nf.dt_op
            where
                id_emp = new.id_emp and
                id_item = new.id_item;
            
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_item_alt_prc (
  id_emp INTEGER NOT NULL, 
  id_item_alt_prc BIGINT NOT NULL, 
  id_item INTEGER, 
  dt_hr TIMESTAMP WITHOUT TIME ZONE, 
  vl_cst_rep_ant NUMERIC(12,4), 
  vl_cst_rep_atu NUMERIC(12,4), 
  vl_cst_med_ant NUMERIC(12,4), 
  vl_cst_med_atu NUMERIC(12,4), 
  vl_prc_vnd_ant NUMERIC(12,4), 
  vl_prc_vnd_atu NUMERIC(12,4)
) WITHOUT OIDS;

CREATE TABLE public.tb_sis_lay (
  org VARCHAR(255) NOT NULL, 
  param VARCHAR(255) NOT NULL, 
  val VARCHAR(255)
) WITHOUT OIDS;

DROP TABLE public.tb_item_prc_vnd_log;

ALTER TABLE public.tb_sis_lay
  ADD CONSTRAINT pk_sis_lay 
    PRIMARY KEY (org, param);

ALTER TABLE public.tb_item_alt_prc
  ADD CONSTRAINT pk_item_alt_prc 
    PRIMARY KEY (id_emp, id_item_alt_prc);

ALTER TABLE public.tb_item_alt_prc
  ADD CONSTRAINT fk__item_alt_prc__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_alt_prc
  ADD CONSTRAINT fk__item_alt_prc__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_item_emp_bf
  BEFORE UPDATE 
  ON public.tb_item_emp FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_item_emp_bf();

