CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;
    _op varchar;
    _id_part_ct integer;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'BX' and
            id_org = old.id_bx_ct and
            id_org_item = old.id_bx_ct_pagto;
            -- org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            tp_org = 'BX' and
            id_org = old.id_bx_ct and
            id_org_item = old.id_bx_ct_pagto;
            -- org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
        update tb_pix set
            id_org = null
        where
            id_emp = old.id_emp and
            id_pix = old.id_pix;
            
    	update tb_trn_tef set
            sit = 'C'
        where
            id_emp = old.id_emp and
            id_trn_tef = old.id_trn_tef;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct and coalesce(_bx_ct.org, '') not like 'CT.%') then
        
            if (_bx_ct.op = 'A') then
                _op := ifthen(new.op = 'C', 'R', 'P');
            else
                _op := ifthen(_bx_ct.tp_bx = 'R', 'R', 'P');
            end if;
            
            if (_op_fnc.id_part_ct is not null and _bx_ct.op = 'A' and _op_fnc.tp_op_fnc = 'REQ') then
                _id_part_ct := _op_fnc.id_part_ct;
            else
                _id_part_ct := _bx_ct.id_part;
            end if;
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, id_op_fnc, vl_quit, vl_rest,
                 org, tp_org, id_org, id_org_item,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), _op, _op_fnc.tp_op_fnc, _id_part_ct, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, new.id_op_fnc, 0, new.vl_pagto,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, 'BX', new.id_bx_ct, new.id_bx_ct_pagto, 
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.comp_cad, _bx_ct.comp_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        _descr_part := '';
        
        if (_bx_ct.op = 'A') then
            _descr := 'ACERTO ' || _bx_ct.num_doc;
            
            if (new.obs is not null) then
                _descr_part := ' - ' || new.obs;
            end if;
          
        elsif (_bx_ct.org like 'BX_MOV_FUNC.%' and coalesce(new.obs, '') <> '') then
            
            _descr := new.obs;
            
        else
            select nome into _descr_part
            from tb_part
            where
                id_part = _bx_ct.id_part;
                
            if (_descr_part is null) then
                _descr_part := '';
            else
                _descr_part := ' ' || _descr_part;
            end if;
            
            if (new.obs is not null) then
                _descr_part := _descr_part || ' ' || new.obs;
            end if;
            
            if (_bx_ct.org like 'PAG_COOP%') then
                _descr := 'PAGTO PROD COOP ';
            else
                _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
            end if;
        end if;
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
        
            if (_bx_ct.op = 'A') then
                _op := new.op;
            else
                _op := ifthen(_bx_ct.tp_bx = 'R', 'C', 'D');
            end if;
        
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, tp_org, id_org, id_org_item,
                 id_part, sit_conc,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, _op, new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, 'BX', new.id_bx_ct, new.id_bx_ct_pagto,
                 _bx_ct.id_part, 'PEND',
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.comp_cad, _bx_ct.comp_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
        
        if (_op_fnc.tp_op_fnc = 'PIX' and new.id_pix is not null) then
            
            update tb_pix set
                id_org = new.id_bx_ct
            where
                id_emp = new.id_emp and
                id_pix = new.id_pix;
            
        end if;
        
        if (_op_fnc.tp_op_fnc in ('CART', 'CART_DEB') and new.id_trn_tef is not null) then
            
            update tb_trn_tef set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_trn_tef = new.id_trn_tef;
            
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _id_cli_cons varchar;
    
    _list refcursor;
    _item record;
    
begin
    _app_con := fc_app_con();

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
    
        if (new.org = 'CONSIG') then
            update tb_consig set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_consig = new.id_org;
        end if;
        
        _id_cli_cons := fc_get_emp_cnf(new.id_emp, 01000);
        
        if (cast(new.id_cli as varchar) <> _id_cli_cons) then
            
            update tb_part set
                id_cond_pagto = new.id_cond_pagto,
                id_fm_pagto = new.id_fm_pagto
            where
                id_part = new.id_cli;
                
        end if;
        
        if (new.id_sit_vnd is not null and new.cd_ref is not null) then
            perform fc_vnd_ident_sit(new.id_emp, cast(new.cd_ref as integer), new.id_sit_vnd);
        end if;
        
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        if (old.org = 'CONSIG') then
            update tb_consig set
                sit = 'D'
            where
                id_emp = old.id_emp and
                id_consig = old.id_org;
        end if;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            tp_org = 'VND' and
            id_org = old.id_vnd;
            -- org like 'VND.' || old.id_vnd || '%';
    
    end if;
    
    
    --
    -- Venda cancelada ( mesmo se vier do neo UNI )
    --
    if (tg_op = 'UPDATE' and new.canc = true and new.canc <> old.canc) then
        --
        -- extorna o estoque
        --
        open _list for
            select *
            from tb_vnd_item
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd and
                mov_estq;

        fetch _list into _item;
                
            
        while found loop
                
            perform fc_item_estq(_item.id_item, _item.id_emp, _item.id_dep, _item.id_grd_estq, 'E', _item.vl_qtd_mov);
                
            fetch _list into _item;
                
        end loop;
            
        close _list;
            
        --
        -- extorna contas a receber, mov banco, pix
        --
        open _list for 
            select *
            from tb_vnd_parc
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                    
        fetch _list into _item;
            
        while found loop
                
            delete from tb_ct
            where 
                id_emp = new.id_emp and
                tp_org = 'VND' and
                id_org = new.id_vnd and
                id_org_item = _item.id_vnd_parc;
                -- org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
            delete from tb_mov_bnc
            where 
                id_emp = new.id_emp and
                tp_org = 'VND' and
                id_org = new.id_vnd and
                id_org_item = _item.id_vnd_parc;
--                 org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
            update tb_pix set
                id_org = null
            where
                id_emp = new.id_emp and
                id_pix = _item.id_pix;
                
            update tb_trn_tef set
                sit = 'C'
            where
                id_emp = new.id_emp and
                id_trn_tef = _item.id_trn_tef;
            
            fetch _list into _item;
                
        end loop;
            
    end if;
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
    
    _id_plano_ct varchar;
    
    _ct record;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                tp_org = 'VND' and
                id_org = old.id_vnd and
                id_org_item = old.id_vnd_parc;
                -- org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
            
            delete from tb_mov_bnc
            where 
                id_emp = old.id_emp and
                tp_org = 'VND' and
                id_org = old.id_vnd and
                id_org_item = old.id_vnd_parc;
                -- org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;

            update tb_pix set
                id_org = null
            where
                id_emp = old.id_emp and
                id_pix = old.id_pix;
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select * into _vnd
            from tb_vnd
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                
                
            select tb_nat_op.* into _nat_op
            from tb_vnd
            join tb_nat_op on
                (tb_vnd.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_vnd.id_emp = new.id_emp and
                tb_vnd.id_vnd = new.id_vnd;
                    
            _gera_fin := _nat_op.op like '%[VND__GER_FIN]%';
            
            
            /*_id_plano_ct := fc_get_emp_cnf(new.id_emp, 16100 + _op_fnc.id_op_fnc);
                
            if (_id_plano_ct = '') then
                _id_plano_ct := null;
            end if;
            
            if (_nat_op.id_plano_ct is not null) then
                _id_plano_ct := _nat_op.id_plano_ct;
            end if;*/
            

            if (_op_fnc.gera_ct and _gera_fin) then
                    
                _nr_doc := new.nr_doc;
                    
                if (_op_fnc.tp_op_fnc = 'DUP' and coalesce(_nr_doc, '') = '') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
                
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org, tp_org, id_org, id_org_item,
                     id_op_fnc, vl_quit, vl_rest, 
                     obs,
                     id_plano_ct, id_cnt_cst,
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_veic)
                values
                    (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, 'VND', new.id_vnd, new.id_vnd_parc,
                     new.id_op_fnc, 0, new.vl_parc, 
                     'VENDA ' || new.id_vnd,
                     new.id_plano_ct, new.id_cnt_cst,
                     new.vl_sub_tot, coalesce(new.vl_perc_desc, 0), coalesce(new.vl_desc, 0), coalesce(new.vl_perc_acr, 0), coalesce(new.vl_acr, 0), 
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.comp_cad, _vnd.comp_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     _vnd.id_veic);
                
                
                if (_op_fnc.tp_op_fnc = 'BLT') then
                    select * into _ct
                    from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_ct = _id_ct;
                        
                    new.nr_doc := _ct.nr_doc;
                    
--                    raise notice '12345 Boleto %', new.nr_doc;
                    
                elsif (_op_fnc.tp_op_fnc = 'DUP') then
                    new.nr_doc := cast(_id_ct as varchar);
                    
--                    raise notice '12345 Duplicata %', new.nr_doc;
                    
                end if;
            end if;
                
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, tp_org, id_org, id_org_item,
                     id_part, sit_conc,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_plano_ct, id_cnt_cst,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, 'VND', new.id_vnd, new.id_vnd_parc,
                     _vnd.id_cli, 'PEND',
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.comp_cad, _vnd.comp_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     new.id_plano_ct, new.id_cnt_cst,
                     new.id_op_fnc);
            end if;
            
            if (_op_fnc.tp_op_fnc = 'PIX' and _gera_fin and new.id_pix is not null) then
            
                update tb_pix set
                    id_org = new.id_vnd
                where
                    id_emp = new.id_emp and
                    id_pix = new.id_pix;
            
            end if;
            
            if (_op_fnc.tp_op_fnc in ('CART', 'CART_DEB') and new.id_trn_tef is not null) then
            
                update tb_trn_tef set
                    sit = 'F'
                where
                    id_emp = new.id_emp and
                    id_trn_tef = new.id_trn_tef;
            
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_bx_ct_pagto
  ADD COLUMN id_trn_tef INTEGER;