CREATE OR REPLACE FUNCTION public.fc_get_pk (
  p_tb_name varchar
)
RETURNS varchar [] AS
$body$
declare
    _pk varchar[];
begin

    select pk into _pk
    from tb_sis_uni
    where
        tab = p_tb_name;
        
    if (not found) then
        select
            array(
                select 
                    cast(c.column_name as varchar)
                from information_schema.table_constraints tc
                join information_schema.constraint_column_usage as ccu using 
                    (constraint_schema, constraint_name)
                join information_schema.columns as c on 
                    (c.table_schema = tc.constraint_schema and 
                     tc.table_name = c.table_name and 
                     ccu.column_name = c.column_name)
                where 
                    constraint_type = 'PRIMARY KEY' and
                    tc.table_name = p_tb_name
                )
        into _pk;
        
        if (not found) then
            return null;
        end if;
        
        insert into tb_sis_uni
            (tab, pk)
        values
            (tg_table_name, _pk);
        
    end if;

    return _pk;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;