CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
            end if;
            
            if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        
            
        if (_nf.tp_emis = '[T]') then
        
            select * into _nat_op
            from tb_nat_op
            where
                id_nat_op = _nf.id_nat_op;
            
            if (_nat_op.op like '%[NF_REC__AT_PRC_CST]%') then
                update tb_item_emp set
                    vl_cst_rep = new.vl_cst_rep,
                    vl_cst_med = new.vl_cst_med,
                    dt_ult_cmp = _nf.dt_op
                where
                    id_emp = new.id_emp and
                    id_item = new.id_item;
            end if;
            
            if (new.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_VND]%') then
                update tb_item_emp set
                    vl_out = new.vl_out_prc,
                    vl_perc_desp_op = new.vl_perc_desp_op_prc,
                    vl_desp_op = new.vl_desp_op_prc,
                    vl_perc_luc = new.vl_perc_luc_prc,
                    vl_luc = new.vl_luc_prc,
                    vl_prc_vnd = new.vl_prc_vnd
                where
                    id_emp = new.id_emp and
                    id_item = new.id_item;
            else
                
                
            end if;
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq and coalesce(old.mov_grd_estq, false) = false) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_grd_estq_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        if (tg_op = 'UPDATE') then
            if (new.vl_qtd <> old.vl_qtd) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'S', old.vl_qtd);
            end if;
                
            if (new.vl_qtd <> old.vl_qtd) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'E', new.vl_qtd);
            end if;
        end if;
            
        if (tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'E', new.vl_qtd);
        end if;
        
        return new;
        
    elsif (tg_op = 'DELETE') then
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'S', old.vl_qtd);
    
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

select fc_en_trg(false, false);

delete from tb_usr__emp where id_emp is null;

select fc_en_trg(true,true);



ALTER TABLE public.tb_nf_item
  ADD COLUMN mov_grd_estq BOOLEAN;

ALTER TABLE public.tb_nf_item_grd_estq
  ALTER COLUMN id_emp SET NOT NULL;

ALTER TABLE public.tb_nf_item_grd_estq
  ALTER COLUMN id_nf SET NOT NULL;

ALTER TABLE public.tb_nf_item_grd_estq
  ALTER COLUMN id_nf_item SET NOT NULL;

ALTER TABLE public.tb_nf_item_grd_estq
  ADD COLUMN id_nf_item_grd_estq INTEGER NOT NULL;

ALTER TABLE public.tb_nf_item_grd_estq
  ADD COLUMN id_item INTEGER;

ALTER TABLE public.tb_nf_item_grd_estq
  ADD COLUMN id_dep INTEGER;

ALTER TABLE public.tb_nf_item_grd_estq
  ALTER COLUMN id_grd_estq TYPE VARCHAR(20);

ALTER TABLE public.tb_nf_item_pt_prc
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;

ALTER TABLE public.tb_usr__emp
  ALTER COLUMN id_usr SET NOT NULL;

ALTER TABLE public.tb_usr__emp
  ALTER COLUMN id_emp SET NOT NULL;

ALTER TABLE public.tb_usr__emp
  ADD CONSTRAINT pk_usr__emp 
    PRIMARY KEY (id_usr, id_emp);

ALTER TABLE public.tb_sis_part
  ADD CONSTRAINT pk_sis_part 
    PRIMARY KEY (id_part);

ALTER TABLE public.tb_nf_item_grd_estq
  ADD CONSTRAINT pk_nf_item_grd_estq 
    PRIMARY KEY (id_emp, id_nf, id_nf_item, id_nf_item_grd_estq);

ALTER TABLE public.tb_nf_item_grd_estq
  ADD CONSTRAINT fk__nf_item_grd_estq__nf_item FOREIGN KEY (id_emp, id_nf, id_nf_item)
    REFERENCES public.tb_nf_item(id_emp, id_nf, id_nf_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_nf_item_grd_estq
  ADD CONSTRAINT fk__nf_item_grd_estq__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_nf_item_grd_estq
  ADD CONSTRAINT fk__nf_item_grd_estq__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_nf_item_grd_estq
  ADD CONSTRAINT fk__nf_item_grd_estq__dep FOREIGN KEY (id_emp, id_dep)
    REFERENCES public.tb_dep(id_emp, id_dep)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;
CREATE TRIGGER tr_nf_item_grd_estq_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_nf_item_grd_estq FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_nf_item_grd_estq_bf();