CREATE OR REPLACE FUNCTION public.fc_fec_ped_compl (
  _id_emp integer,
  _id_ped integer,
  _id_dep_org integer,
  _id_dep_dst integer
)
RETURNS boolean AS
$body$
declare
    _ped record;
    _ped_item record;
    _ped_item_list refcursor;
    
    _id_mnt_estq integer;
    _id_mnt_estq_item integer;
    
    _id_grd_estq varchar;
begin

    _id_grd_estq := fc_get_emp_cnf(_id_emp, 08004);
    
    select * into _ped
    from tb_ped
    where
        id_emp = _id_emp and
        id_ped = _id_ped;
    
    delete from tb_mnt_estq
    where
        id_emp = _id_emp and
        org = 'PED.' || _id_ped and
        id_org = _id_ped;
        
        
    _id_mnt_estq := nextval('sq_mnt_estq');
    
    insert into tb_mnt_estq
        (id_emp, id_mnt_estq, dt_mnt_estq, op, id_dep_org, id_dep_dst, descr, org, id_org)
    values
        (_id_emp, _id_mnt_estq, _ped.dt_ped, 'T', _id_dep_org, _id_dep_dst, 'CARREGAMENTO COMPLEMENTAR ' || _id_ped, 'PED.' || _id_ped, _id_ped);
        
    
    open _ped_item_list for
        select
            tb_ped_item.*,
            tb_item.id_und_med as id_und_med_item
        from tb_ped_item
        join tb_item on
            (tb_ped_item.id_item = tb_item.id_item)
        where
            id_emp = _id_emp and
            id_ped = _id_ped;
            
    fetch _ped_item_list into _ped_item;
    
    _id_mnt_estq_item := 0;
    
    while found loop
        
        _id_mnt_estq_item := _id_mnt_estq_item + 1;
    
        insert into tb_mnt_estq_item
            (id_emp, id_mnt_estq, id_mnt_estq_item, id_item, id_grd_estq, id_und_med, vl_qtd, 
             id_und_med_mov, vl_qtd_mov, 
             op, id_dep_org, id_dep_dst)
        values
            (_id_emp, _id_mnt_estq, _id_mnt_estq_item, _ped_item.id_item, _id_grd_estq, _ped_item.id_und_med_item, _ped_item.vl_qtd, 
             _ped_item.id_und_med_item, _ped_item.vl_qtd,
             'T', _id_dep_org, _id_dep_dst);
            
        fetch _ped_item_list into _ped_item;
        
    end loop;
    
    
    update tb_ped set
        sit = 'F'
    where
        id_emp = _id_emp and
        id_ped = _id_ped;
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;