DROP VIEW public.vw_vnd_rota;

CREATE OR REPLACE VIEW public.vw_vnd_rota(
    id_emp,
    dt_vnd,
    dia_semana,
    id_rota,
    id_vndr,
    descr,
    vl_cred,
    vl_ch_prz,
    vl_ch_vst,
    vl_blt,
    vl_out,
    qtd_cli)
AS
  SELECT tb.id_emp,
         tb.dt_vnd,
         tb.dia_semana,
         tb.id_rota,
         tb.id_vndr,
         tb.descr,
         sum(tb.vl_cred) AS vl_cred,
         sum(tb.vl_ch_prz) AS vl_ch_prz,
         sum(tb.vl_ch_vst) AS vl_ch_vst,
         sum(tb.vl_blt) AS vl_blt,
         sum(tb.vl_out) AS vl_out,
         sum(tb.qtd_cli) AS qtd_cli
  FROM 
  (
            SELECT tb_vnd.id_emp,
                   tb_vnd.dt_vnd,
                   CASE date_part('dow' , tb_vnd.dt_vnd)
                     WHEN 0 THEN 'Domingo' 
                     WHEN 1 THEN 'Segunda' 
                     WHEN 2 THEN 'Tera' 
                     WHEN 3 THEN 'Quarta' 
                     WHEN 4 THEN 'Quinta' 
                     WHEN 5 THEN 'Sexta' 
                     WHEN 6 THEN 'Sabado' 
                     ELSE NULL
                   END AS dia_semana,
                   tb_part.id_rota,
                   tb_vnd.id_vndr,
                   tb_rota.descr,
                   0 AS vl_cred,
                   0 AS vl_ch_prz,
                   0 AS vl_ch_vst,
                   0 AS vl_blt,
                   0 AS vl_out,
                   count(*) AS qtd_cli
            FROM tb_vnd
                 LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
                 LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
            GROUP BY tb_vnd.id_emp,
                     tb_vnd.dt_vnd,
                     tb_part.id_rota,
                     tb_vnd.id_vndr,
                     tb_rota.descr
            UNION ALL
            SELECT tb_vnd.id_emp,
                   tb_vnd.dt_vnd,
                   CASE date_part('dow' , tb_vnd.dt_vnd)
                     WHEN 0 THEN 'Domingo' 
                     WHEN 1 THEN 'Segunda' 
                     WHEN 2 THEN 'Tera' 
                     WHEN 3 THEN 'Quarta' 
                     WHEN 4 THEN 'Quinta' 
                     WHEN 5 THEN 'Sexta' 
                     WHEN 6 THEN 'Sabado' 
                     ELSE NULL
                   END AS dia_semana,
                   tb_part.id_rota,
                   tb_vnd.id_vndr,
                   tb_rota.descr,
                   sum(tb_vnd_parc.vl_parc) AS vl_cred,
                   0 AS vl_ch_prz,
                   0 AS vl_ch_vst,
                   0 AS vl_blt,
                   0 AS vl_out,
                   0 AS qtd_cli
            FROM tb_vnd
                 LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
                 LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
                 LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND
                   tb_vnd.id_vnd = tb_vnd_parc.id_vnd
                 JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
            WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND
                  tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND
                  tb_op_fnc.tp_op_fnc = 'DUP' 
            GROUP BY tb_vnd.id_emp,
                     tb_vnd.dt_vnd,
                     tb_part.id_rota,
                     tb_vnd.id_vndr,
                     tb_rota.descr

          UNION ALL
          SELECT tb_vnd.id_emp,
                 tb_vnd.dt_vnd,
                 CASE date_part('dow' , tb_vnd.dt_vnd)
                   WHEN 0 THEN 'Domingo' 
                   WHEN 1 THEN 'Segunda' 
                   WHEN 2 THEN 'Tera' 
                   WHEN 3 THEN 'Quarta' 
                   WHEN 4 THEN 'Quinta' 
                   WHEN 5 THEN 'Sexta' 
                   WHEN 6 THEN 'Sabado' 
                   ELSE NULL
                 END AS dia_semana,
                 tb_part.id_rota,
                 tb_vnd.id_vndr,
                 tb_rota.descr,
                 0 AS vl_cred,
                 sum(tb_vnd_parc.vl_parc) AS vl_ch_prz,
                 0 AS vl_ch_vst,
                 0 AS vl_blt,
                 0 AS vl_out,
                 0 AS qtd_cli
          FROM tb_vnd
               LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
               LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
               LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND
                 tb_vnd.id_vnd = tb_vnd_parc.id_vnd
               JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
          WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND
                tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND
                tb_op_fnc.tp_op_fnc = 'CH' 
          GROUP BY tb_vnd.id_emp,
                   tb_vnd.dt_vnd,
                   tb_part.id_rota,
                   tb_vnd.id_vndr,
                   tb_rota.descr

         UNION ALL
         SELECT tb_vnd.id_emp,
                tb_vnd.dt_vnd,
                CASE date_part('dow' , tb_vnd.dt_vnd)
                  WHEN 0 THEN 'Domingo' 
                  WHEN 1 THEN 'Segunda' 
                  WHEN 2 THEN 'Tera' 
                  WHEN 3 THEN 'Quarta' 
                  WHEN 4 THEN 'Quinta' 
                  WHEN 5 THEN 'Sexta' 
                  WHEN 6 THEN 'Sabado' 
                  ELSE NULL
                END AS dia_semana,
                tb_part.id_rota,
                tb_vnd.id_vndr,
                tb_rota.descr,
                0 AS vl_cred,
                0 AS vl_ch_prz,
                sum(tb_vnd_parc.vl_parc) AS vl_ch_vst,
                0 AS vl_blt,
                0 AS vl_out,
                0 AS qtd_cli
         FROM tb_vnd
              LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
              LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
              LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND
                tb_vnd.id_vnd = tb_vnd_parc.id_vnd
              JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
         WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND
               tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND
               tb_op_fnc.tp_op_fnc = 'CH' 
         GROUP BY tb_vnd.id_emp,
                  tb_vnd.dt_vnd,
                  tb_part.id_rota,
                  tb_vnd.id_vndr,
                  tb_rota.descr
        UNION ALL
        SELECT tb_vnd.id_emp,
               tb_vnd.dt_vnd,
               CASE date_part('dow' , tb_vnd.dt_vnd)
                 WHEN 0 THEN 'Domingo' 
                 WHEN 1 THEN 'Segunda' 
                 WHEN 2 THEN 'Tera' 
                 WHEN 3 THEN 'Quarta' 
                 WHEN 4 THEN 'Quinta' 
                 WHEN 5 THEN 'Sexta' 
                 WHEN 6 THEN 'Sabado' 
                 ELSE NULL
               END AS dia_semana,
               tb_part.id_rota,
               tb_vnd.id_vndr,
               tb_rota.descr,
               0 AS vl_cred,
               0 AS vl_ch_prz,
               0 AS vl_ch_vst,
               sum(tb_vnd_parc.vl_parc) AS vl_blt,
               0 AS vl_out,
               0 AS qtd_cli
        FROM tb_vnd
             LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
             LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
             LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND
               tb_vnd.id_vnd = tb_vnd_parc.id_vnd
             JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
        WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND
              tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND
              tb_op_fnc.tp_op_fnc = 'BLT' 
        GROUP BY tb_vnd.id_emp,
                 tb_vnd.dt_vnd,
                 tb_part.id_rota,
                 tb_vnd.id_vndr,
                 tb_rota.descr
        UNION ALL
        SELECT tb_vnd.id_emp,
               tb_vnd.dt_vnd,
               CASE date_part('dow' , tb_vnd.dt_vnd)
                 WHEN 0 THEN 'Domingo' 
                 WHEN 1 THEN 'Segunda' 
                 WHEN 2 THEN 'Tera' 
                 WHEN 3 THEN 'Quarta' 
                 WHEN 4 THEN 'Quinta' 
                 WHEN 5 THEN 'Sexta' 
                 WHEN 6 THEN 'Sabado' 
                 ELSE NULL
               END AS dia_semana,
               tb_part.id_rota,
               tb_vnd.id_vndr,
               tb_rota.descr,
               0 AS vl_cred,
               0 AS vl_ch_prz,
               0 AS vl_ch_vst,
               0 AS vl_blt,
               sum(tb_vnd_parc.vl_parc) AS vl_out,
               0 AS qtd_cli
        FROM tb_vnd
             LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
             LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
             LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND
               tb_vnd.id_vnd = tb_vnd_parc.id_vnd
             JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
        WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND
              tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND
              (tb_op_fnc.tp_op_fnc <> ALL (ARRAY [ 'DUP' , 'CH' , 'CH', 'BLT'  ]))
        GROUP BY tb_vnd.id_emp,
                 tb_vnd.dt_vnd,
                 tb_part.id_rota,
                 tb_vnd.id_vndr,
                 tb_rota.descr
) tb
  GROUP BY tb.id_emp,
           tb.dt_vnd,
           tb.id_vndr,
           tb.dia_semana,
           tb.id_rota,
           tb.descr
  ORDER BY tb.dt_vnd;