do $$
declare
	_id_emp integer;
    _alt_prc_vnd boolean;
begin
	-- CNF_VND_ALT_PRC_VND               = 09009
    -- USR_OP__VND__BLOQ_ALT_PRC_VND     = 01007
    select min(id_part) into _id_emp
    from tb_part
    where
    	tp_part like '%[E]%';
        
    _alt_prc_vnd := upper(fc_get_emp_cnf(_id_emp, 09009)) = 'TRUE' ;
    
    raise notice 'Id Empresa: % CNF: %' , _id_emp, _alt_prc_vnd;
    
    if (_alt_prc_vnd) then
    	delete from tb_usr_op 
        where
        	id_op = 01011;
		
        insert into tb_usr_op
        	(id_usr, id_op, val)
		select
        	tb_usr.id_usr,
            01011 as id_op,
            case 
            	when (_alt_prc_vnd and tb_usr_op.val = 'False') then 'True'
                else 'False'
            end
        from tb_usr
        left outer join tb_usr_op on
        	tb_usr_op.id_usr = tb_usr.id_usr and
            tb_usr_op.id_op = 01007;
	end if;
end;
$$
