CREATE SEQUENCE public.sq_pix
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
    
    _id_plano_ct varchar;
    
    _ct record;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                tp_org = 'VND' and
                id_org = old.id_vnd and
                id_org_item = old.id_vnd_parc;
                -- org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
            
            delete from tb_mov_bnc
            where 
                id_emp = old.id_emp and
                tp_org = 'VND' and
                id_org = old.id_vnd and
                id_org_item = old.id_vnd_parc;
                -- org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;

            update tb_pix set
                id_org = null
            where
                id_emp = old.id_emp and
                id_pix = old.id_pix;
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select * into _vnd
            from tb_vnd
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                
                
            select tb_nat_op.* into _nat_op
            from tb_vnd
            join tb_nat_op on
                (tb_vnd.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_vnd.id_emp = new.id_emp and
                tb_vnd.id_vnd = new.id_vnd;
                    
            _gera_fin := _nat_op.op like '%[VND__GER_FIN]%';
            
            
            /*_id_plano_ct := fc_get_emp_cnf(new.id_emp, 16100 + _op_fnc.id_op_fnc);
                
            if (_id_plano_ct = '') then
                _id_plano_ct := null;
            end if;
            
            if (_nat_op.id_plano_ct is not null) then
                _id_plano_ct := _nat_op.id_plano_ct;
            end if;*/
            

            if (_op_fnc.gera_ct and _gera_fin) then
                    
                _nr_doc := new.nr_doc;
                    
                if (_op_fnc.tp_op_fnc = 'DUP' and coalesce(_nr_doc, '') = '') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
                
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org, tp_org, id_org, id_org_item,
                     id_op_fnc, vl_quit, vl_rest, 
                     obs,
                     id_plano_ct, id_cnt_cst,
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_veic)
                values
                    (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, 'VND', new.id_vnd, new.id_vnd_parc,
                     new.id_op_fnc, 0, new.vl_parc, 
                     'VENDA ' || new.id_vnd,
                     new.id_plano_ct, new.id_cnt_cst,
                     new.vl_sub_tot, coalesce(new.vl_perc_desc, 0), coalesce(new.vl_desc, 0), coalesce(new.vl_perc_acr, 0), coalesce(new.vl_acr, 0), 
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.comp_cad, _vnd.comp_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     _vnd.id_veic);
                
                
                if (_op_fnc.tp_op_fnc = 'BLT') then
                    select * into _ct
                    from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_ct = _id_ct;
                        
                    new.nr_doc := _ct.nr_doc;
                    
--                    raise notice '12345 Boleto %', new.nr_doc;
                    
                elsif (_op_fnc.tp_op_fnc = 'DUP') then
                    new.nr_doc := cast(_id_ct as varchar);
                    
--                    raise notice '12345 Duplicata %', new.nr_doc;
                    
                end if;
            end if;
                
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, tp_org, id_org, id_org_item,
                     id_part, sit_conc,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_plano_ct, id_cnt_cst,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, 'VND', new.id_vnd, new.id_vnd_parc,
                     _vnd.id_cli, 'PEND',
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.comp_cad, _vnd.comp_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     new.id_plano_ct, new.id_cnt_cst,
                     new.id_op_fnc);
            end if;
            
            if (_op_fnc.tp_op_fnc = 'PIX' and _gera_fin and new.id_pix is not null) then
            
                update tb_pix set
                    id_org = new.id_vnd
                where
                    id_emp = new.id_emp and
                    id_pix = new.id_pix;
            
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _id_cli_cons varchar;
    
    _list refcursor;
    _item record;
    
begin
    _app_con := fc_app_con();

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
    
        if (new.org = 'CONSIG') then
            update tb_consig set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_consig = new.id_org;
        end if;
        
        _id_cli_cons := fc_get_emp_cnf(new.id_emp, 01000);
        
        if (cast(new.id_cli as varchar) <> _id_cli_cons) then
            
            update tb_part set
                id_cond_pagto = new.id_cond_pagto,
                id_fm_pagto = new.id_fm_pagto
            where
                id_part = new.id_cli;
                
        end if;
        
        if (new.id_sit_vnd is not null and new.cd_ref is not null) then
            perform fc_vnd_ident_sit(new.id_emp, cast(new.cd_ref as integer), new.id_sit_vnd);
        end if;
        
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        if (old.org = 'CONSIG') then
            update tb_consig set
                sit = 'D'
            where
                id_emp = old.id_emp and
                id_consig = old.id_org;
        end if;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            tp_org = 'VND' and
            id_org = old.id_vnd;
            -- org like 'VND.' || old.id_vnd || '%';
    
    end if;
    
    
    --
    -- Venda cancelada ( mesmo se vier do neo UNI )
    --
    if (tg_op = 'UPDATE' and new.canc = true and new.canc <> old.canc) then
        --
        -- extorna o estoque
        --
        open _list for
            select *
            from tb_vnd_item
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd and
                mov_estq;

        fetch _list into _item;
                
            
        while found loop
                
            perform fc_item_estq(_item.id_item, _item.id_emp, _item.id_dep, _item.id_grd_estq, 'E', _item.vl_qtd_mov);
                
            fetch _list into _item;
                
        end loop;
            
        close _list;
            
        --
        -- extorna contas a receber, mov banco, pix
        --
        open _list for 
            select *
            from tb_vnd_parc
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                    
        fetch _list into _item;
            
        while found loop
                
            delete from tb_ct
            where 
                id_emp = new.id_emp and
                tp_org = 'VND' and
                id_org = new.id_vnd and
                id_org_item = _item.id_vnd_parc;
                -- org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
            delete from tb_mov_bnc
            where 
                id_emp = new.id_emp and
                tp_org = 'VND' and
                id_org = new.id_vnd and
                id_org_item = _item.id_vnd_parc;
--                 org = 'VND.' || new.id_vnd || '.' || _item.id_vnd_parc;
                
            update tb_pix set
                id_org = null
            where
                id_emp = new.id_emp and
                id_pix = _item.id_pix;
            
            fetch _list into _item;
                
        end loop;
            
    end if;
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_pix_bf (
)
RETURNS trigger AS
$body$
declare
    _mov_bnc record;
begin
    if (new.sit = 'CONC') then
        
        select * into _mov_bnc
        from tb_mov_bnc
        where
            id_emp = new.id_emp and
            tp_org = 'PIX' and
            id_org = new.id_pix;
            
        if not found then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, tp_org, id_org, 
                 id_part, sit_conc,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_hr_pag, new.dt_hr_pag, new.id_pix, 'C', new.vl_lanc, new.descr || ' - ' || new.nome_pag, false,
                 'PIX.' || new.id_pix, 'PIX', new.id_pix,
                 new.id_part, 'PEND',
                 new.id_usr_ult_alt, new.dt_hr_ult_alt, new.id_usr_ult_alt, new.dt_hr_ult_alt, new.comp_cad, new.comp_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_op_fnc);
        end if;    
    end if;
    
    return new;

end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;
    _op varchar;
    _id_part_ct integer;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'BX' and
            id_org = old.id_bx_ct and
            id_org_item = old.id_bx_ct_pagto;
            -- org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            tp_org = 'BX' and
            id_org = old.id_bx_ct and
            id_org_item = old.id_bx_ct_pagto;
            -- org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
        update tb_pix set
            id_org = null
        where
            id_emp = old.id_emp and
            id_pix = old.id_pix;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct and coalesce(_bx_ct.org, '') not like 'CT.%') then
        
            if (_bx_ct.op = 'A') then
                _op := ifthen(new.op = 'C', 'R', 'P');
            else
                _op := ifthen(_bx_ct.tp_bx = 'R', 'R', 'P');
            end if;
            
            if (_op_fnc.id_part_ct is not null and _bx_ct.op = 'A' and _op_fnc.tp_op_fnc = 'REQ') then
                _id_part_ct := _op_fnc.id_part_ct;
            else
                _id_part_ct := _bx_ct.id_part;
            end if;
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, id_op_fnc, vl_quit, vl_rest,
                 org, tp_org, id_org, id_org_item,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), _op, _op_fnc.tp_op_fnc, _id_part_ct, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, new.id_op_fnc, 0, new.vl_pagto,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, 'BX', new.id_bx_ct, new.id_bx_ct_pagto, 
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.comp_cad, _bx_ct.comp_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        _descr_part := '';
        
        if (_bx_ct.op = 'A') then
            _descr := 'ACERTO ' || _bx_ct.num_doc;
            
            if (new.obs is not null) then
                _descr_part := ' - ' || new.obs;
            end if;
          
        elsif (_bx_ct.org like 'BX_MOV_FUNC.%' and coalesce(new.obs, '') <> '') then
            
            _descr := new.obs;
            
        else
            select nome into _descr_part
            from tb_part
            where
                id_part = _bx_ct.id_part;
                
            if (_descr_part is null) then
                _descr_part := '';
            else
                _descr_part := ' ' || _descr_part;
            end if;
            
            if (new.obs is not null) then
                _descr_part := _descr_part || ' ' || new.obs;
            end if;
            
            if (_bx_ct.org like 'PAG_COOP%') then
                _descr := 'PAGTO PROD COOP ';
            else
                _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
            end if;
        end if;
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
        
            if (_bx_ct.op = 'A') then
                _op := new.op;
            else
                _op := ifthen(_bx_ct.tp_bx = 'R', 'C', 'D');
            end if;
        
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, tp_org, id_org, id_org_item,
                 id_part, sit_conc,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, _op, new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, 'BX', new.id_bx_ct, new.id_bx_ct_pagto,
                 _bx_ct.id_part, 'PEND',
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.comp_cad, _bx_ct.comp_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
        
        if (_op_fnc.tp_op_fnc = 'PIX' and new.id_pix is not null) then
            
            update tb_pix set
                id_org = new.id_bx_ct
            where
                id_emp = new.id_emp and
                id_pix = new.id_pix;
            
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_cnt_bnc
  ADD COLUMN pix_chave VARCHAR(50);

ALTER TABLE public.tb_cnt_bnc
  ADD COLUMN pix_cli_id VARCHAR;

ALTER TABLE public.tb_cnt_bnc
  ADD COLUMN pix_cli_sec VARCHAR;

ALTER TABLE public.tb_cnt_bnc
  ADD COLUMN pix_app VARCHAR;

ALTER TABLE public.tb_cnt_bnc
  ADD COLUMN pix_oauth VARCHAR;

ALTER TABLE public.tb_cnt_bnc
  ADD COLUMN pix_msg VARCHAR;

CREATE TABLE public.tb_pix (
  id_emp INTEGER NOT NULL, 
  id_pix INTEGER NOT NULL, 
  id_cnt_bnc INTEGER, 
  txid VARCHAR(35), 
  dt_hr TIMESTAMP WITHOUT TIME ZONE, 
  id_part INTEGER, 
  cpf_cnpj VARCHAR(20), 
  nome VARCHAR(150), 
  vl_lanc NUMERIC(12,2), 
  descr VARCHAR(255), 
  org VARCHAR(50), 
  tp_org VARCHAR(50), 
  id_org INTEGER, 
  sit VARCHAR(20), 
  qr_code VARCHAR(255), 
  sit_descr VARCHAR(500), 
  cpf_cnpj_pag VARCHAR(20), 
  nome_pag VARCHAR(150), 
  dt_hr_pag TIMESTAMP WITHOUT TIME ZONE, 
  info_pag VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  id_plano_ct VARCHAR(100), 
  id_cnt_cst INTEGER, 
  id_op_fnc INTEGER, 
  CONSTRAINT pk_pix PRIMARY KEY(id_emp, id_pix)
) ;

CREATE TRIGGER tr_pix_bf
  BEFORE UPDATE 
  ON public.tb_pix FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_pix_bf();

CREATE TABLE public.tb_pix_json (
  id_emp INTEGER NOT NULL, 
  id_pix INTEGER NOT NULL, 
  env TEXT, 
  rec TEXT, 
  cons TEXT, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  CONSTRAINT pk_pix_json PRIMARY KEY(id_emp, id_pix)
) ;

ALTER TABLE public.tb_mov_cx
  ADD COLUMN vl_pix_ent NUMERIC(12,2);

ALTER TABLE public.tb_mov_cx
  ADD COLUMN vl_pix_apu NUMERIC(12,2);

ALTER TABLE public.tb_vnd_parc
  ADD COLUMN id_pix INTEGER;

ALTER TABLE public.tb_bx_ct_pagto
  ADD COLUMN id_pix INTEGER;

CREATE OR REPLACE VIEW public.vw_mov_plano_ct (
    id_emp,
    id_mov_plano_ct,
    org,
    tp_org,
    id_org,
    id_org_item,
    id_plano_ct,
    dt_lanc,
    descr,
    vl_lanc)
AS
        (        (        (        (        (         SELECT tb_bx_ct.id_emp, 
                                                    (('BX_CT.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_ct.id_ct AS id_mov_plano_ct, 
                                                    (('BX_CT.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_ct.id_ct AS org, 
                                                    'BX_CT'::text AS tp_org, 
                                                    tb_bx_ct.id_bx_ct AS id_org, 
                                                    tb_ct.id_ct AS id_org_item, 
                                                    tb_ct.id_plano_ct, 
                                                    tb_bx_ct.dt_bx AS dt_lanc, 
                                                    tb_part.nome AS descr, 
                                                    tb_bx_ct__ct.vl_quit AS vl_lanc
                                                   FROM tb_bx_ct
                                              JOIN tb_bx_ct__ct ON tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp AND tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct
                                         JOIN tb_ct ON tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp AND tb_bx_ct__ct.id_ct = tb_ct.id_ct
                                    JOIN tb_plano_ct _plano_ct ON tb_ct.id_plano_ct::text = _plano_ct.id_plano_ct::text
                               JOIN tb_part ON tb_ct.id_part = tb_part.id_part
                              WHERE COALESCE(tb_ct.tp_org, ''::character varying)::text <> 'CONTR_FRETE'::text
                                        UNION ALL 
                                                 SELECT tb_mov_bnc.id_emp, 
                                                    'MOV_BNC.'::text || tb_mov_bnc.id_mov_bnc AS id_mov_plano_ct, 
                                                    'MOV_BNC.'::text || tb_mov_bnc.id_mov_bnc AS org, 
                                                    'MOV_BNC'::text AS tp_org, 
                                                    tb_mov_bnc.id_mov_bnc AS id_org, 
                                                    NULL::integer AS id_org_item, 
                                                    tb_mov_bnc.id_plano_ct, 
                                                    tb_mov_bnc.dt_emis AS dt_lanc, 
                                                    COALESCE(tb_part.nome::text || ' - '::text, ''::text) || tb_mov_bnc.descr::text AS descr, 
                                                    tb_mov_bnc.vl_lanc
                                                   FROM tb_mov_bnc
                                              JOIN tb_plano_ct _plano_ct ON tb_mov_bnc.id_plano_ct::text = _plano_ct.id_plano_ct::text
                                         LEFT JOIN tb_part ON tb_mov_bnc.id_part = tb_part.id_part
                                        WHERE NOT COALESCE(tb_mov_bnc.org, ''::character varying)::text ~~ 'BX.%'::text)
                                UNION ALL 
                                         SELECT tb_mov_fnc.id_emp, 
                                            'MOV_FNC.'::text || tb_mov_fnc.id_mov_fnc AS id_mov_plano_ct, 
                                            'MOV_FNC.'::text || tb_mov_fnc.id_mov_fnc AS org, 
                                            'MOV_FNC'::text AS tp_org, 
                                            tb_mov_fnc.id_mov_fnc AS id_org, 
                                            NULL::integer AS id_org_item, 
                                            tb_mov_fnc.id_plano_ct, 
                                            tb_mov_fnc.dt_lanc, 
                                            tb_mov_fnc.descr, 
                                            tb_mov_fnc.vl_lanc
                                           FROM tb_mov_fnc
                                      JOIN tb_plano_ct _plano_ct ON tb_mov_fnc.id_plano_ct::text = _plano_ct.id_plano_ct::text
                                     WHERE tb_mov_fnc.org IS NULL)
                        UNION ALL 
                                 SELECT tb_vnd.id_emp, 
                                    (('VND.'::text || tb_vnd.id_vnd) || '.'::text) || tb_vnd_parc.id_vnd_parc AS id_mov_plano_ct, 
                                    (('VND.'::text || tb_vnd.id_vnd) || '.'::text) || tb_vnd_parc.id_vnd_parc AS org, 
                                    'VND'::text AS tp_org, 
                                    tb_vnd.id_vnd AS id_org, 
                                    tb_vnd_parc.id_vnd_parc AS id_org_item, 
                                    tb_emp_cnf.val AS id_plano_ct, 
                                    tb_vnd.dt_vnd AS dt_lanc, 
                                    tb_part.nome AS descr, 
                                    tb_vnd_parc.vl_parc AS vl_lanc
                                   FROM tb_vnd
                              JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd
                         JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
                    JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
               LEFT JOIN tb_emp_cnf ON tb_vnd.id_emp = tb_emp_cnf.id_emp AND trunc((tb_emp_cnf.id_cnf / 100)::double precision) = 161::double precision AND (tb_emp_cnf.id_cnf - 16100) = tb_op_fnc.id_op_fnc
              WHERE COALESCE(tb_vnd.canc, false) = false)
                UNION ALL 
                         SELECT tb_bx_ct.id_emp, 
                            (((('CONTR_FRETE.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_ct.id_ct) || '.'::text) || tb_emp_cnf.id_cnf AS id_mov_plano_ct, 
                            (('CONTR_FRETE.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_ct.id_ct AS org, 
                            'CONTR_FRETE'::text AS tp_org, 
                            tb_bx_ct.id_bx_ct AS id_org, 
                            tb_ct.id_ct AS id_org_item, 
                            tb_emp_cnf.val AS id_plano_ct, 
                            tb_bx_ct.dt_bx AS dt_lanc, tb_part.nome AS descr, 
                                CASE tb_emp_cnf.id_cnf
                                    WHEN 26101 THEN tb_contr_frete.vl_frete
                                    WHEN 26102 THEN tb_contr_frete.vl_inss
                                    WHEN 26103 THEN tb_contr_frete.vl_irrf
                                    WHEN 26104 THEN tb_contr_frete.vl_ss
                                    WHEN 26105 THEN tb_contr_frete.vl_taxa_coop
                                    WHEN 26106 THEN tb_contr_frete.vl_dif_frete
                                    WHEN 26107 THEN tb_contr_frete.vl_dif_frete * (-1)::numeric
                                    WHEN 26108 THEN tb_contr_frete.vl_desc_fin
                                    WHEN 26109 THEN tb_contr_frete.vl_seg
                                    WHEN 26110 THEN 
                                    CASE
                                        WHEN tb_tp_contr_frete.conf::text ~~ '%[ADTO_T]%'::text THEN tb_contr_frete.vl_adto
                                        ELSE 0::numeric
                                    END
                                    WHEN 26111 THEN tb_contr_frete.vl_comis1
                                    WHEN 26112 THEN tb_contr_frete.vl_taxa_op
                                    WHEN 26113 THEN tb_contr_frete.vl_aliq_ldc
                                    WHEN 26114 THEN tb_contr_frete.vl_issqn
                                    WHEN 26115 THEN tb_contr_frete.vl_out_desp
                                    ELSE NULL::numeric
                                END AS vl_lanc
                           FROM tb_bx_ct
                      JOIN tb_bx_ct__ct ON tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp AND tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct
                 JOIN tb_ct ON tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp AND tb_bx_ct__ct.id_ct = tb_ct.id_ct
            LEFT JOIN tb_plano_ct _plano_ct ON tb_ct.id_plano_ct::text = _plano_ct.id_plano_ct::text
       JOIN tb_part ON tb_ct.id_part = tb_part.id_part
   JOIN tb_contr_frete ON tb_contr_frete.id_emp = tb_ct.id_emp AND tb_contr_frete.id_contr_frete = tb_ct.id_org
   JOIN tb_emp_cnf ON tb_ct.id_emp = tb_emp_cnf.id_emp AND tb_emp_cnf.id_cnf >= 26101 AND tb_emp_cnf.id_cnf <= 26115
   JOIN tb_tp_contr_frete ON tb_contr_frete.id_tp_contr_frete = tb_tp_contr_frete.id_tp_contr_frete
  WHERE COALESCE(tb_ct.tp_org, ''::character varying)::text = 'CONTR_FRETE'::text)
        UNION ALL 
                 SELECT tb_bx_ct.id_emp, 
                    (((('RENEG.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_bx_ct_pagto.id_bx_ct_pagto) || '.'::text) || tb_emp_cnf.id_cnf AS id_mov_plano_ct, 
                    (('RENEG.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_bx_ct_pagto.id_bx_ct_pagto AS org, 
                    'RENEG'::text AS tp_org, tb_bx_ct.id_bx_ct AS id_org, 
                    tb_bx_ct_pagto.id_bx_ct_pagto AS id_org_item, 
                    tb_emp_cnf.val AS id_plano_ct, tb_bx_ct.dt_bx AS dt_lanc, 
                    tb_part.nome AS descr, tb_bx_ct_pagto.vl_pagto AS vl_lanc
                   FROM tb_bx_ct
              JOIN tb_bx_ct_pagto ON tb_bx_ct.id_emp = tb_bx_ct_pagto.id_emp AND tb_bx_ct.id_bx_ct = tb_bx_ct_pagto.id_bx_ct
         JOIN tb_part ON tb_bx_ct.id_part = tb_part.id_part
    JOIN tb_emp_cnf ON tb_bx_ct.id_emp = tb_emp_cnf.id_emp AND tb_emp_cnf.id_cnf = 16401
   JOIN tb_op_fnc ON tb_bx_ct_pagto.id_op_fnc = tb_op_fnc.id_op_fnc
  WHERE tb_bx_ct.op::text = 'R'::text)
UNION ALL 
         SELECT tb_bx_ct.id_emp, 
            (('MOV_FUNC.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_mov_func.id_mov_func AS id_mov_plano_ct, 
            (('MOV_FUNC.'::text || tb_bx_ct.id_bx_ct) || '.'::text) || tb_mov_func.id_mov_func AS org, 
            'MOV_FUNC'::text AS tp_org, tb_bx_ct.id_bx_ct AS id_org, 
            tb_mov_func.id_mov_func AS id_org_item, tb_mov_func.id_plano_ct, 
            tb_bx_ct.dt_bx AS dt_lanc, tb_part.nome AS descr, 
            tb_mov_func.vl_lanc
           FROM tb_bx_ct
      JOIN tb_bx_ct__ct ON tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp AND tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct
   JOIN tb_ct ON tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp AND tb_bx_ct__ct.id_ct = tb_ct.id_ct
   JOIN tb_mov_func ON tb_bx_ct.id_emp = tb_mov_func.id_emp AND tb_ct.org::text = ('BX_MOV_FUNC.'::text || tb_mov_func.id_bx_mov_func)
   JOIN tb_plano_ct _plano_ct ON tb_mov_func.id_plano_ct::text = _plano_ct.id_plano_ct::text
   JOIN tb_part ON tb_mov_func.id_part = tb_part.id_part;

ALTER TABLE public.tb_vnd_parc
  ADD CONSTRAINT fk__vnd_parc__pix FOREIGN KEY (id_emp, id_pix)
    REFERENCES public.tb_pix(id_emp, id_pix)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pix_json
  ADD CONSTRAINT fk__pix_json__pix FOREIGN KEY (id_emp, id_pix)
    REFERENCES public.tb_pix(id_emp, id_pix)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pix
  ADD CONSTRAINT fk__pix__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pix
  ADD CONSTRAINT fk__pix__cnt_cst FOREIGN KEY (id_cnt_cst)
    REFERENCES public.tb_cnt_cst(id_cnt_cst)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pix
  ADD CONSTRAINT fk__pix__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pix
  ADD CONSTRAINT fk__pix__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pix
  ADD CONSTRAINT fk__pix__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pix
  ADD CONSTRAINT fk__pix__plano_ct FOREIGN KEY (id_plano_ct)
    REFERENCES public.tb_plano_ct(id_plano_ct)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_bx_ct_pagto
  ADD CONSTRAINT fk__bx_ct_pagto__pix FOREIGN KEY (id_emp, id_pix)
    REFERENCES public.tb_pix(id_emp, id_pix)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;
