create or replace view vw_mov_plano_ct as
    
    select
        tb_bx_ct.id_emp,
        'BX_CT.' || tb_bx_ct.id_bx_ct || '.' || tb_ct.id_ct as id_mov_plano_ct,
        'BX_CT.' || tb_bx_ct.id_bx_ct || '.' || tb_ct.id_ct as org,
        'BX_CT' as tp_org,
        tb_bx_ct.id_bx_ct as id_org,
        tb_ct.id_ct as id_org_item,
        tb_ct.id_plano_ct,
        tb_bx_ct.dt_bx as dt_lanc,
        tb_part.nome as descr,
        tb_bx_ct__ct.vl_quit as vl_lanc
    from tb_bx_ct
    join tb_bx_ct__ct on
        (tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp and 
         tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct)
    join tb_ct on
        (tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp and 
         tb_bx_ct__ct.id_ct = tb_ct.id_ct)
    join tb_plano_ct as _plano_ct on
        (tb_ct.id_plano_ct = _plano_ct.id_plano_ct)
    join tb_part on
        (tb_ct.id_part = tb_part.id_part)
    
      
    union all
    
    select
        tb_mov_bnc.id_emp,
        'MOV_BNC.' || tb_mov_bnc.id_mov_bnc as id_mov_plano_ct,
        'MOV_BNC.' || tb_mov_bnc.id_mov_bnc as org,
        'MOV_BNC' as tp_org,
        tb_mov_bnc.id_mov_bnc as id_org,
        null as id_org_item,
        tb_mov_bnc.id_plano_ct,
        tb_mov_bnc.dt_emis as dt_lanc,
        coalesce(tb_part.nome || ' - ', '') || tb_mov_bnc.descr as descr,
        tb_mov_bnc.vl_lanc as vl_lanc
    from tb_mov_bnc
    join tb_plano_ct as _plano_ct on
        (tb_mov_bnc.id_plano_ct = _plano_ct.id_plano_ct)
    left outer join tb_part on
        (tb_mov_bnc.id_part = tb_part.id_part)
    where
        (tb_mov_bnc.org is null or tb_mov_bnc.org like 'IMP_OFX.%')
         
    union all

    select
        tb_mov_fnc.id_emp,
        'MOV_FNC.' || tb_mov_fnc.id_mov_fnc as id_mov_plano_ct,
        'MOV_FNC.' || tb_mov_fnc.id_mov_fnc as org,
        'MOV_FNC' as tp_org,
        tb_mov_fnc.id_mov_fnc as id_org,
        null as id_org_item,
        tb_mov_fnc.id_plano_ct,
        tb_mov_fnc.dt_lanc as dt_lanc,
        tb_mov_fnc.descr,
        tb_mov_fnc.vl_lanc as vl_lanc
    from tb_mov_fnc
    join tb_plano_ct as _plano_ct on
        (tb_mov_fnc.id_plano_ct = _plano_ct.id_plano_ct)
    where

        tb_mov_fnc.org is null 

    union all
    
    select
        tb_vnd.id_emp,
        'VND.' || tb_vnd.id_vnd || '.' || tb_vnd_parc.id_vnd_parc as id_mov_plano_ct,
        'VND.' || tb_vnd.id_vnd || '.' || tb_vnd_parc.id_vnd_parc as org,
        'VND' as tp_org,
        tb_vnd.id_vnd as id_org,
        tb_vnd_parc.id_vnd_parc as id_org_item,
        tb_emp_cnf.val as id_plano_ct,
        tb_vnd.dt_vnd as dt_lanc,
        tb_part.nome as descr,
        tb_vnd_parc.vl_parc as vl_lanc
    from tb_vnd
    join tb_vnd_parc on
        (tb_vnd.id_emp = tb_vnd_parc.id_emp and
         tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
    join tb_op_fnc on
        (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc)
    join tb_part on
        (tb_vnd.id_cli = tb_part.id_part)
    left outer join tb_emp_cnf on
        (tb_vnd.id_emp = tb_emp_cnf.id_emp and
         trunc(id_cnf / 100) = 161 and
         id_cnf - 16100 = tb_op_fnc.id_op_fnc)
    where
        coalesce(tb_vnd.canc, false) = false;
    