CREATE OR REPLACE FUNCTION public.fc_id_est_central (
)
RETURNS integer AS
$body$
declare
    _id_est integer;
begin
    select id_est into _id_est
    from tb_est
    where
        tb_est.tp_est = 'C';
        
    return _id_est;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_init_est (
  _id_est integer,
  _upd_id boolean
)
RETURNS boolean AS
$body$
declare
    _seq_list refcursor;
    _seq record;
    _est record;
    _id_init integer;
    _cmd varchar;
    _tab record;
    _max_id integer;
begin
    select * into _est
    from tb_est
    where
        id_est = _id_est;
        
    open _seq_list for
        select * 
        from pg_class 
        where
            relkind = 'S';
            
    fetch _seq_list into _seq;
    
    perform fc_en_trg(false, false);
    
    while found loop
        select * into _tab
        from vw_tab_uni
        where
            tablename = replace(_seq.relname, 'sq_', 'tb_');
    
        if (_tab.op = 'S') then
        
            _id_init := _est.seq_inc + _est.id_est;
            
            raise notice '% %', _seq.relname, _id_init;
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by ' || _est.seq_inc || ' restart with ' || _id_init;
            raise notice '%', _cmd;
            
            execute _cmd;
            
            if (_upd_id is null) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = ' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' / ' || 
                    _est.seq_inc;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            elsif (_upd_id) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = (' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' * ' || 
                    _est.seq_inc || ') + ' || _est.id_est;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            end if;
        else
            
            execute 'select max(' || replace(_seq.relname, 'sq_', 'id_') || ') from ' || _tab.tablename into _max_id;
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by 1 restart with ' || _max_id;

            raise notice '%', _cmd;
            
            execute _cmd;
        
        end if;
    
        fetch _seq_list into _seq;
    end loop;
    
    perform fc_en_trg(true, false);
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_limpa_db (
)
RETURNS boolean AS
$body$
begin
    perform fc_en_trg(false, false);
    
    delete from "tb_blt";
    delete from "tb_blt_ret";
    delete from "tb_bx_ct";
    delete from "tb_ch";
    delete from "tb_ct";
    delete from "tb_emis_blt";
    
    delete from "tb_log";
    delete from "tb_log_con";
    delete from "tb_mnt_estq";
    delete from "tb_mov_cx";
    delete from "tb_mov_fnc";
    delete from "tb_nf";
    delete from "tb_nf_item";
    delete from "tb_nf_item_grd_estq";
    delete from "tb_nf_parc";
    delete from "tb_nfe";
    delete from "tb_nfe_dest";
    delete from "tb_nfe_evt";
    delete from "tb_os";
    
    delete from "tb_ped";
    delete from "tb_vnd";
    
    delete from "tb_item";
    delete from "tb_part" where tp_part not like '%[E]%' or tp_part is null;
    
    perform fc_en_trg(true, false);
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct__ct_af (
)
RETURNS trigger AS
$body$
BEGIN
    if (tg_op = 'INSERT') and (fc_id_est_con() is null) then
        
        update tb_ct set
            stat = 'Q'
        where
            id_emp = new.id_emp_ct and
            id_ct = new.id_ct;
            
    elsif (tg_op = 'DELETE') and (fc_id_est_con() is null) then
        
        update tb_ct set
            stat = 'P'
        where
            id_emp = old.id_emp_ct and
            id_ct = old.id_ct;
            
    end if;
    
    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op varchar;
    _descr varchar;
BEGIN
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select nome into _descr
        from tb_part
        where
            id_part = new.id_part;
                
        if (new.tp_bx = 'R') then
            _op := 'C';
            _descr := 'RECEBIMENTO ' || _descr;
        else
            _op := 'D';
            _descr := 'PAGAMENTO ' || _descr;
        end if;
            
        perform fc_gera_mov_fnc(new.id_emp, new.id_cx, new.id_usr, new.dt_bx, cast(current_time as time), _descr,
                _op, new.vl_pag, 'BX_CT', new.id_bx_ct);
        
    elsif (tg_op = 'DELETE') and (fc_id_est_con() is null) then
        
        select nome into _descr
        from tb_part
        where
            id_part = old.id_part;
                
        if (old.tp_bx = 'R') then
            _op := 'D';
            _descr := 'RECEBIMENTO CANCELADO ' || _descr;
        else
            _op := 'C';
            _descr := 'PAGAMENTO CANCELADO ' || _descr;
        end if;
            
        perform fc_gera_mov_fnc(old.id_emp, old.id_cx, old.id_usr, old.dt_bx, cast(current_time as time), _descr,
                _op, old.vl_pag, 'BX_CT', old.id_bx_ct);
    end if;
    
    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_item_af (
)
RETURNS trigger AS
$body$
declare
    _grd_estq record;
    _grd_estq_list refcursor;
begin
    if (tg_op = 'INSERT') and (fc_id_est_con() is null) then
    
        open _grd_estq_list for
            select 
                tb_dep.id_emp,
                tb_dep.id_dep,
                tb_grd_estq.id_grd_estq
            from tb_dep, tb_grd_estq;
        
        fetch _grd_estq_list into _grd_estq;
        
        while found loop
            insert into tb_item_estq
                (id_item, id_emp, id_dep, id_grd_estq, vl_estq)
            values
                (new.id_item, _grd_estq.id_emp, _grd_estq.id_dep, _grd_estq.id_grd_estq, 0);
        
            fetch _grd_estq_list into _grd_estq;
        end loop;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_log_af (
)
RETURNS trigger AS
$body$
declare
    _est_list refcursor;
    _est record;
    _id_est_con integer;
    _tab record;
begin
    
    select * into _tab
    from vw_tab_uni
    where
        tablename = new.org;
    
    
    if (new.id_est is null or (new.id_est <> fc_id_est_local() and new.id_est <> fc_id_est_central() )) and (new.sit is null) and 
        ( (_tab.op in ('G', 'S') and fc_id_est_local() = fc_id_est_central()) or (_tab.op in ('S')) )
    then
        
        _id_est_con := fc_id_est_con();
        
        
        if (fc_id_est_local() <> fc_id_est_central()) then
            open _est_list for
                select *
                from tb_est
                where
                    tb_est.tp_est = 'C';
                    
        elsif (_id_est_con is null) then
            open _est_list for
                select *
                from tb_est
                where
                    not tb_est.local;
        else
            open _est_list for
                select *
                from tb_est
                where
                    not tb_est.local and
                    tb_est.id_est <> _id_est_con;
        end if;
        
        fetch _est_list into _est;
        
        while found loop
        
            insert into tb_log
                (id_log, org, op, col_pk, val_pk, id_est, dt_hr, sit)
            values
                (nextval('sq_log'), new.org, new.op, new.col_pk, new.val_pk, _est.id_est, new.dt_hr, 'P');
            
            fetch _est_list into _est;
        
        end loop;
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;

        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
                
                
            if (_op_fnc.tp_op_fnc = 'CRED') then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, id_nf, id_nf_parc)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _nf.id_part_emt, cast(_nf.num as varchar), new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', new.id_nf, new.id_nf_parc);
                     
            elsif (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
                insert into tb_ch
                    (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                     dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_nf, id_nf_parc)
                values
                    (new.id_emp, nextval('sq_ch'), 'P', _nf.id_part_emt, new.emit, new.cpf_cnpj,
                     _nf.dt_op, new.dt_venc, new.vl_parc, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_nf, new.id_nf_parc);
                     
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_part_obs_bf (
)
RETURNS trigger AS
$body$
BEGIN
    if (fc_id_est_con() is null) then
        new."dt_obs" = CURRENT_DATE;
    end if;

    return new;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _cond_pagto record;
begin
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        if (new.tp_vnd = 'V') then
            select * into _cond_pagto
            from tb_cond_pagto
            where
                id_cond_pagto = new.id_cond_pagto;
            
            perform fc_gera_mov_fnc(new.id_emp, new.id_cx, new.id_usr, new.dt_vnd, cast(current_time as time), 'VENDA ' || new.nome || ' ' || _cond_pagto.descr,
                'C', new.vl_tot, 'VND', new.id_vnd);
        end if;
    elsif (tg_op = 'DELETE') and (fc_id_est_con() is null) then
        if (old.tp_vnd = 'V') then
            select * into _cond_pagto
            from tb_cond_pagto
            where
                id_cond_pagto = old.id_cond_pagto;

            perform fc_gera_mov_fnc(old.id_emp, old.id_cx, old.id_usr, old.dt_vnd, cast(current_time as time), 'VENDA CANCELADA '  || old.nome || ' ' || _cond_pagto.descr,
                'D', old.vl_tot, 'VND', old.id_vnd);
        end if;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            id_vnd = old.id_vnd and
            id_vnd_parc = old.id_vnd_parc;

        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_vnd = old.id_vnd and
            id_vnd_parc = old.id_vnd_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _vnd
        from tb_vnd
        where
            id_emp = new.id_emp and
            id_vnd = new.id_vnd;

        if (_vnd.tp_vnd = 'V') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
                
                
            if (_op_fnc.tp_op_fnc = 'CRED') then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, id_vnd, id_vnd_parc)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _vnd.id_cli, cast(new.id_vnd as varchar), new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', new.id_vnd, new.id_vnd_parc);
                     
            elsif (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
                insert into tb_ch
                    (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                     dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_vnd, id_vnd_parc)
                values
                    (new.id_emp, nextval('sq_ch'), 'R', _vnd.id_cli, new.emit, new.cpf_cnpj,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_vnd, new.id_vnd_parc);
                     
            end if;
            
        end if;
        
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_est
  ADD COLUMN tp_est VARCHAR(1);

COMMENT ON COLUMN public.tb_est.tp_est
IS 'C - Central E - Estacao';

-- object recreation
DROP VIEW public.vw_tab_uni;

CREATE VIEW public.vw_tab_uni (
    tablename,
    op)
AS
 SELECT pg_tables.tablename, 
        CASE
            WHEN pg_tables.tablename = ANY (ARRAY['tb_bairro'::name, 'tb_bnc'::name, 'tb_bnc_blt'::name, 'tb_cfop'::name, 'tb_cnae'::name, 'tb_cnt_bnc'::name, 'tb_cond_pagto'::name, 'tb_cond_pagto_parc'::name, 'tb_conv'::name, 'tb_cx'::name, 'tb_dep'::name, 'tb_est'::name, 'tb_grd_estq'::name, 'tb_grp_cfop'::name, 'tb_grp_cfop_nat_op'::name, 'tb_grp_item'::name, 'tb_grp_trib'::name, 'tb_grp_trib_nat_op'::name, 'tb_grp_usr'::name, 'tb_logr'::name, 'tb_marca'::name, 'tb_mod_frete'::name, 'tb_mod_nf'::name, 'tb_mtv_dev_ch'::name, 'tb_munic'::name, 'tb_nat_op'::name, 'tb_ncm'::name, 'tb_obj_os'::name, 'tb_op_fnc'::name, 'tb_org_icms'::name, 'tb_prio_os'::name, 'tb_prod_anp'::name, 'tb_reg_trib'::name, 'tb_serv'::name, 'tb_sis_grid'::name, 'tb_sis_valid'::name, 'tb_tp_item'::name, 'tb_trib_cofins'::name, 'tb_trib_icms'::name, 'tb_trib_ipi'::name, 'tb_trib_pis'::name, 'tb_uf'::name, 'tb_und_med'::name]) THEN 'G'::text
            WHEN pg_tables.tablename = ANY (ARRAY['tb_emp_cnf'::name, 'tb_item_estq'::name, 'tb_item_prc_vnd_log'::name, 'tb_script'::name]) THEN 'N'::text
            ELSE 'S'::text
        END AS op
   FROM pg_tables
  WHERE pg_tables.schemaname = 'public'::name
  ORDER BY pg_tables.tablename;