CREATE OR REPLACE FUNCTION public.fc_calc_ir (
  _id_part integer,
  _dt date,
  _vl numeric
)
RETURNS numeric AS
$body$
declare
    _qtd_depend integer;
    _vl_bc_ir numeric;
    _vl_ir numeric;
    _part record;
    _vl_depend numeric;
    _vl_abat_ir numeric;
    _vl_tot_abat_ir numeric;
begin
    _vl := cast(_vl as numeric(12,2));
    
    select count(*) into _qtd_depend
    from tb_part_cred
    where
        id_part = _id_part;
        
    select 
        distinct tb_ir.vl_depend 
    into _vl_depend
    from tb_ir
    where
        _dt between tb_ir.dt_i and tb_ir.dt_f;
        

    select
        tb_part.id_part,
        tb_part.vl_pa,
        tb_grp_disp.vl_perc_bc_ir
    into
        _part
    from tb_part
    join tb_grp_disp on
        (tb_part.id_grp_disp = tb_grp_disp.id_grp_disp)
    where 
        tb_part.id_part = _id_part;
        
        
    select
        sum(
            case 
                when tb_disp.tp = 'V' then tb_grp_disp_item.vl_disp
                when (_vl * tb_grp_disp_item.vl_disp / 100 > tb_disp.vl_max) then tb_disp.vl_max
                else _vl * tb_grp_disp_item.vl_disp / 100
            end 
        ) as vl_abat_ir
    into
        _vl_abat_ir
    from tb_part
    join tb_grp_disp on
        (tb_part.id_grp_disp = tb_grp_disp.id_grp_disp)
    join tb_grp_disp_item on
        (tb_part.id_grp_disp = tb_grp_disp_item.id_grp_disp)
    join tb_disp on
        (tb_grp_disp_item.id_disp = tb_disp.id_disp)
    where 
        tb_part.id_part = _id_part and
        tb_disp.abat_ir;
        
    _vl_tot_abat_ir := coalesce(_part.vl_pa, 0) +
    	cast(coalesce(_vl_depend * _qtd_depend, 0) as numeric(12,2)) +
        cast(coalesce(_vl_abat_ir, 0) as numeric(12,2));
        
    if (_vl_tot_abat_ir < 528) then
    	_vl_tot_abat_ir := 528;
    end if;
    
    _vl_bc_ir := cast(coalesce(_vl * _part.vl_perc_bc_ir / 100, 0) as numeric(12,2)) - 
    	cast(_vl_tot_abat_ir as numeric(12,2));
    
    if (_vl_bc_ir <= 0) then
    	return 0;
    end if;
   
    raise notice '_part.vl_perc_bc_ir %', _part.vl_perc_bc_ir;
   
    raise notice '%', _vl_bc_ir;
    
    /*raise notice '_part.vl_perc_bc_ir %', _part.vl_perc_bc_ir;
    
    _vl_bc_ir := cast(coalesce(_vl * _part.vl_perc_bc_ir / 100, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - coalesce(_part.vl_pa, 0);
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - cast(coalesce(_vl_depend * _qtd_depend, 0) as numeric(12,2));
    raise notice '%', _vl_bc_ir;
    
    _vl_bc_ir := _vl_bc_ir - cast(coalesce(_vl_abat_ir, 0) as numeric(12,2));
	raise notice '%', _vl_bc_ir;
    */

    select 
    	sum(vl_irrf)
    into
    	_vl_ir
	from
	(
		select
			tb_ir.vl_i,
			tb_ir.vl_f,
			tb_ir.vl_f - tb_ir.vl_i,
			(_vl_bc_ir - tb_ir.vl_i),
		    case 
			    when (_vl_bc_ir > tb_ir.vl_f) then
			    	(tb_ir.vl_f - tb_ir.vl_i) * tb_ir.vl_aliq / 100
		    	when (_vl_bc_ir - tb_ir.vl_i > 0) then
		    		(_vl_bc_ir - tb_ir.vl_i) * tb_ir.vl_aliq / 100
		    	else 0
		    end as vl_irrf
		from tb_ir
		where
			_dt between tb_ir.dt_i and tb_ir.dt_f
		order by
			tb_ir.vl_i
	) as tb;
--    select
--        (_vl_bc_ir * tb_ir.vl_aliq / 100) - tb_ir.vl_ded
--    into
--        _vl_ir
--    from tb_ir
--    where
--        _dt between tb_ir.dt_i and tb_ir.dt_f and
--        _vl_bc_ir between tb_ir.vl_i and tb_ir.vl_f;

    return cast(_vl_ir as numeric(12,2));
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

