DROP TRIGGER if exists tr_emp_cnf_log ON public.tb_emp_cnf;

DROP TRIGGER if exists tr_sis_atu_log ON public.tb_sis_atu;

CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
    _pk varchar[];
    _log_tab boolean;
begin
    delete from tb_sis_uni
    where
        tab = _tab;
        
    select _tab not in (
        'tb_sis_uni',
        'tb_log',
        'tb_log_con',
        'tb_sinc',
        'tb_sinc_stat',
        'tb_item_estq',
        'tb_script',
        'tb_sis_atu',
        'tb_emp_cnf'
    ) into _log_tab;


    if (_log_tab and _install) then
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        execute 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log after insert or update or delete ' ||
            ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';

        perform fc_add_col('public.' || _tab, 'dt_hr_ult_alt', 'timestamp');
        
        select
            array(
                select 
                    cast(c.column_name as varchar)
                from information_schema.table_constraints tc
                join information_schema.constraint_column_usage as ccu using 
                    (constraint_schema, constraint_name)
                join information_schema.columns as c on 
                    (c.table_schema = tc.constraint_schema and 
                     tc.table_name = c.table_name and 
                     ccu.column_name = c.column_name)
                where 
                    constraint_type = 'PRIMARY KEY' and
                    tc.table_name = _tab
                )
        into _pk;
        
        raise notice 'Tabela: %', _tab;
        
        insert into tb_sis_uni
            (tab, pk)
        values
            (_tab, _pk);
        
        
        return true;
    else 
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

