CREATE OR REPLACE FUNCTION public.fc_item_estq (
  _id_item integer,
  _id_emp integer,
  _id_dep integer,
  _id_grd_estq varchar,
  _op varchar,
  _vl_qtd numeric
)
RETURNS boolean AS
$body$
DECLARE
    _rec record;
    _vl_qtd_mov numeric;
BEGIN
    select * into _rec
    from tb_item_estq
    where
        tb_item_estq.id_item = _id_item and
        tb_item_estq.id_emp = _id_emp and
        tb_item_estq.id_dep = _id_dep and
        tb_item_estq.id_grd_estq = _id_grd_estq;
        
    _vl_qtd_mov := ifthen(lower(_op) = 's', _vl_qtd * -1, _vl_qtd);
    
        
    if (not found) then
        
        insert into tb_item_estq
            (id_item, id_emp, id_dep, id_grd_estq, vl_estq)
        values
            (_id_item, _id_emp, _id_dep, _id_grd_estq, _vl_qtd_mov);

    else
        
        update tb_item_estq set
            vl_estq = 
                case 
                    when lower(_op) = 'i' then _vl_qtd_mov
                    else coalesce(vl_estq) + _vl_qtd_mov
                end
        where
            id_item = _id_item and
            id_emp = _id_emp and
            id_dep = _id_dep and
            id_grd_estq = _id_grd_estq;
    
    end if;
    
    return true;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;