CREATE TABLE public.tb_dre (
  id_emp INTEGER NOT NULL, 
  id_dre INTEGER NOT NULL, 
  dt_i DATE, 
  dt_f DATE, 
  obs TEXT, 
  sit VARCHAR(1), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  CONSTRAINT pk_dre PRIMARY KEY(id_emp, id_dre)
) ;

CREATE TABLE public.tb_dre_item (
  id_emp INTEGER NOT NULL, 
  id_dre INTEGER NOT NULL, 
  id_dre_item INTEGER NOT NULL, 
  id_grp_dre INTEGER NOT NULL, 
  id_plan_ct VARCHAR(100) NOT NULL, 
  descr VARCHAR(255), 
  vl_op NUMERIC(12,2), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  CONSTRAINT pk_dre_item PRIMARY KEY(id_emp, id_dre, id_dre_item)
) ;

ALTER TABLE public.tb_dre_item
  ADD CONSTRAINT fk__dre_item__dre FOREIGN KEY (id_emp, id_dre)
    REFERENCES public.tb_dre(id_emp, id_dre)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_dre_item
  ADD CONSTRAINT fk__dre_item__grp_dre FOREIGN KEY (id_grp_dre)
    REFERENCES public.tb_grp_dre(id_grp_dre)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_dre_item
  ADD CONSTRAINT fk__dre_item__plan_ct FOREIGN KEY (id_plan_ct)
    REFERENCES public.tb_plano_ct(id_plano_ct)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_dre
  ADD CONSTRAINT fk__dre__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;