CREATE SEQUENCE public.sq_esp_merc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE SEQUENCE public.sq_ped_carreg
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_esp_merc (
  id_esp_merc INTEGER NOT NULL, 
  descr VARCHAR(150), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_esp_merc PRIMARY KEY(id_esp_merc)
) ;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_fec_ped_compl (
  _id_emp integer,
  _id_ped integer,
  _id_dep_org integer,
  _id_dep_dst integer
)
RETURNS boolean AS
$body$
declare
    _ped record;
    _ped_item record;
    _ped_item_list refcursor;
    
    _id_mnt_estq integer;
    _id_mnt_estq_item integer;
    
    _id_grd_estq varchar;
begin

    _id_grd_estq := fc_get_emp_cnf(_id_emp, 08004);
    
    select * into _ped
    from tb_ped
    where
        id_emp = _id_emp and
        id_ped = _id_ped;
    
    delete from tb_mnt_estq
    where
        id_emp = _id_emp and
        org = 'PED.' || _id_ped and
        id_org = cast(_id_ped as varchar);
        
        
    _id_mnt_estq := nextval('sq_mnt_estq');
    
    insert into tb_mnt_estq
        (id_emp, id_mnt_estq, dt_mnt_estq, op, id_dep_org, id_dep_dst, descr, org, id_org)
    values
        (_id_emp, _id_mnt_estq, _ped.dt_ped, 'T', _id_dep_org, _id_dep_dst, 'CARREGAMENTO COMPLEMENTAR ' || _id_ped, 'PED.' || _id_ped, _id_ped);
        
    
    open _ped_item_list for
        select
            tb_ped_item.*,
            tb_item.id_und_med as id_und_med_item
        from tb_ped_item
        join tb_item on
            (tb_ped_item.id_item = tb_item.id_item)
        where
            id_emp = _id_emp and
            id_ped = _id_ped;
            
    fetch _ped_item_list into _ped_item;
    
    _id_mnt_estq_item := 0;
    
    while found loop
        
        _id_mnt_estq_item := _id_mnt_estq_item + 1;
    
        insert into tb_mnt_estq_item
            (id_emp, id_mnt_estq, id_mnt_estq_item, id_item, id_grd_estq, id_und_med, vl_qtd, 
             id_und_med_mov, vl_qtd_mov, 
             op, id_dep_org, id_dep_dst)
        values
            (_id_emp, _id_mnt_estq, _id_mnt_estq_item, _ped_item.id_item, _id_grd_estq, _ped_item.id_und_med_item, coalesce(_ped_item.vl_qtd_mov, _ped_item.vl_qtd), 
             _ped_item.id_und_med_item, coalesce(_ped_item.vl_qtd_mov, _ped_item.vl_qtd),
             'T', _id_dep_org, _id_dep_dst);
            
        fetch _ped_item_list into _ped_item;
        
    end loop;
    
    
    update tb_ped set
        sit = 'F'
    where
        id_emp = _id_emp and
        id_ped = _id_ped;
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_ped_carreg (
  id_emp INTEGER NOT NULL, 
  id_ped_carreg INTEGER NOT NULL, 
  dt_lanc DATE, 
  dt_emb DATE, 
  tp_frete VARCHAR(10), 
  id_nat_op INTEGER, 
  id_tom INTEGER, 
  num_ped VARCHAR(50), 
  id_rem INTEGER, 
  id_ender_rem INTEGER, 
  id_dest INTEGER, 
  id_ender_dest INTEGER, 
  id_exp INTEGER, 
  id_ender_exp INTEGER, 
  id_rec INTEGER, 
  id_ender_rec INTEGER, 
  id_item_trp INTEGER, 
  vl_qtd_trp NUMERIC(12,4), 
  id_und_med_trp VARCHAR(5), 
  id_esp_merc_trp INTEGER, 
  vl_prc_trp NUMERIC(12,4), 
  vl_tot_trp NUMERIC(12,2), 
  obs VARCHAR(500), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_ped_carreg PRIMARY KEY(id_emp, id_ped_carreg)
) ;

CREATE TABLE public.tb_ped_carreg_ord (
  id_emp INTEGER NOT NULL, 
  id_ped_carreg INTEGER NOT NULL, 
  id_ped_carreg_ord INTEGER NOT NULL, 
  id_veic INTEGER, 
  id_mot INTEGER, 
  id_part INTEGER, 
  vl_qtd NUMERIC(12,4), 
  vl_prc NUMERIC(12,4), 
  vl_tot NUMERIC(12,4), 
  obs VARCHAR(500), 
  CONSTRAINT pk_ped_carreg_ord PRIMARY KEY(id_emp, id_ped_carreg, id_ped_carreg_ord)
) ;

ALTER TABLE public.tb_ped_carreg_ord
  ADD CONSTRAINT fk__ped_carreg_ord__mot FOREIGN KEY (id_mot)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg_ord
  ADD CONSTRAINT fk__ped_carreg_ord__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg_ord
  ADD CONSTRAINT fk__ped_carreg_ord__ped_carreg FOREIGN KEY (id_emp, id_ped_carreg)
    REFERENCES public.tb_ped_carreg(id_emp, id_ped_carreg)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg_ord
  ADD CONSTRAINT fk__ped_carreg_ord__veic FOREIGN KEY (id_veic)
    REFERENCES public.tb_veic(id_veic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__cli FOREIGN KEY (id_tom)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__dest FOREIGN KEY (id_dest)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__esp_merc_trp FOREIGN KEY (id_esp_merc_trp)
    REFERENCES public.tb_esp_merc(id_esp_merc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__exp FOREIGN KEY (id_exp)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__item_trp FOREIGN KEY (id_item_trp)
    REFERENCES public.tb_item(id_item)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__nat_op FOREIGN KEY (id_nat_op)
    REFERENCES public.tb_nat_op(id_nat_op)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__rec FOREIGN KEY (id_rec)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__rem FOREIGN KEY (id_rem)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_carreg
  ADD CONSTRAINT fk__ped_carreg__und_med_trp FOREIGN KEY (id_und_med_trp)
    REFERENCES public.tb_und_med(id_und_med)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

