CREATE OR REPLACE FUNCTION public.fc_canc_sit_ch (
  _id_emp integer,
  _id_ch integer,
  _sit varchar
)
RETURNS boolean AS
$body$
declare
    _ch record;
    _id_ch_sit integer;
    _ch_sit record;
begin
    select max(id_ch_sit) into _id_ch_sit
    from tb_ch_sit
    where
        id_emp = _id_emp and
        id_ch = _id_ch and
        sit = _sit;
        
    select * into _ch_sit
    from tb_ch_sit
    where
        id_emp = _id_emp and
        id_ch = _id_ch and
        id_ch_sit < _id_ch_sit
    order by
        id_ch_sit desc
    limit 1;
    
    if found then
        update tb_ch set
            dt_sit = _ch_sit.dt_sit,
            sit = _ch_sit.sit
        where
            id_emp = _id_emp and
            id_ch = _id_ch;
                
        delete from tb_ch_sit
        where
            id_emp = _id_emp and
            id_ch = _id_ch and
            id_ch_sit = _id_ch_sit;
    end if;
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_sit_ch (
  _id_emp integer,
  _id_ch integer,
  _sit varchar,
  _obs varchar,
  _dt date,
  _id_cnt_bnc integer
)
RETURNS boolean AS
$body$
declare
    _id_ch_sit integer;
begin
    select coalesce(max(id_ch_sit), 0) + 1 into _id_ch_sit
    from tb_ch_sit
    where
        id_emp = _id_emp and
        id_ch = _id_ch;
    
    insert into tb_ch_sit 
        (id_emp, id_ch, id_ch_sit, dt_sit, sit, obs)
    values
        (_id_emp, _id_ch, _id_ch_sit, current_date, _sit, _obs);
        
    if (_id_cnt_bnc is not null) then
        update tb_ch set
            id_cnt_bnc = _id_cnt_bnc
        where
            id_emp = _id_emp and
            id_ch = _id_ch;
    end if;
    
    update tb_ch set
        dt_sit = _dt,
        sit = _sit
    where
        id_emp = _id_emp and
        id_ch = _id_ch;
        
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_bx_ct = old.id_bx_ct and
            id_bx_ct_pagto = old.id_bx_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
            _id_ch := nextval('sq_ch');
                
            insert into tb_ch
                (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                 dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_bx_ct, id_bx_ct_pagto, id_cnt_bnc)
            values
                (new.id_emp, _id_ch, ifthen(_bx_ct.tp_bx = 'R', 'R', 'E'), _bx_ct.id_part, new.emit, new.cpf_cnpj,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_bx_ct, new.id_bx_ct_pagto, new.id_cnt_bnc);
                
            if (_bx_ct.tp_bx = 'R') then
                perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'RECEBIMNTO DE DUPLICATA ' || _bx_ct.id_bx_ct, _bx_ct.dt_bx, null);
            else
                perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'PAGAMENTO DE DUPLICATA ' || _bx_ct.id_bx_ct, _bx_ct.dt_bx, null);
            end if;
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_ch_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'DELETE' and old.tp_ch = 'E') then
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'ch' and
            id_org = old.id_ch;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        if (new.tp_ch = 'E' and tg_op = 'INSERT') then

            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr, 'D', new.vl_ch, new.obs, false, 'ch', new.id_ch, new.id_part);

        elseif (tg_op = 'UPDATE' and (old.sit = 'P' or old.sit = 'D') and new.sit = 'DEP') then
            
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_sit, new.dt_sit, new.nr, 'C', new.vl_ch, 'DEPOSITO', false, 'ch', new.id_ch, new.id_part);

        elseif (tg_op = 'UPDATE' and new.sit = 'P') then
            delete from tb_mov_bnc
            where
                id_emp = new.id_emp and
                org = 'ch' and
                id_org = new.id_ch;
        end if;

        return new;

    elsif (tg_op = 'DELETE') then

        return old;

    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_bnc_bf (
)
RETURNS trigger AS
$body$
declare
    _ch record;
    _id_ch_sit integer;
    _ch_sit record;
begin
    if (tg_op = 'UPDATE' and old.conc <> new.conc and new.org = 'ch') then
        if (new.conc) then
        
            if (new.sit_conc = 'CONC') then
                perform fc_sit_ch(new.id_emp, new.id_org, 'Q', 'QUITADO', new.dt_conc, null);
            elsif (new.sit_conc = 'CHDEV') then
                select * into _ch
                from tb_ch
                where 
                    id_emp = new.id_emp and
                    id_ch = new.id_org;

                if (_ch.dt_dev1 is null) then
                
                    update tb_ch set
                        sit = 'D',
                        dt_dev1 = new.dt_conc,
                        id_mtv_dev_ch1 = new.id_mtv_dev_ch
                    where 
                        id_emp = new.id_emp and
                        id_ch = new.id_org;
                else
                    update tb_ch set
                        sit = 'D',
                        dt_dev2 = new.dt_conc,
                        id_mtv_dev_ch2 = new.id_mtv_dev_ch
                    where 
                        id_emp = new.id_emp and
                        id_ch = new.id_org;
                end if;
                
                perform fc_sit_ch(new.id_emp, new.id_org, 'D', 'DEVOLVIDO', new.dt_conc, null);
                
                
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, 
                     descr, conc, org, id_org, id_part, dt_conc, sit_conc, id_mtv_dev_ch)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_lanc, 
                     'CHEQUE DEVOLVIDO', new.conc, 'mov_bnc', new.id_mov_bnc, new.id_part, new.dt_conc, new.sit_conc, new.id_mtv_dev_ch);
            end if;
            
        elsif (not new.conc) then
            select max(id_ch_sit) into _id_ch_sit
            from tb_ch_sit
            where
                id_emp = new.id_emp and
                id_ch = new.id_org and
                sit in ('Q', 'D');
                
            select * into _ch_sit
            from tb_ch_sit
            where
                id_emp = new.id_emp and
                id_ch = new.id_org and
                id_ch_sit < _id_ch_sit
            order by
                id_ch_sit desc
            limit 1;
            
            if found then
            
                update tb_ch set
                    dt_sit = _ch_sit.dt_sit,
                    sit = _ch_sit.sit
                where
                    id_emp = new.id_emp and
                    id_ch = new.id_org;
                
                delete from tb_ch_sit
                where
                    id_emp = new.id_emp and
                    id_ch = new.id_org and
                    id_ch_sit = _id_ch_sit;
                    
            end if;
            
            if (old.sit_conc = 'CHDEV' and old.org = 'ch') then
                delete from tb_mov_bnc
                where
                    id_emp = new.id_emp and
                    org = 'mov_bnc' and
                    id_org = new.id_mov_bnc;
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    elsif (tg_op = 'DELETE') then
        if (old.org = 'ch') then
            delete from tb_mov_bnc
            where
                id_emp = old.id_emp and
                org = 'mov_bnc' and
                id_org = old.id_mov_bnc;
        end if;
            
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

ALTER TABLE public.tb_bx_ct_pagto
  ADD COLUMN id_cnt_bnc INTEGER;

ALTER TABLE public.tb_ch
  ADD COLUMN id_cx INTEGER;

ALTER TABLE public.tb_mov_bnc
  ALTER COLUMN conc SET DEFAULT false;

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN sit_conc VARCHAR(5);

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN id_mtv_dev_ch INTEGER;

ALTER TABLE public.tb_mov_bnc
  ADD CONSTRAINT fk__mov_bnc__mtv_dev_ch FOREIGN KEY (id_mtv_dev_ch)
    REFERENCES public.tb_mtv_dev_ch(id_mtv_dev_ch)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ch
  ADD CONSTRAINT fk__ch__cx FOREIGN KEY (id_emp, id_cx)
    REFERENCES public.tb_cx(id_emp, id_cx)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_bx_ct_pagto
  ADD CONSTRAINT fk__bx_ct_pagto__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_mov_bnc_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_mov_bnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_mov_bnc_bf();

