SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_parc_cli_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete record;
    _id_veic integer;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'ROM_FRETE.CLI' and
            id_org = old.id_rom_frete and
            id_org_item = old.id_rom_frete_parc_cli;
            -- org = 'ROM_FRETE.CLI.' || old.id_rom_frete || '.' || old.id_rom_frete_parc_cli;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
    
        select * into _rom_frete
        from tb_rom_frete
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
    
        _id_ct := nextval('sq_ct');
        
        select id_veic into _id_veic
        from tb_rom_frete_item
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete
        order by
            id_rom_frete_item
        limit 1;
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, obs,
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             id_plano_ct, id_cnt_bnc,
             id_rom_frete, id_veic,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _rom_frete.id_tom, new.id_rom_frete, new.id_rom_frete_parc_cli, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', new.obs,
             'ROM_FRETE.CLI.' || new.id_rom_frete || '.' || new.id_rom_frete_parc_cli, 'ROM_FRETE.CLI', new.id_rom_frete, new.id_rom_frete_parc_cli, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             new.id_plano_ct, new.id_cnt_bnc,
             new.id_rom_frete, _id_veic,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);
        
        if (_op_fnc.auto_bx) then
            perform fc_bx_ct(new.id_emp, _id_ct);
        end if;
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_rom_frete_item_parc_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _rom_frete_item record;
    _rom_frete record;
    _descr varchar;
BEGIN
    
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'ROM_FRETE.ITEM' and
            id_org = old.id_rom_frete and
            id_org_item = old.id_rom_frete_item and
            org = 'ROM_FRETE.ITEM.' || old.id_rom_frete || '.' || old.id_rom_frete_item || '.' || old.id_rom_frete_item_parc;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            /*tp_op_fnc = 'DUP'
        limit 1;*/
    
        select
            tb_rom_frete.*,
            trim(substring(tb_part_tom.nome, 1, 15)) as nome_tom,
            trim(substring(tb_part_dest.nome, 1, 15)) as nome_dest
        into _rom_frete
        from tb_rom_frete
        left outer join tb_part as tb_part_tom on
            (tb_rom_frete.id_tom = tb_part_tom.id_part)
        left outer join tb_part as tb_part_dest on
            (tb_rom_frete.id_dest = tb_part_dest.id_part)
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete;
            
        select * into _rom_frete_item
        from tb_rom_frete_item
        where
            id_emp = new.id_emp and
            id_rom_frete = new.id_rom_frete and
            id_rom_frete_item = new.id_rom_frete_item;
    
        _id_ct := nextval('sq_ct');
        
        _descr := _rom_frete.nome_tom || ' / ' || _rom_frete.nome_dest || ' R. ' || _rom_frete.id_rom_frete || coalesce(' ' || new.obs, '');-- || ' D. ' || _rom_frete.vl_qtd;
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, tp_org, id_org, id_org_item,
             id_op_fnc, vl_quit, vl_rest, 
             obs,
             id_plano_ct, id_cnt_cst, id_cnt_bnc,
             id_rom_frete, id_veic,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _rom_frete_item.id_colab, new.id_rom_frete, new.parc, new.qtd_parc,
             _rom_frete.dt_lanc, new.dt_venc, new.vl_parc, 'P', 
             'ROM_FRETE.ITEM.' || new.id_rom_frete || '.' || new.id_rom_frete_item || '.' || new.id_rom_frete_item_parc, 'ROM_FRETE.ITEM', new.id_rom_frete, new.id_rom_frete_item, 
             _op_fnc.id_op_fnc, 0, new.vl_parc, 
             _descr,
             new.id_plano_ct, new.id_cnt_cst, new.id_cnt_bnc,
             new.id_rom_frete, _rom_frete_item.id_veic,
             new.vl_parc, 0, 0, 0, 0, 
             _rom_frete.id_usr_ult_alt, _rom_frete.dt_hr_ult_alt);
       
        if (_op_fnc.auto_bx) then
            perform fc_bx_ct(new.id_emp, _id_ct);
        end if;
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

update tb_item_estq set dt_hr_ult_alt = current_timestamp;