SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_ext_estq_nf (
  _id_emp integer,
  _id_nf integer,
  _descr varchar
)
RETURNS boolean AS
$body$
declare
    _nf record;
    _list refcursor;
    _item record;
    _op varchar;
    _id_mnt_estq integer;
    _id_mnt_estq_item integer;
    _id_dep integer;
begin
    select * into _nf
    from tb_nf 
    where
        id_emp = _id_emp and
        id_nf = _id_nf;
            
    open _list for
        select *
        from tb_nf_item
        where
            id_emp = _id_emp and
            id_nf = _id_nf and
            mov_estq = true
        order by
            id_dep,
            id_nf_item;
            
    fetch _list into _item;
    
    if (not found) then
    
        return false;
    
    else
    
        if (_nf.tp_op = '[E]') then 
            _op := 'S';
        else
            _op := 'E';
        end if;
        
        _id_dep := 0;
        
        while (found) loop
        
            if (_id_dep <> _item.id_dep) then
                _id_mnt_estq      := nextval('sq_mnt_estq');
                _id_mnt_estq_item := 1;
                _id_dep           := _item.id_dep;
            
                insert into tb_mnt_estq
                    (id_emp, id_mnt_estq, dt_mnt_estq, op, id_dep_dst, descr, 
                     org)
                values
                    (_id_emp, _id_mnt_estq, current_date, _op, _item.id_dep, _descr,
                     'NF.' || _id_nf);
                    
            end if;
            
            insert into tb_mnt_estq_item
                (id_emp, id_mnt_estq, id_mnt_estq_item, op, id_dep_dst,
                 id_item, id_grd_estq, id_und_med, vl_qtd, id_und_med_mov, vl_qtd_mov)
            values
                (_id_emp, _id_mnt_estq, _id_mnt_estq_item, _op, _id_dep,
                 _item.id_item, _item.id_grd_estq, _item.id_und_med_mov, _item.vl_qtd_mov, _item.id_und_med_mov, _item.vl_qtd_mov);
            
            _id_mnt_estq_item := _id_mnt_estq_item + 1;
                
            fetch _list into _item;
        
        end loop;
    
    end if;
        
    
    return true;

end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

