SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_cx_af (
)
RETURNS trigger AS
$body$
declare
    _descr_cx varchar;
    _descr_usr varchar;
begin
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        if (old.id_mov_cx is not null) then
            delete from tb_mov_bnc
            where
                id_emp = old.id_emp and
                org = 'MOV_CX.' || old.id_mov_cx;
                
            
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (new.id_cnt_bnc is not null) and (new.vl_din_sld + new.vl_ch_sld > 0) then

            select nome into _descr_usr
            from tb_usr
            where
                id_usr = new.id_usr;
            
            select descr into _descr_cx
            from tb_cx
            where
                id_emp = new.id_emp and
                id_cx = new.id_cx;
                
            
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc,
                 descr, op, vl_lanc, conc,
                 org, id_org,
                 id_usr_ult_alt, dt_hr_ult_alt)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_f, new.dt_f, 
                 'FECHAMENTO DE CAIXA: ' || _descr_cx || ' - ' || _descr_usr, 'C', new.vl_din_sld + new.vl_ch_sld, false, 
                 'MOV_CX.' || new.id_mov_cx, new.id_mov_cx,
                 new.id_usr_ult_alt, new.dt_hr_ult_alt);
        end if;
        
        return new;
    else
    
        delete from tb_mov_fnc 
        where
            id_emp = old.id_emp and
            org = 'FEC.' || old.id_mov_cx;

        return old;
    end if;
    
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

