CREATE SEQUENCE public.sq_cte
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_get_num_cte (
  _id_emp integer,
  _ser integer
)
RETURNS integer AS
$body$
declare
    _num_cte integer;
BEGIN
    select max(num) into _num_cte
    from tb_cte
    where
        id_emp = _id_emp and
        ser = _ser;
    
    if (not _num_cte is null) then
        return _num_cte + 1;
    else
        return 1;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_cte (
  id_emp INTEGER NOT NULL, 
  id_cte INTEGER NOT NULL, 
  id_rom_frete INTEGER, 
  id_rom_frete_veic INTEGER, 
  ser INTEGER, 
  num INTEGER, 
  dt_emis DATE, 
  hr_emis TIME WITHOUT TIME ZONE, 
  id_cfop INTEGER, 
  nat_op VARCHAR(60), 
  tp_cte VARCHAR(1), 
  fm_pagto VARCHAR(1), 
  ch_cte_ref VARCHAR(44), 
  id_munic_i INTEGER, 
  id_munic_f INTEGER, 
  tom VARCHAR(1), 
  id_tom INTEGER, 
  id_rem INTEGER, 
  id_dest INTEGER, 
  id_exp INTEGER, 
  id_rec INTEGER, 
  vl_prest NUMERIC(12,2), 
  vl_rec NUMERIC(12,2), 
  cd_icms VARCHAR(5), 
  vl_perc_red_bc_icms NUMERIC(12,2), 
  vl_bc_icms NUMERIC(12,2), 
  vl_aliq_icms NUMERIC(12,2), 
  vl_icms NUMERIC(12,2), 
  vl_cred_icms NUMERIC(12,2), 
  vl_merc NUMERIC(12,2), 
  prod_pred VARCHAR(60), 
  out_car VARCHAR(30), 
  rntrc VARCHAR(14), 
  ch_cte_sub VARCHAR(44), 
  ch_cte_anu VARCHAR(44), 
  obs VARCHAR(1000), 
  sit VARCHAR(5), 
  id_sit INTEGER, 
  descr_sit VARCHAR(255), 
  ch_cte VARCHAR(44), 
  rec VARCHAR(100), 
  num_prot VARCHAR(20), 
  dt_hr_aut TIMESTAMP WITHOUT TIME ZONE, 
  dt_hr_cont TIMESTAMP WITHOUT TIME ZONE, 
  just_cont VARCHAR(255), 
  dt_hr_canc TIMESTAMP WITHOUT TIME ZONE, 
  just_canc VARCHAR(255), 
  id_veic INTEGER, 
  id_colab INTEGER, 
  resp_seg VARCHAR(1), 
  nome_seg VARCHAR(60), 
  num_apol VARCHAR(20), 
  num_averb VARCHAR(20), 
  vl_merc_seg NUMERIC(12,2), 
  id_ender_tom INTEGER, 
  id_ender_rem INTEGER, 
  id_ender_dest INTEGER, 
  id_ender_exp INTEGER, 
  id_ender_rec INTEGER, 
  ie_tom VARCHAR(1), 
  CONSTRAINT pk_cte PRIMARY KEY(id_emp, id_cte)
) ;

CREATE TABLE public.tb_cte_xml (
  id_emp INTEGER NOT NULL, 
  id_cte INTEGER NOT NULL, 
  xml TEXT, 
  CONSTRAINT pk_cte_xml PRIMARY KEY(id_emp, id_cte)
) ;

CREATE TABLE public.tb_cte_doc (
  id_emp INTEGER NOT NULL, 
  id_cte INTEGER NOT NULL, 
  id_cte_doc INTEGER NOT NULL, 
  tp_doc VARCHAR(5), 
  ch_nfe VARCHAR(44), 
  ser VARCHAR(10), 
  num VARCHAR(10), 
  dt_emis DATE, 
  cfop INTEGER, 
  vl_bc_icms NUMERIC(12,2), 
  vl_icms NUMERIC(12,2), 
  vl_bc_icms_st NUMERIC(12,2), 
  vl_icms_st NUMERIC(12,2), 
  vl_peso NUMERIC(12,2), 
  vl_prod NUMERIC(12,2), 
  vl_nf NUMERIC(12,2), 
  CONSTRAINT pk_cte_doc PRIMARY KEY(id_emp, id_cte, id_cte_doc)
) ;

CREATE TABLE public.tb_cte_qtd (
  id_emp INTEGER NOT NULL, 
  id_cte INTEGER NOT NULL, 
  id_cte_qtd INTEGER NOT NULL, 
  und_med VARCHAR(2), 
  tp_med VARCHAR(20), 
  vl_qtd NUMERIC(12,4), 
  CONSTRAINT pk_cte_qtd PRIMARY KEY(id_emp, id_cte, id_cte_qtd)
) ;

ALTER TABLE public.tb_cte_xml
  ADD CONSTRAINT fk__cte_xml__cte FOREIGN KEY (id_emp, id_cte)
    REFERENCES public.tb_cte(id_emp, id_cte)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte_qtd
  ADD CONSTRAINT fk__cte_qtd__cte FOREIGN KEY (id_emp, id_cte)
    REFERENCES public.tb_cte(id_emp, id_cte)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte_doc
  ADD CONSTRAINT fk__cte_doc__cte FOREIGN KEY (id_emp, id_cte)
    REFERENCES public.tb_cte(id_emp, id_cte)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__colab FOREIGN KEY (id_colab)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__dest FOREIGN KEY (id_dest)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__exp FOREIGN KEY (id_exp)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__munic_f FOREIGN KEY (id_munic_f)
    REFERENCES public.tb_munic(id_munic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__munic_i FOREIGN KEY (id_munic_i)
    REFERENCES public.tb_munic(id_munic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__rec FOREIGN KEY (id_rec)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__rem FOREIGN KEY (id_rem)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__tom FOREIGN KEY (id_tom)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cte
  ADD CONSTRAINT fk__cte__veic FOREIGN KEY (id_veic)
    REFERENCES public.tb_veic(id_veic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

