CREATE OR REPLACE FUNCTION public.fc_calc_dif (
  _vl_ant numeric,
  _vl_atu numeric
)
RETURNS numeric [] AS
$body$
declare
    _vl_dif numeric;
    _vl_perc_dif numeric;
begin
    if (_vl_atu > _vl_ant) then
        _vl_dif := _vl_atu - _vl_ant;
        if (_vl_ant = 0) then
            _vl_perc_dif := 100.00;
        else
            _vl_perc_dif := _vl_dif * 100 / _vl_ant;
        end if;
    else
        _vl_dif := _vl_ant - _vl_atu;
        
        if (_vl_atu = 0) then
            _vl_perc_dif := 100.00;
        else
            _vl_perc_dif := _vl_dif * 100 / _vl_atu;
        end if;
        
        _vl_dif := _vl_dif * -1;
        _vl_perc_dif := _vl_perc_dif * -1;
    end if;
    
    return array[_vl_dif, _vl_perc_dif];
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_item_hist_prc (
  _id_item integer,
  _id_emp integer,
  _id_usr integer,
  _vl_cst_rep numeric,
  _vl_cst_rep_ant numeric,
  _vl_cst_med numeric,
  _vl_cst_med_ant numeric,
  _vl_vnd numeric,
  _vl_vnd_ant numeric
)
RETURNS boolean AS
$body$
declare
    _vl_cst_rep_dif numeric;
    _vl_perc_cst_rep_dif numeric;
    
    _vl_cst_med_dif numeric;
    _vl_perc_cst_med_dif numeric;
    
    _vl_vnd_dif numeric;
    _vl_perc_vnd_dif numeric;
    
    _result numeric[];
begin
    select
        case when (_vl_cst_rep_ant <= 0) then tb_item_emp.vl_cst_rep
            else _vl_cst_rep_ant
        end as vl_cst_rep_ant,
        case when (_vl_cst_med_ant <= 0) then tb_item_emp.vl_cst_med
            else _vl_cst_med_ant
        end as vl_cst_med_ant,
        case when (_vl_vnd_ant <= 0) then tb_item_emp.vl_prc_vnd
            else _vl_vnd_ant
        end as vl_vnd_ant
    into
        _vl_cst_rep_ant,
        _vl_cst_med_ant,
        _vl_vnd_ant
    from tb_item_emp
    where
        tb_item_emp.id_item = _id_item and
        tb_item_emp.id_emp = _id_emp;
        
    
    _vl_cst_rep := coalesce(_vl_cst_rep, 0);
    _vl_cst_rep_ant := coalesce(_vl_cst_rep_ant, 0);
    _vl_cst_med := coalesce(_vl_cst_med, 0);
    _vl_cst_med_ant := coalesce(_vl_cst_med_ant, 0);
    
    if (_vl_cst_rep <> _vl_cst_rep_ant) or (_vl_cst_med <> _vl_cst_med_ant) then
    
        select fc_calc_dif(_vl_cst_rep_ant, _vl_cst_rep) into _result;
        _vl_cst_rep_dif := _result[1];
        _vl_perc_cst_rep_dif := _result[2];

        select fc_calc_dif(_vl_cst_med_ant, _vl_cst_med) into _result;
        _vl_cst_med_dif := _result[1];
        _vl_perc_cst_med_dif := _result[2];
        
        
        insert into tb_item_hist_cst
            (id_item, id_emp, dt_hr, id_usr,
             vl_cst_rep_atu, vl_cst_rep_ant, vl_cst_rep_dif, vl_perc_cst_rep_dif,
             vl_cst_med_atu, vl_cst_med_ant, vl_cst_med_dif, vl_perc_cst_med_dif)
        values
            (_id_item, _id_emp, current_timestamp, _id_usr,
             _vl_cst_rep, _vl_cst_rep_ant, _vl_cst_rep_dif, _vl_perc_cst_rep_dif,
             _vl_cst_med, _vl_cst_med_ant, _vl_cst_med_dif, _vl_perc_cst_med_dif);
    end if;
    
    if (_vl_vnd <> _vl_vnd_ant) then
        select fc_calc_dif(_vl_vnd_ant, _vl_vnd) into _result;
        _vl_vnd_dif := _result[1];
        _vl_perc_vnd_dif := _result[2];
        
        insert into tb_item_hist_vnd
            (id_item, id_emp, dt_hr, id_usr,
             vl_vnd_atu, vl_vnd_ant, vl_vnd_dif, vl_perc_vnd_dif)
        values
            (_id_item, _id_emp, current_timestamp, _id_usr,
             _vl_vnd, _vl_vnd_ant, _vl_vnd_dif, _vl_perc_vnd_dif);
    end if;
    
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_item_emp_af (
)
RETURNS trigger AS
$body$
begin
    perform fc_item_hist_prc(new.id_item, new.id_emp, new.id_usr_ult_alt, 
        new.vl_cst_rep, old.vl_cst_rep,
        new.vl_cst_med, old.vl_cst_med,
        new.vl_prc_vnd, old.vl_prc_vnd);

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_item_emp_bf (
)
RETURNS trigger AS
$body$
declare
    _id_emp_matriz integer;
    _cnf_item_alt_prc_filial varchar;
    
    _filial record;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    
    if (_app_con = 'NEO_UNI') then
        return new;
    end if;

    if (tg_op = 'INSERT') 
        or (tg_op = 'UPDATE'
            and (old.vl_cst_med <> new.vl_cst_med
                 or old.vl_cst_rep <> new.vl_cst_rep
                 or old.vl_prc_vnd <> new.vl_prc_vnd)) then
        --
        -- Altera/Insere os preos nas filiais
        --
        _cnf_item_alt_prc_filial := fc_get_emp_cnf(new.id_emp, 07011);
        
        if (lower(_cnf_item_alt_prc_filial) = 'true') then
            _id_emp_matriz := fc_id_emp_matriz();
            if (new.id_emp = _id_emp_matriz) then
                
                for _filial in
                    select id_part
                    from tb_part
                    where
                        tp_part like '%[E]%' and
                        id_part <> new.id_emp
                loop
                    update tb_item_emp set
                        vl_cst_med = new.vl_cst_med,
                        vl_cst_rep = new.vl_cst_rep,
                        vl_ult_cst_med = new.vl_ult_cst_med,
                        dt_ult_cmp = new.dt_ult_cmp,
                        vl_prc_vnd = new.vl_prc_vnd,
                        vl_estq_min = new.vl_estq_min,
                        vl_estq_max = new.vl_estq_max,
                        ender_estq = new.ender_estq,
                        vl_perc_luc = new.vl_perc_luc,
                        vl_out = new.vl_out,
                        vl_perc_desp_op = new.vl_perc_desp_op,
                        vl_desp_op = new.vl_desp_op,
                        vl_luc = new.vl_luc,
                        vl_ult_prc_vnd = new.vl_ult_prc_vnd,
                        vl_ult_cst_rep = new.vl_ult_cst_rep,
                        dt_hr_ult_alt = new.dt_hr_ult_alt,
                        id_usr_ult_alt = new.id_usr_ult_alt
                    where
                        id_item = new.id_item and
                        id_emp = _filial.id_part;
                        
                    if not found then
                        insert into tb_item_emp 
                            (id_item, id_emp, vl_cst_med, vl_cst_rep, vl_ult_cst_med, dt_ult_cmp,
                             vl_prc_vnd, vl_estq_min, vl_estq_max, ender_estq, vl_perc_luc, vl_out,
                             vl_perc_desp_op, vl_desp_op, vl_luc, vl_ult_prc_vnd, vl_ult_cst_rep,
                             dt_hr_ult_alt, id_usr_ult_alt)
                        values
                            (new.id_item, _filial.id_part, new.vl_cst_med, new.vl_cst_rep, new.vl_ult_cst_med, new.dt_ult_cmp,
                             new.vl_prc_vnd, new.vl_estq_min, new.vl_estq_max, new.ender_estq, new.vl_perc_luc, new.vl_out,
                             new.vl_perc_desp_op, new.vl_desp_op, new.vl_luc, new.vl_ult_prc_vnd, new.vl_ult_cst_rep,
                             new.dt_hr_ult_alt, new.id_usr_ult_alt);
                    end if;
                end loop;
                
            end if;
        end if;
    end if;



    if (tg_op = 'UPDATE') then
        if (old.vl_cst_med <> new.vl_cst_med or
            old.vl_cst_rep <> new.vl_cst_rep or
            old.vl_prc_vnd <> new.vl_prc_vnd) then

            insert into tb_item_alt_prc
                (id_emp, id_item_alt_prc, id_item, dt_hr, 
                 vl_cst_rep_ant, vl_cst_rep_atu, 
                 vl_cst_med_ant, vl_cst_med_atu, 
                 vl_prc_vnd_ant, vl_prc_vnd_atu)
            values 
                (new.id_emp, nextval('sq_item_alt_prc'), new.id_item, current_timestamp,
                 old.vl_cst_rep, new.vl_cst_rep,
                 old.vl_cst_med, new.vl_cst_med,
                 old.vl_prc_vnd, new.vl_prc_vnd);

        end if;
    end if;
    
    return new;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
            end if;
            
            if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        
            
        if (_nf.tp_emis = '[T]') then
        
            select * into _nat_op
            from tb_nat_op
            where
                id_nat_op = _nf.id_nat_op;
            
            if (_nat_op.op like '%[NF_REC__AT_PRC_CST]%') then
                update tb_item_emp set
                    vl_cst_rep = new.vl_cst_rep,
                    vl_cst_med = new.vl_cst_med,
                    dt_ult_cmp = _nf.dt_op,
                    id_usr_ult_alt = new.id_usr_ult_alt
                where
                    id_emp = new.id_emp and
                    id_item = new.id_item;
            end if;
            
            if (new.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_VND]%') then
                update tb_item_emp set
                    vl_out = new.vl_out_prc,
                    vl_perc_desp_op = new.vl_perc_desp_op_prc,
                    vl_desp_op = new.vl_desp_op_prc,
                    vl_perc_luc = new.vl_perc_luc_prc,
                    vl_luc = new.vl_luc_prc,
                    vl_prc_vnd = new.vl_prc_vnd,
                    id_usr_ult_alt = new.id_usr_ult_alt
                where
                    id_emp = new.id_emp and
                    id_item = new.id_item;
            else
                
                
            end if;
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq and coalesce(old.mov_grd_estq, false) = false) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_item_hist_cst (
  id_item INTEGER NOT NULL, 
  id_emp INTEGER NOT NULL, 
  dt_hr TIMESTAMP WITHOUT TIME ZONE NOT NULL, 
  vl_cst_rep_atu NUMERIC(12,4), 
  vl_cst_rep_ant NUMERIC(12,4), 
  vl_cst_rep_dif NUMERIC(12,4), 
  vl_perc_cst_rep_dif NUMERIC(12,4), 
  id_usr INTEGER, 
  vl_cst_med_atu NUMERIC(12,4), 
  vl_cst_med_ant NUMERIC(12,4), 
  vl_cst_med_dif NUMERIC(12,4), 
  vl_perc_cst_med_dif NUMERIC(12,4), 
  CONSTRAINT pk_item_hist_cst PRIMARY KEY(id_item, id_emp, dt_hr)
) ;

CREATE TABLE public.tb_item_hist_vnd (
  id_item INTEGER NOT NULL, 
  id_emp INTEGER NOT NULL, 
  dt_hr TIMESTAMP WITHOUT TIME ZONE NOT NULL, 
  vl_vnd_atu NUMERIC(12,4), 
  vl_vnd_ant NUMERIC(12,4), 
  vl_vnd_dif NUMERIC(12,4), 
  vl_perc_vnd_dif NUMERIC(12,4), 
  id_usr INTEGER, 
  CONSTRAINT pk_item_hist_vnd PRIMARY KEY(id_item, id_emp, dt_hr)
) ;

ALTER TABLE public.tb_item_hist_vnd
  ADD CONSTRAINT fk__item_hist_vnd__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_hist_vnd
  ADD CONSTRAINT fk__item_hist_vnd__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_hist_cst
  ADD CONSTRAINT fk__item_hist_cst__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_hist_cst
  ADD CONSTRAINT fk__item_hist_cst__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_item_emp_af
  AFTER UPDATE 
  ON public.tb_item_emp FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_item_emp_af();

ALTER TABLE public.tb_item_hist_cst
  OWNER TO postgres;

ALTER TABLE public.tb_item_hist_vnd
  OWNER TO postgres;

