
CREATE SEQUENCE public.sq_sinc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE SEQUENCE public.sq_sinc_def
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER TABLE public.tb_emis_blt_part
  DROP CONSTRAINT fk__emis_blt_part__part RESTRICT;

ALTER TABLE public.tb_emis_blt_part
  DROP CONSTRAINT fk__emis_blt_part__emis_blt RESTRICT;

ALTER TABLE public.tb_emis_blt
  DROP CONSTRAINT fk__emis_blt__emp RESTRICT;

ALTER TABLE public.tb_emis_blt
  DROP CONSTRAINT fk__emis_blt__cnt_bnc RESTRICT;

ALTER TABLE public.tb_ch_sit
  DROP CONSTRAINT fk__ch_sit__ch RESTRICT;

ALTER TABLE public.tb_ch
  DROP CONSTRAINT fk__ch__vnd RESTRICT;

ALTER TABLE public.tb_ch
  DROP CONSTRAINT fk__ch__part RESTRICT;

ALTER TABLE public.tb_ch
  DROP CONSTRAINT fk__ch__mtv_dev_ch2 RESTRICT;

ALTER TABLE public.tb_ch
  DROP CONSTRAINT fk__ch__mtv_dev_ch1 RESTRICT;

ALTER TABLE public.tb_ch
  DROP CONSTRAINT fk__ch__emp RESTRICT;

ALTER TABLE public.tb_ch
  DROP CONSTRAINT fk__ch__cx RESTRICT;

ALTER TABLE public.tb_ch
  DROP CONSTRAINT fk__ch__cnt_bnc RESTRICT;

ALTER TABLE public.tb_ch
  DROP CONSTRAINT fk__ch__bnc RESTRICT;

ALTER TABLE public.tb_blt_ret
  DROP CONSTRAINT fk__blt_ret__blt RESTRICT;

ALTER TABLE public.tb_blt
  DROP CONSTRAINT fk__blt__part RESTRICT;

ALTER TABLE public.tb_blt
  DROP CONSTRAINT fk__blt__munic RESTRICT;

ALTER TABLE public.tb_blt
  DROP CONSTRAINT fk__blt__emp RESTRICT;

ALTER TABLE public.tb_blt
  DROP CONSTRAINT fk__blt__cnt_bnc RESTRICT;

ALTER TABLE public.tb_log_con
  ADD COLUMN dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE;
  
  
CREATE TABLE public.tb_sinc (
  id_est INTEGER, 
  op VARCHAR(1), 
  tb VARCHAR(50), 
  col_pk VARCHAR(50)[], 
  val_pk VARCHAR(50)[], 
  dt_hr TIMESTAMP WITHOUT TIME ZONE, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE
) ;

CREATE INDEX idx_sinc ON public.tb_sinc
  USING btree (id_est, tb COLLATE pg_catalog."default", op COLLATE pg_catalog."default", col_pk COLLATE pg_catalog."default", val_pk COLLATE pg_catalog."default");

CREATE TABLE public.tb_sinc_def (
  id_sinc_def INTEGER NOT NULL, 
  descr VARCHAR(100), 
  id_est_org INTEGER, 
  id_est_dst INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  CONSTRAINT pk_sinc_def PRIMARY KEY(id_sinc_def)
) ;


CREATE TABLE public.tb_sinc_def_item (
  id_sinc_def INTEGER NOT NULL, 
  id_sinc_def_item INTEGER NOT NULL, 
  tb VARCHAR(100), 
  env BOOLEAN, 
  rec BOOLEAN, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  CONSTRAINT pk_sinc_def_item PRIMARY KEY(id_sinc_def, id_sinc_def_item)
) ;

CREATE TABLE public.tb_sinc_stat (
  id_est INTEGER NOT NULL, 
  last_id BIGINT, 
  dt_hr TIMESTAMP WITHOUT TIME ZONE, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  CONSTRAINT pk_sinc_stat PRIMARY KEY(id_est)
) ;

DROP TABLE public.tb_emis_blt_part;

DROP TABLE public.tb_emis_blt;

DROP TABLE public.tb_ch_sit;

DROP TABLE public.tb_ch;

DROP TABLE public.tb_blt_ret;

DROP TABLE public.tb_blt;


DROP VIEW public.vw_tab_uni;


ALTER TABLE public.tb_sinc_def_item
  ADD CONSTRAINT fk__sinc_def_item__sinc_def FOREIGN KEY (id_sinc_def)
    REFERENCES public.tb_sinc_def(id_sinc_def)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

DROP SEQUENCE IF EXISTS public.sq_blt;

DROP SEQUENCE IF EXISTS public.sq_ch;

DROP SEQUENCE IF EXISTS public.sq_emis_blt;

