CREATE SEQUENCE public.sq_obj_os
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_obj_os RESTART WITH 7;

CREATE SEQUENCE public.sq_os
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_os RESTART WITH 2;

CREATE SEQUENCE public.sq_prio_os
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_prio_os RESTART WITH 7;

CREATE OR REPLACE FUNCTION public.fc_gera_nf_vnd (
  _id_emp integer,
  _id_vnd integer,
  _mod_nf varchar
)
RETURNS boolean AS
$body$
DECLARE
    _vnd record;
    _vnd_item_list refcursor;
    _vnd_item record;
    _id_nf integer;
    _aux varchar;
    
    _ser_nf integer;
    _num_nf integer;
    _id_mod_nf varchar;
    _id_nat_op integer;
    
    _vl_bc_icms numeric;
    _vl_icms numeric;
    _vl_bc_icms_st numeric;
    _vl_icms_st numeric;
    -- _vl_frete numeric;
    -- _vl_seg numeric;
    _vl_desc numeric;
    _vl_ipi numeric;
    _vl_pis numeric;
    _vl_cofins numeric;
    _vl_out numeric;
    _vl_item numeric;
    _vl_nf numeric;
    
    
    
    _vl_bc_icms_item numeric;
    _vl_aliq_icms_item numeric;
    _vl_icms_item numeric;
    
    _vl_bc_ipi_item numeric;
    _vl_aliq_ipi_item numeric;
    _vl_ipi_item numeric;
    
    _vl_bc_pis_item numeric;
    _vl_aliq_pis_item numeric;
    _vl_pis_item numeric;
    
    _vl_bc_cofins_item numeric;
    _vl_aliq_cofins_item numeric;
    _vl_cofins_item numeric;
    
    _vl_bc_icms_st_item numeric;
    _vl_aliq_icms_st_item numeric;
    _vl_icms_st_item numeric;
    
    _vl_tot_trib numeric;
    
    
    _id_nf_item integer;
    _id_cfop integer;
    _und_med_trib record;
    
    _id_und_med_trib varchar;
    _cd_bar_trib varchar;
    _vl_qtd_trib numeric;
    _vl_unt_trib numeric;
    
    _id_reg_trib_item varchar;
BEGIN
    select 
        tb_vnd.*,
        tb_cond_pagto.fm_pagto_nfe,
        emp.id_munic as id_munic_emp,
        munic_emp.id_uf as id_uf_emp,
        munic_dst.id_uf as id_uf_dst
    into _vnd
    from tb_vnd
    left outer join tb_cond_pagto on
        (tb_vnd.id_cond_pagto = tb_cond_pagto.id_cond_pagto)
    join tb_part emp on
        (tb_vnd.id_emp = emp.id_part)
    left outer join tb_munic munic_emp on
        (emp.id_munic = munic_emp.id_munic)
    left outer join tb_munic munic_dst on
        (tb_vnd.id_munic = munic_dst.id_munic)
    where
        tb_vnd.id_emp = _id_emp and
        tb_vnd.id_vnd = _id_vnd;
        
    
    raise notice 'teste 1';
    
    select nextval('sq_nf') into _id_nf;
    
    if (_mod_nf = 'NFE') then
        select fc_get_emp_cnf(_id_emp, 2003) into _aux;
        select fc_get_emp_cnf(_id_emp, 2001) into _id_mod_nf;
        
        if (_aux = '') then
            raise exception 'Serie para NFe nao definida';
        end if;
        
        _ser_nf = cast(_aux as integer);
        
        select fc_get_emp_cnf(_id_emp, 2002) into _aux;
        
        if (_aux = '') then
            raise exception 'Natureza de operacao para NFe nao definida';
        end if;
        
        _id_nat_op = cast(_aux as integer);
        
    elsif (_mod_nf = 'NFCE') then
        select fc_get_emp_cnf(_id_emp, 3001) into _aux;
        select fc_get_emp_cnf(_id_emp, 3000) into _id_mod_nf;
        
        if (_aux = '') then
            raise exception 'Serie para NFCe nao informada';
        end if;
        
        _ser_nf = cast(_aux as integer);
        
        select fc_get_emp_cnf(_id_emp, 3002) into _aux;
        
        if (_aux = '') then
            raise exception 'Natureza de operacao para NFCe nao definida';
        end if;
        
        _id_nat_op = cast(_aux as integer);
    end if;
    
    raise notice 'teste 2';
    
    select fc_get_num_nf(_id_emp, _ser_nf) into _num_nf;
    
    insert into tb_nf 
        (id_emp, id_nf, id_mod_nf, tp_emis, ser, num, dt_emis, tp_op, dt_op, hr_op, 
         fm_pagto, fm_emis, fin_emis, tp_imp,
         id_nat_op, id_munic_fg, 
         id_part_dst, cpf_cnpj_dst, nome_dst, insc_dst, email_dst, 
         cep_dst, logr_dst, num_dst, compl_dst, bairro_dst, id_munic_dst, fone_dst,  
         num_fat, vl_fat, vl_desc_fat, vl_liq_fat, inf_ad_cont)
    values
        (_id_emp, _id_nf, _id_mod_nf, '[P]', _ser_nf, _num_nf, _vnd.dt_vnd, '[S]', current_date, current_time,
         _vnd.fm_pagto_nfe, 'N', 'N', 'R',
         _id_nat_op, _vnd.id_munic_emp,
         _vnd.id_cli, _vnd.cpf_cnpj, _vnd.nome, _vnd.insc, _vnd.email,
         _vnd.cep, _vnd.logr, _vnd.num, _vnd.compl, _vnd.bairro, _vnd.id_munic, _vnd.fone,
         _vnd.id_vnd, _vnd.vl_tot, 0, _vnd.vl_tot, '');
         

    raise notice 'teste 3';
    
    _vl_bc_icms := 0;
    _vl_icms := 0;
    _vl_bc_icms_st := 0;
    _vl_icms_st := 0;
    _vl_ipi := 0;
    _vl_pis := 0;
    _vl_cofins := 0;
    _vl_desc := 0;
    _vl_out := 0;
    _vl_item := 0;
    _vl_nf := 0;
    _vl_tot_trib := 0;
    
    raise notice 'teste 4';
    
    open _vnd_item_list for
        select
            tb_vnd_item.*,
            tb_item.mov_estq,
            tb_item.id_ncm,
            tb_item.cd_bar,
            tb_item.prod_esp,
            tb_item.vl_peso_liq * tb_vnd_item.vl_qtd_mov as vl_peso_liq,
            tb_item.vl_peso_brt * tb_vnd_item.vl_qtd_mov as vl_peso_brt,
            tb_tp_item.item_nf,
            tb_grp_cfop_nat_op.id_cfop_d,
            tb_grp_cfop_nat_op.id_cfop_f,
            tb_grp_trib_nat_op.*,
            (tb_vnd_item.vl_tot * tb_ncm.vl_aliq_nac / 100) as  vl_tot_trib
        from tb_vnd_item
        join tb_item on
            (tb_vnd_item.id_item = tb_item.id_item)
        left outer join tb_grp_trib_nat_op on
            (tb_item.id_grp_trib = tb_grp_trib_nat_op.id_grp_trib and
             tb_grp_trib_nat_op.id_nat_op = _id_nat_op)
        left outer join tb_grp_cfop_nat_op on
            (tb_item.id_grp_cfop = tb_grp_cfop_nat_op.id_grp_cfop and
             tb_grp_cfop_nat_op.id_nat_op = _id_nat_op)
        left outer join tb_tp_item on
            (tb_item.id_tp_item = tb_tp_item.id_tp_item)
        left outer join tb_ncm on
            (tb_item.id_ncm = tb_ncm.id_ncm)
        where
            tb_vnd_item.id_emp = _id_emp and
            tb_vnd_item.id_vnd = _id_vnd;
            
    raise notice 'teste 5';

    fetch _vnd_item_list into _vnd_item;
    
    _id_nf_item := 1;
    _id_reg_trib_item := fc_get_emp_cnf(_id_emp, 2000);
    
    while found loop
        if (_vnd_item.item_nf) then
            
            raise notice 'teste 5.1';
            --
            -- Cfop
            --
            if (_mod_nf = 'NFCE') or (_vnd.id_uf_emp = _vnd.id_uf_dst) then
                _id_cfop := _vnd_item.id_cfop_d;
            else
                _id_cfop := _vnd_item.id_cfop_f;
            end if;
            
            raise notice 'teste 5.2';
            
            --
            -- Unidade de medida tributada
            --
            select
                tb_item_und_med.id_und_med,
                tb_item_und_med.vl_conv,
                tb_item_und_med.cd_bar 
            into _und_med_trib
            from tb_item_und_med
            where
                tb_item_und_med.id_item = _vnd_item.id_item and
                tb_item_und_med.op like '%[NF_EMT]%'
            limit 1;
            
            raise notice 'teste 5.3';
            
            if not found then
                raise notice 'teste 5.3.1';
                
                select 
                    tb_item.id_und_med,
                    cast(1 as numeric(12,4)) as vl_conv,
                    tb_item.cd_bar
                into _und_med_trib
                from tb_item
                where
                    tb_item.id_item = _vnd_item.id_item;
            end if;
            
            if (_und_med_trib.id_und_med is null or _und_med_trib.id_und_med = '') then
                raise exception 'Unidade de medida do item "%" nao esta defidina', _vnd_item.id_item;
            end if;
            
            _id_und_med_trib := _und_med_trib.id_und_med;
            _vl_qtd_trib := _vnd_item.vl_qtd_mov * _und_med_trib.vl_conv;
            _vl_unt_trib := _vnd_item.vl_tot / _vl_qtd_trib;
            _cd_bar_trib := _und_med_trib.cd_bar;
            
        
            --
            -- Calucla icms, icms st, ipi, pis e cofins
            --
            
            _vl_bc_icms_item   := 0;
            _vl_aliq_icms_item := 0;
            _vl_icms_item      := 0;
            if (_vnd_item.vl_aliq_icms <> 0) then
                _vl_bc_icms_item   := _vnd_item.vl_tot;
                _vl_aliq_icms_item := _vnd_item.vl_aliq_icms;
                _vl_icms_item      := cast(_vnd_item.vl_tot * _vnd_item.vl_aliq_icms / 100 as numeric(12,2));
                
                _vl_bc_icms := _vl_bc_icms + _vl_bc_ipi_item;
                _vl_icms := _vl_icms + _vl_icms_item;
            end if;
            
            raise notice 'teste 5.5';
            
            _vl_bc_ipi_item   := 0;
            _vl_aliq_ipi_item := 0;
            _vl_ipi_item      := 0;
            if (_vnd_item.vl_aliq_ipi <> 0) then
                _vl_bc_ipi_item   := _vnd_item.vl_tot;
                _vl_aliq_ipi_item := _vnd_item.vl_aliq_ipi;
                _vl_ipi_item      := cast(_vnd_item.vl_tot * _vnd_item.vl_aliq_ipi / 100 as numeric(12,2));
                
                _vl_ipi := _vl_ipi + _vl_ipi_item;
            end if;
            
            raise notice 'teste 5.6';
            
            _vl_bc_pis_item   := 0;
            _vl_aliq_pis_item := 0;
            _vl_pis_item      := 0;
            if (_vnd_item.vl_aliq_pis <> 0) then
                _vl_bc_pis_item   := _vnd_item.vl_tot;
                _vl_aliq_pis_item := _vnd_item.vl_aliq_pis;
                _vl_pis_item      := cast(_vnd_item.vl_tot * _vnd_item.vl_aliq_pis / 100 as numeric(12,2));
                
                _vl_pis := _vl_pis + _vl_pis_item;
            end if;
            
            raise notice 'teste 5.7';
            
            _vl_bc_cofins_item   := 0;
            _vl_aliq_cofins_item := 0;
            _vl_cofins_item      := 0;
            if (_vnd_item.vl_aliq_cofins <> 0) then
                _vl_bc_cofins_item   := _vnd_item.vl_tot;
                _vl_aliq_cofins_item := _vnd_item.vl_aliq_cofins;
                _vl_cofins_item      := cast(_vnd_item.vl_tot * _vnd_item.vl_aliq_cofins / 100 as numeric(12,2));
                
                _vl_cofins := _vl_cofins + _vl_cofins_item;
            end if;
            
            raise notice 'teste 5.8';
            
            _vl_bc_icms_st_item   := 0;
            _vl_aliq_icms_st_item := 0;
            _vl_icms_st_item      := 0;
            /*
             configurar para calcular o valor do icms st pelo cnae
             
            if (_vnd_item.vl_aliq_icms_st <> 0) then
                _vl_bc_icms_st_item   := _vnd_item.vl_tot;
                _vl_aliq_icms_st_item := _vnd_item.vl_aliq_icms_st;
                _vl_icms_st_item      := _vnd_item.vl_tot * _vnd_item.vl_aliq_icms_st / 100;
                
                _vl_bc_icms_st := _vl_bc_icms_st + _vl_bc_icms_st_item;
                _vl_icms_st := _vl_icms_st + _vl_icms_st_item;
            end if;
            */
            
            _vl_desc := _vl_desc + _vnd_item.vl_desc;
            _vl_out  := _vl_out + _vnd_item.vl_acr;
            
            raise notice 'teste 5.9';
            
            _vl_item := cast(_vl_item + _vnd_item.vl_tot as numeric(12,2));
            _vl_nf := cast(_vl_nf + 
                _vnd_item.vl_tot -
                _vnd_item.vl_desc +
                _vnd_item.vl_acr +
                _vl_ipi_item +
                _vl_pis_item +
                _vl_cofins_item +
                _vl_icms_st_item as numeric(12,2));
                
            _vl_tot_trib := _vl_tot_trib + _vnd_item.vl_tot_trib;
                
            raise notice 'teste 5.10';
            
            insert into tb_nf_item
                (id_emp, id_nf, id_nf_item, id_dep, id_grd_estq, id_item, descr_item,
                 id_ncm, id_cfop, 
                 id_und_med_com, cd_bar_com, vl_qtd_com, vl_unt_com,
                 id_und_med_trib, cd_bar_trib, vl_qtd_trib, vl_unt_trib,
                 -- vl_seg, vl_frete, 
                 vl_tot, vl_desc, vl_out, 
                 prod_esp, id_grp_trib, 
                 id_trib_icms, mod_bc_icms, vl_bc_icms, vl_aliq_icms, vl_icms, -- vl_perc_red_bc_icms,
                 mod_bc_icms_st, vl_bc_icms_st, vl_aliq_icms_st, vl_icms_st,
                 id_trib_ipi, vl_bc_ipi, vl_aliq_ipi, vl_ipi,
                 id_trib_pis, vl_bc_pis, vl_aliq_pis, vl_pis,
                 id_trib_cofins, vl_bc_cofins, vl_aliq_cofins, vl_cofins, 
                 vl_peso_liq, vl_peso_brt, id_reg_trib,
                 vl_tot_trib,
                 
                 mov_estq, id_und_med_mov, vl_qtd_mov, tot_nf_item)
            values
                (_id_emp, _id_nf, _id_nf_item, _vnd_item.id_dep, _vnd_item.id_grd_estq, _vnd_item.id_item, _vnd_item.descr,
                 _vnd_item.id_ncm, _id_cfop,
                 _vnd_item.id_und_med, _vnd_item.cd_bar, _vnd_item.vl_qtd, _vnd_item.vl_prc_unt,
                 _id_und_med_trib, _cd_bar_trib, _vl_qtd_trib, _vl_unt_trib,
                 _vnd_item.vl_tot, _vnd_item.vl_desc, _vnd_item.vl_acr,
                 _vnd_item.prod_esp, _vnd_item.id_grp_trib,
                 _vnd_item.id_trib_icms, _vnd_item.mod_bc_icms, _vl_bc_icms_item, _vl_aliq_icms_item, _vl_icms_item,
                 _vnd_item.mod_bc_icms_st, _vl_bc_icms_st_item, _vl_aliq_icms_st_item, _vl_icms_st_item,
                 _vnd_item.id_trib_ipi, _vl_bc_ipi_item, _vl_aliq_ipi_item, _vl_ipi_item,
                 _vnd_item.id_trib_pis, _vl_bc_pis_item, _vl_aliq_pis_item, _vl_pis_item,
                 _vnd_item.id_trib_cofins, _vl_bc_cofins_item, _vl_aliq_cofins_item, _vl_cofins_item,
                 _vnd_item.vl_peso_liq, _vnd_item.vl_peso_brt, _id_reg_trib_item,
                 _vnd_item.vl_tot_trib,
                 false, _vnd_item.id_und_med_mov, _vnd_item.vl_qtd_mov, true
            );  
            
            raise notice 'teste 7 %', _id_nf_item;
          
            _id_nf_item := _id_nf_item + 1;
        end if;
        
        raise notice 'teste 7.1 %', _id_nf_item;
    
        fetch _vnd_item_list into _vnd_item;
        
        raise notice 'teste 7.2 %', _id_nf_item;
    end loop;
    
    
    raise notice 'teste 8';
    
    close _vnd_item_list;

    update tb_nf set
        vl_bc_icms = _vl_bc_icms,
        vl_icms = _vl_icms,
        vl_bc_icms_st = _vl_bc_icms_st,
        vl_icms_st = _vl_icms_st,
        vl_ipi = _vl_ipi,
        vl_pis = _vl_pis,
        vl_cofins = _vl_cofins,
        vl_desc = _vl_desc,
        vl_out = _vl_out,
        vl_item = _vl_item,
        vl_nf = _vl_nf,
        vl_tot_trib = _vl_tot_trib
    where
        id_emp = _id_emp and
        id_nf = _id_nf;

    raise notice 'teste 9';
    
    
    
    insert into tb_nfe
        (id_emp, id_nf, sit)
    values
        (_id_emp, _id_nf, '0');
  /*       
         
  id_mod_frete, 
  id_part_trp,
  cpf_cnpj_trp,
  nome_trp,
  insc_trp,
  logr_trp,
  id_munic_trp,
  placa_trp,
  vl_peso_liq_trp,
  vl_peso_brt_trp,
  vl_qtd_vol_trp,
  entreg_trp,
  */
  
        
    
    -- fetch _vnd_item_list into _vnd_
            

    return true;    
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_obj_os (
  id_obj_os INTEGER NOT NULL, 
  descr VARCHAR(255)
) WITHOUT OIDS;

CREATE TABLE public.tb_os (
  id_emp INTEGER NOT NULL, 
  id_os INTEGER NOT NULL, 
  id_cli INTEGER, 
  dt_os DATE, 
  hr_os TIME WITHOUT TIME ZONE, 
  descr VARCHAR(255), 
  id_resp INTEGER, 
  id_obj_os INTEGER, 
  sit VARCHAR(1), 
  info TEXT, 
  dt_fin DATE, 
  hr_fin TIME WITHOUT TIME ZONE, 
  dt_prev DATE, 
  hr_prev TIME WITHOUT TIME ZONE, 
  id_prio_os INTEGER
) WITHOUT OIDS;

COMMENT ON COLUMN public.tb_os.sit
IS '[P] Pendente [E] Executando [F] FInalizada [C] Cancelada';

CREATE TABLE public.tb_os_evt (
  id_emp INTEGER NOT NULL, 
  id_os INTEGER NOT NULL, 
  id_os_evt INTEGER NOT NULL, 
  dt_evt DATE, 
  hr_evt TIME WITHOUT TIME ZONE, 
  descr VARCHAR(255), 
  id_resp INTEGER
) WITHOUT OIDS;

CREATE TABLE public.tb_prio_os (
  id_prio_os INTEGER NOT NULL, 
  descr VARCHAR(255), 
  seq INTEGER
) WITHOUT OIDS;

ALTER TABLE public.tb_prio_os
  ADD CONSTRAINT pk_prio_os 
    PRIMARY KEY (id_prio_os);

ALTER TABLE public.tb_os_evt
  ADD CONSTRAINT pk_os_evt 
    PRIMARY KEY (id_emp, id_os, id_os_evt);

ALTER TABLE public.tb_os
  ADD CONSTRAINT pk_os 
    PRIMARY KEY (id_emp, id_os);

ALTER TABLE public.tb_obj_os
  ADD CONSTRAINT pk_obj_os 
    PRIMARY KEY (id_obj_os);

ALTER TABLE public.tb_os_evt
  ADD CONSTRAINT fk__os_evt__resp FOREIGN KEY (id_resp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_os_evt
  ADD CONSTRAINT fk__os_evt__os FOREIGN KEY (id_emp, id_os)
    REFERENCES public.tb_os(id_emp, id_os)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_os
  ADD CONSTRAINT fk__os__resp FOREIGN KEY (id_resp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_os
  ADD CONSTRAINT fk__os__obj_os FOREIGN KEY (id_obj_os)
    REFERENCES public.tb_obj_os(id_obj_os)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_os
  ADD CONSTRAINT fk__os__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_os
  ADD CONSTRAINT fk__os__cli FOREIGN KEY (id_cli)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

