-- CNF_NF_EMT_CERT                   = 02005
-- CNF_NF_EMT_AMB_HOM                = 02004

-- CNF_CTE__CERT                     = 23005
-- CNF_CTE__AMB_HOM                  = 23006

-- CNF_DFE_NUM_SER_CERT                       = 33004;
-- CNF_DFE_AMB_HOM                            = 33005;

--
-- Populate new configurations in tb_emp_cnf
--

insert into tb_emp_cnf
    (id_emp, id_cnf, val)
select 
    tb_part.id_part,
    33004,
    case 
        when coalesce(tb_emp_cnf__nf_emt_cert.val, '') <> '' then tb_emp_cnf__nf_emt_cert.val
        else tb_emp_cnf__cte_cert.val
    end
from tb_part
left outer join tb_emp_cnf as tb_emp_cnf__nf_emt_cert on
    tb_emp_cnf__nf_emt_cert.id_emp = tb_part.id_part and
    tb_emp_cnf__nf_emt_cert.id_cnf = 02005
left outer join tb_emp_cnf as tb_emp_cnf__cte_cert on
    tb_emp_cnf__cte_cert.id_emp = tb_part.id_part and
    tb_emp_cnf__cte_cert.id_cnf = 23005
where
    tb_part.tp_part like '%[E]%';
    
insert into tb_emp_cnf
    (id_emp, id_cnf, val)
select 
    tb_part.id_part,
    33005,
    case 
        when coalesce(tb_emp_cnf__nf_emt_cert.val, '') <> '' then tb_emp_cnf__nf_emt_amb_hom.val
        else tb_emp_cnf__cte_amb_hom.val
    end
from tb_part
left outer join tb_emp_cnf as tb_emp_cnf__nf_emt_cert on
    tb_emp_cnf__nf_emt_cert.id_emp = tb_part.id_part and
    tb_emp_cnf__nf_emt_cert.id_cnf = 02005
left outer join tb_emp_cnf as tb_emp_cnf__cte_cert on
    tb_emp_cnf__cte_cert.id_emp = tb_part.id_part and
    tb_emp_cnf__cte_cert.id_cnf = 23005
left outer join tb_emp_cnf as tb_emp_cnf__nf_emt_amb_hom on
    tb_emp_cnf__nf_emt_amb_hom.id_emp = tb_part.id_part and
    tb_emp_cnf__nf_emt_amb_hom.id_cnf = 02004
left outer join tb_emp_cnf as tb_emp_cnf__cte_amb_hom on
    tb_emp_cnf__cte_amb_hom.id_emp = tb_part.id_part and
    tb_emp_cnf__cte_amb_hom.id_cnf = 23006
where
    tb_part.tp_part like '%[E]%';