SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_item_bf (
)
RETURNS trigger AS
$body$
declare 
    _item_emp record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        if (tg_op = 'UPDATE') then
            -- se estava para movimentar o estoque, volta o estoque
            if 
                (old.mov_estq and (new.mov_estq <> old.mov_estq)) or
                (old.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) or
                (old.mov_estq and new.id_item <> old.id_item) or
                (old.mov_estq and new.id_dep <> old.id_dep) or
                (old.mov_estq and new.id_grd_estq <> old.id_grd_estq)
            then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
            end if;
            
            -- se o novo esta para movimentar o estoque, insere o estoque
            if 
            	(new.mov_estq and (new.mov_estq <> old.mov_estq)) or
                (new.mov_estq and new.vl_qtd_mov <> old.vl_qtd_mov) or
                (new.mov_estq and new.id_item <> old.id_item) or
                (new.mov_estq and new.id_dep <> old.id_dep) or
                (new.mov_estq and new.id_grd_estq <> old.id_grd_estq)
            then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
            end if;
        end if;
        
        if (coalesce(new.mov_estq, false) and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
        end if;
        
        select * into _item_emp
        from tb_item_emp
        where
            id_item = new.id_item and
            id_emp = new.id_emp;
                
        new.vl_cst_rep = _item_emp.vl_cst_rep;
        new.vl_cst_med = _item_emp.vl_cst_med;
        
        return new;
    
    elsif (tg_op = 'DELETE') then
        
        if (coalesce(old.mov_estq, false)) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;
