SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
    
    _id_plano_ct varchar;
    
    _ct record;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
            
            delete from tb_mov_bnc
            where 
                id_emp = old.id_emp and
                org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select * into _vnd
            from tb_vnd
            where
                id_emp = new.id_emp and
                id_vnd = new.id_vnd;
                
                
            select tb_nat_op.* into _nat_op
            from tb_vnd
            join tb_nat_op on
                (tb_vnd.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_vnd.id_emp = new.id_emp and
                tb_vnd.id_vnd = new.id_vnd;
                    
            _gera_fin := _nat_op.op like '%[VND__GER_FIN]%';

            if (_op_fnc.gera_ct and _gera_fin) then
                    
                _nr_doc := new.nr_doc;
                    
                if (_op_fnc.tp_op_fnc = 'DUP' and coalesce(_nr_doc, '') = '') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
                
                _id_plano_ct := fc_get_emp_cnf(new.id_emp, 16200);
                
                if (_id_plano_ct = '') then
                    _id_plano_ct := null;
                end if;
                
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_veic)
                values
                    (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, new.id_op_fnc, 0, new.vl_parc, 
                     _id_plano_ct,
                     new.vl_sub_tot, coalesce(new.vl_perc_desc, 0), coalesce(new.vl_desc, 0), coalesce(new.vl_perc_acr, 0), coalesce(new.vl_acr, 0), 
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     _vnd.id_veic);
                
                
                if (_op_fnc.tp_op_fnc = 'BLT') then
                    select * into _ct
                    from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_ct = _id_ct;
                        
                    new.nr_doc := _ct.nr_doc;
                    
--                    raise notice '12345 Boleto %', new.nr_doc;
                    
                elsif (_op_fnc.tp_op_fnc = 'DUP') then
                    new.nr_doc := cast(_id_ct as varchar);
                    
--                    raise notice '12345 Duplicata %', new.nr_doc;
                    
                end if;
            end if;
                
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd,
                     _vnd.id_cli, 'PEND',
                     _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt, _vnd.id_usr_ult_alt, _vnd.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     new.id_op_fnc);
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
begin
    _app_con := fc_app_con();

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
        
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select 
                tb_nf.tp_emis as tp_emis_nf,
                tb_nat_op.* 
            into 
                _nat_op
            from tb_nf
            join tb_nat_op on
                (tb_nf.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_nf.id_emp = new.id_emp and
                tb_nf.id_nf = new.id_nf;
                
            _gera_fin :=
                (_nat_op.tp_emis_nf = '[P]' and _nat_op.op like '%[NF_EMT__GER_FIN]%') or
                (_nat_op.tp_emis_nf = '[T]' and _nat_op.op like '%[NF_REC__GER_FIN]%');
                
                
            if (_op_fnc.gera_ct and _gera_fin) then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     id_cnt_bnc, org,
                     obs, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 'NF.' || new.id_nf || '.' || new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr, new.id_op_fnc, 0, new.vl_parc, 
                     new.id_plano_ct,
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt, _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_plano_ct,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, _nf.id_nf,
                     _nf.id_part_emt, 'PEND',
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt, _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     new.id_plano_ct,
                     new.id_op_fnc);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _ct record;
    _op varchar;
    _descr varchar;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') then
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'CT_PAGTO.' || old.id_ct || '.' || old.id_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        select * into _ct
        from tb_ct
        where
            id_emp = new.id_emp and
            id_ct = new.id_ct;
        
        if (_ct.tp_ct = 'R') then
            _op := 'D';
        else
            _op := 'C';
        end if;
        
        
        _descr := '';
        
        if (_ct.org like 'MOV_COLAB.ADTO%') then
            _descr := 'ADTO ' || _ct.id_ct;
        end if;
        
        if (new.descr is not null) then
            _descr := _descr || ' - ' || new.descr;
        end if;
        
        
        
        insert into tb_mov_bnc
            (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
             org, id_org,
             id_part, sit_conc,
             id_usr, id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
             id_ct_ctb_d, id_ct_ctb_c,
             id_plano_ct, id_cnt_cst,
             id_op_fnc)
        values
            (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_pagto, new.dt_pagto, new.nr_doc, _op, new.vl_pagto, _descr, false,
             'CT_PAGTO.' || new.id_ct || '.' || new.id_ct_pagto, new.id_ct,
             _ct.id_part, 'PEND',
             new.id_usr_ult_alt, new.id_usr_ult_alt, new.dt_hr_ult_alt, new.id_usr_ult_alt, new.dt_hr_ult_alt,
             _ct.id_ct_ctb_d, _ct.id_ct_ctb_c,
             _ct.id_plano_ct, _ct.id_cnt_cst,
             new.id_op_fnc);
    end if;
                     
                     
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    else
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_contr_frete_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _contr_frete record;
    _op_fnc record;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'CONTR_FRETE.PAGTO.' || old.id_contr_frete || '.' || old.id_contr_frete_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'CONTR_FRETE.PAGTO.' || old.id_contr_frete || '.' || old.id_contr_frete_pagto;
        
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        select * into _contr_frete
        from tb_contr_frete
        where
            id_emp = new.id_emp and
            id_contr_frete = new.id_contr_frete;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 id_cnt_bnc, org, id_op_fnc, vl_quit, vl_rest,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, _contr_frete.id_tom, new.nr_doc,
                 _contr_frete.dt_emis, new.dt_venc, new.vl_pagto, 'P', 
                 new.id_cnt_bnc, 'CONTR_FRETE.PAGTO.' || new.id_contr_frete || '.' || new.id_contr_frete_pagto, new.id_op_fnc, 0, new.vl_pagto,
                 _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt, _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _contr_frete.dt_emis, new.dt_venc, new.nr_doc, 'C', new.vl_pagto, new.obs, false,
                 'CONTR_FRETE.PAGTO.' || new.id_contr_frete || '.' || new.id_contr_frete_pagto, _contr_frete.id_contr_frete,
                 _contr_frete.id_tom, 'PEND',
                 _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt, _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;

end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;
    _op varchar;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org, id_op_fnc, vl_quit, vl_rest,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_op_fnc, 0, new.vl_pagto,
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        _descr_part := '';
        
        if (_bx_ct.op = 'A') then
            _descr := 'ACERTO ' || _bx_ct.num_doc;
            
            if (new.obs is not null) then
                _descr_part := ' - ' || new.obs;
            end if;
          
        elsif (_bx_ct.org like 'BX_MOV_FUNC.%' and coalesce(new.obs, '') <> '') then
            
            _descr := new.obs;
            
        else
            select nome into _descr_part
            from tb_part
            where
                id_part = _bx_ct.id_part;
                
            if (_descr_part is null) then
                _descr_part := '';
            else
                _descr_part := ' ' || _descr_part;
            end if;
            
            if (new.obs is not null) then
                _descr_part := _descr_part || ' ' || new.obs;
            end if;
            
            _descr := ifthen(_bx_ct.tp_bx = 'R', 'REC ', 'PAG ');
        end if;
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
        
            if (_bx_ct.op = 'A') then
                _op := new.op;
            else
                _op := ifthen(_bx_ct.tp_bx = 'R', 'C', 'D');
            end if;
        
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, _op, new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND',
                 _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt, _bx_ct.id_usr_ult_alt, _bx_ct.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

