CREATE SEQUENCE public.sq_mdfe
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
            if 
                (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) or
                (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.id_item <> old.id_item) or
                (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.id_dep <> old.id_dep) or
                (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.id_grd_estq <> old.id_grd_estq)
            then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
                
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
            end if;
            
--            if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) then
--                
--            end if;
        end if;
        
        if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq and coalesce(old.mov_grd_estq, false) = false) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_get_num_mdfe (
  _id_emp integer,
  _ser integer
)
RETURNS integer AS
$body$
declare
    _num integer;
BEGIN
    select max(num) into _num
    from tb_mdfe
    where
        id_emp = _id_emp and
        ser = _ser;
    
    if (not _num is null) then
        return _num + 1;
    else
        return 1;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_mdfe (
  id_emp INTEGER NOT NULL, 
  id_mdfe INTEGER NOT NULL, 
  ser INTEGER, 
  num INTEGER, 
  dt_emis DATE, 
  hr_emis TIME WITHOUT TIME ZONE, 
  dt_viag INTEGER, 
  hr_viag TIME WITHOUT TIME ZONE, 
  tp_emis VARCHAR(1), 
  id_uf_i VARCHAR(2), 
  id_uf_f VARCHAR(2), 
  rntrc VARCHAR(14), 
  ciot VARCHAR(20), 
  cpf_cnpj_ciot VARCHAR(20), 
  vl_carga NUMERIC(12,2), 
  und_qtd_carga VARCHAR(2), 
  vl_qtd_carga NUMERIC(12,2), 
  id_veic INTEGER, 
  id_mot INTEGER, 
  id_contr INTEGER, 
  resp_seg VARCHAR(1), 
  nome_seg VARCHAR(30), 
  cnpj_seg VARCHAR(20), 
  num_apol VARCHAR(20), 
  num_aver VARCHAR(40), 
  obs VARCHAR(1000), 
  sit VARCHAR(5), 
  id_sit INTEGER, 
  descr_sit VARCHAR(255), 
  ch_mdfe VARCHAR(44), 
  rec VARCHAR(100), 
  num_prot VARCHAR(20), 
  dt_hr_aut TIMESTAMP WITHOUT TIME ZONE, 
  dt_hr_cont TIMESTAMP WITHOUT TIME ZONE, 
  just_cont VARCHAR(255), 
  dt_hr_canc TIMESTAMP WITHOUT TIME ZONE, 
  just_canc VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_mdfe PRIMARY KEY(id_emp, id_mdfe)
) ;

CREATE TABLE public.tb_mdfe_desc (
  id_emp INTEGER NOT NULL, 
  id_mdfe INTEGER NOT NULL, 
  id_mdfe_desc INTEGER NOT NULL, 
  id_munic INTEGER NOT NULL, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_mdfe_desc PRIMARY KEY(id_emp, id_mdfe, id_mdfe_desc)
) ;

CREATE TABLE public.tb_mdfe_perc (
  id_emp INTEGER NOT NULL, 
  id_mdfe INTEGER NOT NULL, 
  id_uf VARCHAR(2) NOT NULL, 
  id_mdfe_perc INTEGER NOT NULL, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_mdfe_perc PRIMARY KEY(id_emp, id_mdfe, id_mdfe_perc)
) ;

CREATE TABLE public.tb_mdfe_xml (
  id_emp INTEGER NOT NULL, 
  id_mdfe INTEGER NOT NULL, 
  xml TEXT, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_mdfe_xml PRIMARY KEY(id_emp, id_mdfe)
) ;

CREATE TABLE public.tb_mdfe_car (
  id_emp INTEGER NOT NULL, 
  id_mdfe INTEGER NOT NULL, 
  id_munic INTEGER NOT NULL, 
  id_mdfe_car INTEGER NOT NULL, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_mdfe_car PRIMARY KEY(id_emp, id_mdfe, id_mdfe_car)
) ;

CREATE TABLE public.tb_mdfe_desc_doc (
  id_emp INTEGER NOT NULL, 
  id_mdfe INTEGER NOT NULL, 
  id_mdfe_desc INTEGER NOT NULL, 
  id_mdfe_desc_doc INTERVAL(0) NOT NULL, 
  tp_doc VARCHAR(5), 
  ch VARCHAR(44), 
  seg_cd_bar VARCHAR(36), 
  reentr BOOLEAN, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_mdfe_desc_doc PRIMARY KEY(id_emp, id_mdfe, id_mdfe_desc, id_mdfe_desc_doc)
) ;

ALTER TABLE public.tb_mdfe_xml
  ADD CONSTRAINT fk__mdfe_xml__mdfe FOREIGN KEY (id_emp, id_mdfe)
    REFERENCES public.tb_mdfe(id_emp, id_mdfe)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe_perc
  ADD CONSTRAINT fk__mdfe_perc__mdfe FOREIGN KEY (id_emp, id_mdfe)
    REFERENCES public.tb_mdfe(id_emp, id_mdfe)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe_perc
  ADD CONSTRAINT fk__mdfe_perc__uf FOREIGN KEY (id_uf)
    REFERENCES public.tb_uf(id_uf)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe_desc_doc
  ADD CONSTRAINT fk__mdfe_desc_doc__mdfe_desc FOREIGN KEY (id_emp, id_mdfe, id_mdfe_desc)
    REFERENCES public.tb_mdfe_desc(id_emp, id_mdfe, id_mdfe_desc)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe_desc
  ADD CONSTRAINT fk__mdfe_desc__mdfe FOREIGN KEY (id_emp, id_mdfe)
    REFERENCES public.tb_mdfe(id_emp, id_mdfe)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe_desc
  ADD CONSTRAINT fk__mdfe_desc__munic FOREIGN KEY (id_munic)
    REFERENCES public.tb_munic(id_munic)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe_car
  ADD CONSTRAINT fk__mdfe_car__mdfe FOREIGN KEY (id_emp, id_mdfe)
    REFERENCES public.tb_mdfe(id_emp, id_mdfe)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe_car
  ADD CONSTRAINT fk__mdfe_car__munic FOREIGN KEY (id_munic)
    REFERENCES public.tb_munic(id_munic)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe
  ADD CONSTRAINT fk__mdfe__id_contr FOREIGN KEY (id_contr)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe
  ADD CONSTRAINT fk__mdfe__id_mot FOREIGN KEY (id_mot)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe
  ADD CONSTRAINT fk__mdfe__id_veic FOREIGN KEY (id_veic)
    REFERENCES public.tb_veic(id_veic)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe
  ADD CONSTRAINT fk__mdfe__uf_f FOREIGN KEY (id_uf_f)
    REFERENCES public.tb_uf(id_uf)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mdfe
  ADD CONSTRAINT fk__mdfe__uf_i FOREIGN KEY (id_uf_i)
    REFERENCES public.tb_uf(id_uf)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

