SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _nf record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;
        
        if (_nf.tp_op = '[E]') then
            _op := 'E';
            _op_inv := 'S';
        else
            _op := 'S';
            _op_inv := 'E';
        end if;
        
        if (tg_op = 'UPDATE') then
            if (old.mov_estq and coalesce(old.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
            end if;
            
            if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
            end if;
        end if;
        
        if (new.mov_estq and coalesce(new.mov_grd_estq, false) = false and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, _op, new.vl_qtd_mov);
        end if;
        
        return new;    
    
    elsif (tg_op = 'DELETE') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
            
        if (_nf.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
    
        if (found and old.mov_estq and coalesce(old.mov_grd_estq, false) = false) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, _op_inv, old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_nf_at_prc (
  _id_emp integer,
  _id_nf integer
)
RETURNS boolean AS
$body$
declare
    _nf record;
    _nf_item_list refcursor;
    _nf_item record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
begin
    select * into _nf
    from tb_nf
    where
        id_emp = _id_emp and
        id_nf = _id_nf;
        
        
    if (_nf.tp_emis = '[T]') then
        
        select * into _nat_op
        from tb_nat_op
        where
            id_nat_op = _nf.id_nat_op;
            
            
        open _nf_item_list for 
            select *
            from tb_nf_item
            where
                id_emp = _id_emp and
                id_nf = _id_nf;
        
        fetch _nf_item_list into _nf_item;
        
        while found loop
        
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_CST]%') then
                update tb_item_emp set
                    vl_cst_rep = _nf_item.vl_cst_rep,
                    vl_cst_med = _nf_item.vl_cst_med,
                    dt_ult_cmp = _nf.dt_op,
                    id_usr_ult_alt = _nf_item.id_usr_ult_alt
                where
                    id_emp = _nf_item.id_emp and
                    id_item = _nf_item.id_item;
            end if;
                
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_VND]%') then
                update tb_item_emp set
                    vl_out = _nf_item.vl_out_prc,
                    vl_perc_desp_op = _nf_item.vl_perc_desp_op_prc,
                    vl_desp_op = _nf_item.vl_desp_op_prc,
                    vl_perc_luc = _nf_item.vl_perc_luc_prc,
                    vl_luc = _nf_item.vl_luc_prc,
                    vl_prc_vnd = _nf_item.vl_prc_vnd,
                    id_usr_ult_alt = _nf_item.id_usr_ult_alt
                where
                    id_emp = _nf_item.id_emp and
                    id_item = _nf_item.id_item;
            end if;
        
        
            fetch _nf_item_list into _nf_item;
            
        end loop;
            
    end if;
    
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_nfe_inut
  ADD COLUMN dt_inut DATE;

