CREATE SEQUENCE public.sq_nfe_inut
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE OR REPLACE FUNCTION public.fc_gera_nf_vnd (
  _id_emp integer,
  _id_vnd integer,
  _mod_nf varchar
)
RETURNS boolean AS
$body$
DECLARE
    _vnd record;
    _vnd_item_list refcursor;
    _vnd_item record;
    _vnd_parc_list refcursor;
    _vnd_parc record;
    
    _inf_ad_cont varchar;
    
    _id_nf_parc integer;
    
    _id_nf integer;
    _aux varchar;
    
    _ser_nf varchar;
    _num_nf integer;
    _id_mod_nf varchar;
    _id_nat_op integer;
    _nat_op record;
    
    _vl_bc_icms numeric;
    _vl_icms numeric;
    _vl_bc_icms_st numeric;
    _vl_icms_st numeric;
    -- _vl_frete numeric;
    -- _vl_seg numeric;
    _vl_desc numeric;
    _vl_ipi numeric;
    _vl_pis numeric;
    _vl_cofins numeric;
    _vl_out numeric;
    _vl_item numeric;
    _vl_nf numeric;
    
    
    
    _vl_bc_icms_item numeric;
    _vl_aliq_icms_item numeric;
    _vl_icms_item numeric;
    
    _id_trib_ipi_item varchar;
    _vl_bc_ipi_item numeric;
    _vl_aliq_ipi_item numeric;
    _vl_ipi_item numeric;
    
    _vl_bc_pis_item numeric;
    _vl_aliq_pis_item numeric;
    _vl_pis_item numeric;
    
    _vl_bc_cofins_item numeric;
    _vl_aliq_cofins_item numeric;
    _vl_cofins_item numeric;
    
    _vl_bc_icms_st_item numeric;
    _vl_aliq_icms_st_item numeric;
    _vl_icms_st_item numeric;
    
    _vl_tot_trib numeric;
    
    
    _id_nf_item integer;
    _id_cfop integer;
    _und_med_trib record;
    
    _id_und_med_trib varchar;
    _cd_bar_trib varchar;
    _vl_qtd_trib numeric;
    _vl_unt_trib numeric;
    
    _id_reg_trib_item varchar;
    
    _vl_rest_desc_vnd numeric;
    
    _vl_sub_tot_item numeric;
    _vl_desc_vnd numeric;
    _vl_tot_trib_item numeric;
    
    
    _vl_parc_nf numeric;
BEGIN
    select 
        tb_vnd.*,
        tb_cond_pagto.fm_pagto_nfe,
        emp.id_munic as id_munic_emp,
        munic_emp.id_uf as id_uf_emp,
        munic_dst.id_uf as id_uf_dst,
        cli.apel as apel_cli
    into _vnd
    from tb_vnd
    left outer join tb_cond_pagto on
        (tb_vnd.id_cond_pagto = tb_cond_pagto.id_cond_pagto)
    join tb_part emp on
        (tb_vnd.id_emp = emp.id_part)
    left outer join tb_munic munic_emp on
        (emp.id_munic = munic_emp.id_munic)
    left outer join tb_munic munic_dst on
        (tb_vnd.id_munic = munic_dst.id_munic)
    join tb_part cli on
        (tb_vnd.id_cli = cli.id_part)        
    where
        tb_vnd.id_emp = _id_emp and
        tb_vnd.id_vnd = _id_vnd;
        
    
    select nextval('sq_nf') into _id_nf;
    
    _vl_rest_desc_vnd := _vnd.vl_desc_nf;
    
    _inf_ad_cont := '';
    
    if (_mod_nf = 'NFE') then
        select fc_get_emp_cnf(_id_emp, 2003) into _aux;
        select fc_get_emp_cnf(_id_emp, 2001) into _id_mod_nf;
        
        if (_aux = '') then
            raise exception 'Serie para NFe nao definida';
        end if;
        
        _ser_nf := _aux;
        
        select fc_get_emp_cnf(_id_emp, 2002) into _aux;
        
        if (_aux = '') then
            raise exception 'Natureza de operacao para NFe nao definida';
        end if;
        
        _id_nat_op := cast(_aux as integer);
        
    elsif (_mod_nf = 'NF') then
        
        _id_mod_nf := '01';
    
        _ser_nf := '1';
        
        _id_nat_op := _vnd.id_nat_op;
    
        
    elsif (_mod_nf = 'NFCE') then
        select fc_get_emp_cnf(_id_emp, 3001) into _aux;
        select fc_get_emp_cnf(_id_emp, 3000) into _id_mod_nf;
        
        if (_aux = '') then
            raise exception 'Serie para NFCe nao informada';
        end if;
        
        _ser_nf := _aux;
        
        select fc_get_emp_cnf(_id_emp, 3002) into _aux;
        
        if (_aux = '') then
            raise exception 'Natureza de operacao para NFCe nao definida';
        end if;
        
        _id_nat_op := cast(_aux as integer);
        
        
        _inf_ad_cont := fc_get_emp_cnf(_id_emp, 3005);
    end if;
    
    if (_vnd.apel_cli is not null) and (_vnd.apel_cli <> '') then 
        _inf_ad_cont := _inf_ad_cont || ' ' || _vnd.apel_cli;
    end if;
    
    select * into _nat_op
    from tb_nat_op
    where
        id_nat_op = _id_nat_op;
    
    if (_mod_nf = 'NF') then
        _num_nf := cast(_vnd.cd_ref as integer);
    else
        select fc_get_num_nf(_id_emp, _id_mod_nf, _ser_nf) into _num_nf;
    end if;
    
    insert into tb_nf 
        (id_emp, id_nf, id_mod_nf, tp_emis, ser, num, dt_emis, tp_op, dt_op, hr_op, 
         fm_pagto, fm_emis, fin_emis, tp_imp,
         id_nat_op, id_munic_fg, 
         id_part_dst, cpf_cnpj_dst, nome_dst, insc_dst, email_dst, 
         cep_dst, logr_dst, num_dst, compl_dst, bairro_dst, id_munic_dst, fone_dst,  
         inf_ad_cont, id_vnd)
    values
        (_id_emp, _id_nf, _id_mod_nf, '[P]', _ser_nf, _num_nf, _vnd.dt_vnd, '[S]', current_date, current_time,
         _vnd.fm_pagto_nfe, 'N', 'N', 'R',
         _id_nat_op, _vnd.id_munic_emp,
         _vnd.id_cli, _vnd.cpf_cnpj, _vnd.nome, _vnd.insc, _vnd.email,
         _vnd.cep, _vnd.logr, _vnd.num, _vnd.compl, _vnd.bairro, _vnd.id_munic, _vnd.fone,
         _inf_ad_cont, _vnd.id_vnd);
    
    if (_mod_nf = 'NFCE' and _vnd.info_cli_nfce = false) then
        update tb_nf set
            cpf_cnpj_dst = '',
            nome_dst = '',
            insc_dst = '',
            email_dst = '',
            cep_dst = '',
            logr_dst = '',
            num_dst = '',
            compl_dst = '',
            bairro_dst = '',
            id_munic_dst = null,
            fone_dst = ''
        where
            id_emp = _id_emp and
            id_nf = _id_nf;
    end if;

    if (_mod_nf = 'NFE') then
        update tb_nf set
            num_fat = _vnd.id_vnd,
            vl_fat = _vnd.vl_tot, 
            vl_desc_fat = 0, 
            vl_liq_fat = _vnd.vl_tot
        where
            id_emp = _id_emp and
            id_nf = _id_nf;
    end if;

   
    _vl_bc_icms := 0;
    _vl_icms := 0;
    _vl_bc_icms_st := 0;
    _vl_icms_st := 0;
    _vl_ipi := 0;
    _vl_pis := 0;
    _vl_cofins := 0;
    _vl_desc := 0;
    _vl_out := 0;
    _vl_item := 0;
    _vl_nf := 0;
    _vl_tot_trib := 0;
    

    
    open _vnd_item_list for
        select
            tb_vnd_item.*,
            tb_item.mov_estq,
            tb_item.id_ncm,
            tb_item.cd_bar,
            tb_item.prod_esp,
            tb_item.vl_peso_liq * tb_vnd_item.vl_qtd_mov as vl_peso_liq,
            tb_item.vl_peso_brt * tb_vnd_item.vl_qtd_mov as vl_peso_brt,
            tb_tp_item.item_nf,
            tb_grp_cfop_nat_op.id_cfop_d,
            tb_grp_cfop_nat_op.id_cfop_f,
            tb_grp_trib_nat_op.*,
            tb_ncm.vl_aliq_nac
        from tb_vnd_item
        join tb_item on
            (tb_vnd_item.id_item = tb_item.id_item)
        left outer join tb_grp_trib_nat_op on
            (tb_item.id_grp_trib = tb_grp_trib_nat_op.id_grp_trib and
             tb_grp_trib_nat_op.id_nat_op = _id_nat_op)
        left outer join tb_grp_cfop_nat_op on
            (tb_item.id_grp_cfop = tb_grp_cfop_nat_op.id_grp_cfop and
             tb_grp_cfop_nat_op.id_nat_op = _id_nat_op)
        left outer join tb_tp_item on
            (tb_item.id_tp_item = tb_tp_item.id_tp_item)
        left outer join tb_ncm on
            (tb_item.id_ncm = tb_ncm.id_ncm)
        where
            tb_vnd_item.id_emp = _id_emp and
            tb_vnd_item.id_vnd = _id_vnd and
            tb_tp_item.item_nf;
            


    fetch _vnd_item_list into _vnd_item;
    
    _id_nf_item := 1;
    _id_reg_trib_item := fc_get_emp_cnf(_id_emp, 2000);
    
    while found loop
        if (_vnd_item.item_nf) then
            
            _vl_desc_vnd := 0;
        
            if (_vl_rest_desc_vnd > 0) then
                _vl_desc_vnd := cast(_vnd_item.vl_sub_tot * _vnd.vl_desc_nf / _vnd.vl_sub_tot_nf as numeric(12,2));
                
                _vl_rest_desc_vnd := _vl_rest_desc_vnd - _vl_desc_vnd;
                
                _vl_sub_tot_item := _vnd_item.vl_sub_tot - _vl_desc_vnd;
            else
                _vl_sub_tot_item := _vnd_item.vl_sub_tot;
            end if;
            
            _vl_tot_trib_item := 0;
            
            if (_vl_sub_tot_item <> 0 and _vnd_item.vl_aliq_nac <> 0) then
                _vl_tot_trib_item :=  _vl_sub_tot_item * _vnd_item.vl_aliq_nac / 100;
            end if;                

            --
            -- Cfop
            --
            if (_mod_nf = 'NFCE') or (_vnd.id_uf_emp = _vnd.id_uf_dst) then
                _id_cfop := _vnd_item.id_cfop_d;
            else
                _id_cfop := _vnd_item.id_cfop_f;
            end if;
            

            
            --
            -- Unidade de medida tributada
            --
            select
                tb_item_und_med.id_und_med,
                tb_item_und_med.vl_conv,
                tb_item_und_med.cd_bar 
            into _und_med_trib
            from tb_item_und_med
            where
                tb_item_und_med.id_item = _vnd_item.id_item and
                tb_item_und_med.op like '%[NF_EMT]%'
            limit 1;
            
            raise notice 'teste 5.3';
            
            if not found then
                raise notice 'teste 5.3.1';
                
                select 
                    tb_item.id_und_med,
                    cast(1 as numeric(12,4)) as vl_conv,
                    tb_item.cd_bar
                into _und_med_trib
                from tb_item
                where
                    tb_item.id_item = _vnd_item.id_item;
            end if;
            
            if (_und_med_trib.id_und_med is null or _und_med_trib.id_und_med = '') then
                raise exception 'Unidade de medida do item "%" nao esta defidina', _vnd_item.id_item;
            end if;
            
            _id_und_med_trib := _und_med_trib.id_und_med;
            _vl_qtd_trib := _vnd_item.vl_qtd_mov * _und_med_trib.vl_conv;
            
            _cd_bar_trib := _und_med_trib.cd_bar;
            
        
            --
            -- Calucla icms, icms st, ipi, pis e cofins
            --
            
            _vl_bc_icms_item   := 0;
            _vl_aliq_icms_item := 0;
            _vl_icms_item      := 0;
            if (_vnd_item.vl_aliq_icms <> 0) then
                _vl_bc_icms_item   := _vl_sub_tot_item;
                _vl_aliq_icms_item := _vnd_item.vl_aliq_icms;
                _vl_icms_item      := cast(_vl_sub_tot_item * _vnd_item.vl_aliq_icms / 100 as numeric(12,2));
                
                _vl_bc_icms := _vl_bc_icms + _vl_bc_icms_item;
                _vl_icms := _vl_icms + _vl_icms_item;
            end if;
            

            _id_trib_ipi_item := null;
            _vl_bc_ipi_item   := 0;
            _vl_aliq_ipi_item := 0;
            _vl_ipi_item      := 0;
            if (_mod_nf = 'NFE') then
                _id_trib_ipi_item := _vnd_item.id_trib_ipi;
                if (_vnd_item.vl_aliq_ipi <> 0) then
                    _vl_bc_ipi_item   := _vl_sub_tot_item;
                    _vl_aliq_ipi_item := _vnd_item.vl_aliq_ipi;
                    _vl_ipi_item      := cast(_vl_sub_tot_item * _vnd_item.vl_aliq_ipi / 100 as numeric(12,2));
                    
                    _vl_ipi := _vl_ipi + _vl_ipi_item;
                end if;
            end if;
            
            _vl_bc_pis_item   := 0;
            _vl_aliq_pis_item := 0;
            _vl_pis_item      := 0;
            if (_vnd_item.vl_aliq_pis <> 0) then
                if (_vnd_item.id_trib_pis = '03') then
                    _vl_bc_pis_item   := _vl_qtd_trib;
                else
                    _vl_bc_pis_item   := _vl_sub_tot_item;
                end if;
                _vl_aliq_pis_item := _vnd_item.vl_aliq_pis;
                -- _vl_pis_item      := cast(_vnd_item.vl_sub_tot * _vnd_item.vl_aliq_pis / 100 as numeric(12,2));
                _vl_pis_item      := _vl_sub_tot_item * _vnd_item.vl_aliq_pis / 100;
                
                _vl_pis := _vl_pis + _vl_pis_item;
            end if;
            
            _vl_bc_cofins_item   := 0;
            _vl_aliq_cofins_item := 0;
            _vl_cofins_item      := 0;
            if (_vnd_item.vl_aliq_cofins <> 0) then
                if (_vnd_item.id_trib_cofins = '03') then
                    _vl_bc_cofins_item   := _vl_qtd_trib;
                else
                    _vl_bc_cofins_item   := _vl_sub_tot_item;
                end if;
                _vl_aliq_cofins_item := _vnd_item.vl_aliq_cofins;
                --_vl_cofins_item      := cast(_vnd_item.vl_sub_tot * _vnd_item.vl_aliq_cofins / 100 as numeric(12,2));
                _vl_cofins_item      := _vl_sub_tot_item * _vnd_item.vl_aliq_cofins / 100;
                
                _vl_cofins := _vl_cofins + _vl_cofins_item;
            end if;
            
            _vl_bc_icms_st_item   := 0;
            _vl_aliq_icms_st_item := 0;
            _vl_icms_st_item      := 0;
            /*
             configurar para calcular o valor do icms st pelo cnae
             
            if (_vnd_item.vl_aliq_icms_st <> 0) then
                _vl_bc_icms_st_item   := _vnd_item.vl_tot;
                _vl_aliq_icms_st_item := _vnd_item.vl_aliq_icms_st;
                _vl_icms_st_item      := _vnd_item.vl_tot * _vnd_item.vl_aliq_icms_st / 100;
                
                _vl_bc_icms_st := _vl_bc_icms_st + _vl_bc_icms_st_item;
                _vl_icms_st := _vl_icms_st + _vl_icms_st_item;
            end if;
            */
            
            _vl_desc := cast(_vl_desc + _vnd_item.vl_desc as numeric(12,2));
            _vl_out  := _vl_out + coalesce(_vnd_item.vl_acr, 0);
            
            _vl_item := cast(_vl_item + _vl_sub_tot_item as numeric(12,2));
                
            _vl_tot_trib := cast(_vl_tot_trib + coalesce(_vl_tot_trib_item, 0) as numeric(12,2));
            _vl_unt_trib := cast(_vl_sub_tot_item / _vl_qtd_trib as numeric(12,2));
                
            insert into tb_nf_item
                (id_emp, id_nf, id_nf_item, id_dep, id_grd_estq, id_item, descr_item,
                 id_ncm, id_cfop, 
                 id_und_med_com, cd_bar_com, vl_qtd_com, vl_unt_com,
                 id_und_med_trib, cd_bar_trib, vl_qtd_trib, vl_unt_trib,
                 -- vl_seg, vl_frete, 
                 vl_tot, vl_desc, vl_out, 
                 prod_esp, id_grp_trib, 
                 id_trib_icms, mod_bc_icms, vl_bc_icms, vl_aliq_icms, vl_icms, -- vl_perc_red_bc_icms,
                 mod_bc_icms_st, vl_bc_icms_st, vl_aliq_icms_st, vl_icms_st,
                 id_trib_ipi, vl_bc_ipi, vl_aliq_ipi, vl_ipi,
                 id_trib_pis, vl_bc_pis, vl_aliq_pis, vl_pis,
                 id_trib_cofins, vl_bc_cofins, vl_aliq_cofins, vl_cofins, 
                 vl_peso_liq, vl_peso_brt, id_reg_trib,
                 vl_tot_trib,
                 
                 mov_estq, id_und_med_mov, vl_qtd_mov, tot_nf_item)
            values
                (_id_emp, _id_nf, _id_nf_item, _vnd_item.id_dep, _vnd_item.id_grd_estq, _vnd_item.id_item, _vnd_item.descr,
                 _vnd_item.id_ncm, _id_cfop,
                 _vnd_item.id_und_med, _vnd_item.cd_bar, _vnd_item.vl_qtd, _vl_sub_tot_item / _vnd_item.vl_qtd,
                 _id_und_med_trib, _cd_bar_trib, _vl_qtd_trib, _vl_unt_trib,
                 _vl_sub_tot_item, cast(_vnd_item.vl_desc as numeric(12,2)), cast(_vnd_item.vl_acr as numeric(12,2)),
                 _vnd_item.prod_esp, _vnd_item.id_grp_trib,
                 _vnd_item.id_trib_icms, _vnd_item.mod_bc_icms, _vl_bc_icms_item, _vl_aliq_icms_item, _vl_icms_item,
                 _vnd_item.mod_bc_icms_st, _vl_bc_icms_st_item, _vl_aliq_icms_st_item, _vl_icms_st_item,
                 _id_trib_ipi_item, _vl_bc_ipi_item, _vl_aliq_ipi_item, _vl_ipi_item,
                 _vnd_item.id_trib_pis, _vl_bc_pis_item, _vl_aliq_pis_item, _vl_pis_item,
                 _vnd_item.id_trib_cofins, _vl_bc_cofins_item, _vl_aliq_cofins_item, _vl_cofins_item,
                 _vnd_item.vl_peso_liq, _vnd_item.vl_peso_brt, _id_reg_trib_item,
                 cast(_vl_tot_trib_item as numeric(12,2)),
                 false, _vnd_item.id_und_med_mov, _vnd_item.vl_qtd_mov, true
            );
            
            _id_nf_item := _id_nf_item + 1;
        end if;
        
        fetch _vnd_item_list into _vnd_item;
        
    end loop;
    
    
    close _vnd_item_list;
    
    _vl_nf := _vl_item;
    
    if (position('[ICMS]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + coalesce(_vl_icms, 0);
    end if;
    
    if (position('[ICMS_ST]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + coalesce(_vl_icms_st, 0);
    end if;
    
    -- if (position('[FRETE]' in _nat_op.ap_tot_nf) > 0) then
    --    _vl_nf := _vl_nf + _vl_frete;
    -- end if;
    
    if (position('[IPI]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + coalesce(_vl_ipi, 0);
    end if;
    
    if (position('[PIS]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + cast(coalesce(_vl_pis, 0) as numeric(12,2));
    end if;
    
    if (position('[COFINS]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + cast(coalesce(_vl_cofins, 0) as numeric(12,2));
    end if;
    
    if (position('[DESC]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf - coalesce(_vl_desc, 0);
    end if;
    
    if (position('[OUT]' in _nat_op.ap_tot_nf) > 0) then
        _vl_nf := _vl_nf + coalesce(_vl_out, 0);
    end if;
    
    update tb_nf set
        vl_bc_icms = _vl_bc_icms,
        vl_icms = _vl_icms,
        vl_bc_icms_st = _vl_bc_icms_st,
        vl_icms_st = _vl_icms_st,
        vl_ipi = _vl_ipi,
        vl_pis = _vl_pis,
        vl_cofins = _vl_cofins,
        vl_desc = _vl_desc,
        vl_out = _vl_out,
        vl_item = _vl_item,
        vl_nf = _vl_nf,
        vl_tot_trib = _vl_tot_trib
    where
        id_emp = _id_emp and
        id_nf = _id_nf;

        
    open _vnd_parc_list for
        select *
        from tb_vnd_parc
        where
            id_emp = _id_emp and
            id_vnd = _id_vnd;
        
    fetch _vnd_parc_list into _vnd_parc;
        
    _id_nf_parc := 1;
        
    _vl_rest_desc_vnd := _vnd.vl_desc_nf;
    
    while found loop
        _vl_desc_vnd := 0;
        
        _vl_parc_nf := cast(_vnd_parc.vl_parc * _vl_nf / _vnd.vl_tot as numeric(12,2));
        
        if (_vl_rest_desc_vnd > 0) then
            _vl_desc_vnd := cast(_vl_parc_nf * _vnd.vl_desc_nf / _vnd.vl_sub_tot_nf as numeric(12,2));
                
            _vl_rest_desc_vnd := _vl_rest_desc_vnd - _vl_desc_vnd;
                
            _vl_sub_tot_item := _vl_parc_nf - _vl_desc_vnd;
        else
            _vl_sub_tot_item := _vl_parc_nf;
        end if;
    
        insert into tb_nf_parc
            (id_emp, id_nf, id_nf_parc, id_op_fnc,
             dt_venc, vl_parc, nr_doc, 
             emit, cpf_cnpj, id_bnc, ag, cnt, 
             nr_parc, qtd_parc)
        values
            (_id_emp, _id_nf, _id_nf_parc, _vnd_parc.id_op_fnc,
             _vnd_parc.dt_venc, _vl_sub_tot_item, _vnd_parc.nr_doc,
             _vnd_parc.emit, _vnd_parc.cpf_cnpj, _vnd_parc.id_bnc, _vnd_parc.ag, _vnd_parc.cnt,
             _vnd_parc.nr_parc, _vnd_parc.qtd_parc);

        _id_nf_parc := _id_nf_parc + 1;
            
        fetch _vnd_parc_list into _vnd_parc;
    end loop;
    
    
    if (_mod_nf = 'NFE' or _mod_nf = 'NFCE') then
        insert into tb_nfe
            (id_emp, id_nf, sit)
        values
            (_id_emp, _id_nf, '0');
    end if;
  /*       
         
  id_mod_frete, 
  id_part_trp,
  cpf_cnpj_trp,
  nome_trp,
  insc_trp,
  logr_trp,
  id_munic_trp,
  placa_trp,
  vl_peso_liq_trp,
  vl_peso_brt_trp,
  vl_qtd_vol_trp,
  entreg_trp,
  */
  
        
    
    -- fetch _vnd_item_list into _vnd_
            

    return true;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_gera_nfe_inut (
  _id_emp integer
)
RETURNS integer AS
$body$
declare
    _list refcursor;
    _item record;
    
    _ano integer;
    _id_mod_nf varchar;
    _ser varchar;
    _num_ini integer;
    _num_fin integer;
    
    _continue boolean;
    
    _result integer;
begin
    open _list for
        select 
            tb.*,
            (select max(extract(year from nf1.dt_emis))
             from tb_nf as nf1
             where
                 tb.id_emp = nf1.id_emp and
                 tb.tp_emis = nf1.tp_emis and
                 tb.id_mod_nf = nf1.id_mod_nf and
                 tb.ser = nf1.ser and
                 nf1.num < tb.num) as ano
        from (
            select
                id_emp,
                tp_emis,
                id_mod_nf,
                ser,
                generate_series(num_ini, num_fin) as num
            from (
                select
                    id_emp,
                    tp_emis,
                    id_mod_nf,
                    ser,
                    min(num) as num_ini,
                    max(num) as num_fin
                from tb_nf
                where
                    id_emp = _id_emp and
                    tp_emis = '[P]' and
                    id_mod_nf in ('55', '65')
                group by
                    id_emp,
                    tp_emis,
                    id_mod_nf,
                    ser
                order by
                    id_emp,
                    tp_emis,
                    id_mod_nf,
                    ser
            ) as tb
        ) as tb
        left outer join tb_nf on
            (tb.id_emp = tb_nf.id_emp and
             tb.tp_emis = tb_nf.tp_emis and
             tb.id_mod_nf = tb_nf.id_mod_nf and
             tb.ser = tb_nf.ser and
             tb.num = tb_nf.num)
        where
            not exists (select 1
                        from tb_nfe_inut
                        where
                            tb.id_emp = tb_nfe_inut.id_emp and
                            tb.id_mod_nf = tb_nfe_inut.id_mod_nf and
                            tb.ser = tb_nfe_inut.ser and
                            tb.num between tb_nfe_inut.num_ini and tb_nfe_inut.num_fin) and
            tb_nf.num is null
        order by
            tb.id_emp,
            tb.id_mod_nf,
            tb.ser,
            tb.num;


    fetch _list into _item;
    
    _num_ini := 0;
    _num_fin := 0;
    
    _continue := found;
    
    _result := 0;
    
    while (_continue) loop
        
        if (_num_ini = 0) then
            _ano := _item.ano;
            _id_mod_nf := _item.id_mod_nf;
            _ser := _item.ser;
            _num_ini := _item.num;
        end if;
        
        
        if (_num_fin = 0) then
            _num_fin := _item.num;
        end if;
        
        
        fetch _list into _item;
        
        _continue := found;
        
        if (not _continue) 
            or (_item.num <> _num_fin + 1)
            or (_ano <> _item.ano) 
            or (_id_mod_nf <> _item.id_mod_nf) 
            or (_ser <> _item.ser) then
            
            insert into tb_nfe_inut
                (id_emp, id_nfe_inut, ano, id_mod_nf, ser, num_ini, num_fin, just)
            values
                (_id_emp, nextval('sq_nfe_inut'), _ano, _id_mod_nf, _ser, _num_ini, _num_fin, 'PERDA DE SEQUENCIA DO SISTEMA');
            
            _num_ini := 0;
            _num_fin := 0;
            
            _result := _result + 1;
        else
            _num_fin := _num_fin + 1;
            
        end if;
    
    end loop;

    return _result;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_get_num_nf (
  _id_emp integer,
  _id_mod_nf varchar,
  _ser varchar
)
RETURNS integer AS
$body$
declare
    _num_nf integer;
BEGIN
    select max(num) into _num_nf
    from tb_nf
    where
        id_emp = _id_emp and
        tp_emis = '[P]' and
        id_mod_nf = _id_mod_nf and
        ser = _ser;
    
    if (not _num_nf is null) then
        return _num_nf + 1;
    else
        return 1;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_bf (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _nf_item_list refcursor;
    _nf_item record;
    _op_inv varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op in ('INSERT', 'UPDATE') ) and (_app_con <> 'NEO_UNI') then
        if (tg_op  = 'INSERT' and new.tp_emis = '[P]' and new.num is null) then
            new.num := fc_get_num_nf(new.id_emp, new.id_mod_nf, new.ser);
        end if;
    
    elsif (tg_op = 'DELETE') then
        
        update tb_ped set id_nf = null
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
    
        if (old.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
        
        open _nf_item_list for
            select *
            from tb_nf_item
            where
                id_emp = old.id_emp and
                id_nf = old.id_nf;
    
        fetch _nf_item_list into _nf_item;
        
        
    
        while found loop
            if (_nf_item.mov_estq) then
                perform fc_item_estq(_nf_item.id_item, _nf_item.id_emp, _nf_item.id_dep, _nf_item.id_grd_estq, _op_inv, _nf_item.vl_qtd_mov);
            end if;
            
            fetch _nf_item_list into _nf_item;
        end loop;
        
        close _nf_item_list;
        
        
        if (_app_con <> 'NEO_UNI') then
            delete from tb_mov_fnc
            where
                id_emp = old.id_emp and
                org like 'NF.' || old.id_nf || '%';
        end if;
 
    end if;
    
    
    if (tg_op in ('INSERT', 'UPDATE') ) then
        return new;
    else
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_nfe_inut
  ADD COLUMN id_mod_nf CHAR(2);

ALTER TABLE public.tb_nfe_inut
  ALTER COLUMN ser TYPE VARCHAR(5);

ALTER TABLE public.tb_nfe_inut
  DROP COLUMN mod;

DROP FUNCTION public.fc_get_num_nf(_id_emp integer, _ser varchar);

ALTER TABLE public.tb_nfe_inut
  ADD CONSTRAINT fk__nfe_inut__mod_nf FOREIGN KEY (id_mod_nf)
    REFERENCES public.tb_mod_nf(id_mod_nf)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

