CREATE OR REPLACE FUNCTION public.fc_calc_venc (
  _dt_emis date,
  _tp_interv varchar,
  _interv integer
)
RETURNS date AS
$body$
declare
    _str_interv varchar;
begin
    if (_tp_interv = 'D') then
        _str_interv := _interv || ' day';
    else
        _str_interv := _interv || ' month';
    end if;
        
    return _dt_emis + (_str_interv)::interval;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
begin
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and new.tp_doc = 'CH') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, new.id_ct, new.id_part);
        end if;
        
        --
        -- Gera proxima ct contrato
        --
        if (tg_op = 'UPDATE') then
        
            if (new.tp_ct = 'R' and new.stat = 'Q' and old.stat = 'P' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                
                select count(*) into _qtd
                from tb_ct
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    tp_ct = 'R' and
                    org = new.org and
                    dt_venc > new.dt_venc and
                    id_ct <> new.id_ct;
                
                if (_qtd = 0) then
                    
                    select * into _contr
                    from tb_part_contr
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        id_part_contr = cast(_aux[3] as integer);
                
                    if (found) then
                    
                        _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                        
                        if (_dt_venc <= _contr.dt_f) then
                        
                            insert into tb_ct
                                (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, dt_emis, dt_venc,
                                 vl_ct, obs, stat, tp_doc, org)
                            values
                                (_contr.id_emp, nextval('sq_ct'), 'R', _contr.id_part, _contr.doc, new.parc + 1, new.parc + 1, new.dt_venc, _dt_venc,
                                 _contr.vl_contr, _contr.obs, 'P', _contr.tp_doc, new.org);
                        end if;
                    end if;
                end if;
            elsif (new.tp_ct = 'R' and new.stat = 'P' and old.stat = 'Q' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                    
                select * into _contr
                from tb_part_contr
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    id_part_contr = cast(_aux[3] as integer);
                        
                if (found) then
                    _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                    
                    delete from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        tp_ct = 'R' and
                        org = new.org and
                        dt_venc = _dt_venc and
                        stat = 'P' and
                        id_ct <> new.id_ct;
                end if;
            end if;
        end if;
        
        return new;
    else
        if (old.tp_ct = 'P') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
        end if;
        
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_part_contr_af (
)
RETURNS trigger AS
$body$
declare
    _qtd integer;
begin
    select count(*) into _qtd
    from tb_ct
    where
        id_emp = new.id_emp and
        id_part = new.id_part and
        tp_ct = 'R' and
        org = 'CONTR.' || new.id_part || '.' || new.id_part_contr;
        
    if (_qtd = 0) then
        insert into tb_ct
            (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, dt_emis, dt_venc,
             vl_ct, obs, stat, tp_doc, org)
        values
            (new.id_emp, nextval('sq_ct'), 'R', new.id_part, new.doc, 1, 1, new.dt_i, fc_calc_venc(new.dt_i, new.tp_interv, new.interv),
             new.vl_contr, new.obs, 'P', new.tp_doc, 'CONTR.' || new.id_part || '.' || new.id_part_contr);
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _id_cli_cons varchar;
begin
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
    
        if (new.org = 'CONSIG') then
            update tb_consig set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_consig = new.id_org;
        end if;
        
        _id_cli_cons := fc_get_emp_cnf(new.id_emp, 01000);
        
        if (cast(new.id_cli as varchar) <> _id_cli_cons) then
            
            update tb_part set
                id_cond_pagto = new.id_cond_pagto,
                id_fm_pagto = new.id_fm_pagto
            where
                id_part = new.id_cli;
                
        end if;
            
    elsif (tg_op = 'DELETE') and (fc_id_est_con() is null) then
        
        if (old.org = 'CONSIG') then
            update tb_consig set
                sit = 'D'
            where
                id_emp = old.id_emp and
                id_consig = old.id_org;
        end if;
    
    end if;
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_ct
  ADD COLUMN cmp1 VARCHAR(255);

ALTER TABLE public.tb_part
  ADD COLUMN id_cond_pagto INTEGER;

ALTER TABLE public.tb_part
  ADD COLUMN id_fm_pagto INTEGER;

CREATE TABLE public.tb_part_contr (
  id_part INTEGER NOT NULL, 
  id_emp INTEGER NOT NULL, 
  id_part_contr INTEGER NOT NULL, 
  doc VARCHAR(30), 
  dt_i DATE, 
  dt_f DATE, 
  vl_contr NUMERIC(12,4), 
  tp_interv VARCHAR(1), 
  interv INTEGER, 
  obs VARCHAR(255), 
  sit VARCHAR(1), 
  tp_doc VARCHAR(5)
) WITHOUT OIDS;

ALTER TABLE public.tb_rel
  ADD COLUMN org VARCHAR(255);

CREATE TABLE public.tb_sis_atu (
  dt_hr TIMESTAMP WITHOUT TIME ZONE, 
  ver VARCHAR NOT NULL, 
  arq BYTEA
) WITHOUT OIDS;

CREATE TABLE public.tb_sis_ct (
  id_emp INTEGER NOT NULL, 
  id_ct INTEGER NOT NULL, 
  tp_ct CHAR(1), 
  id_part INTEGER, 
  nr_doc VARCHAR(20), 
  parc INTEGER, 
  qtd_parc INTEGER, 
  dt_emis DATE, 
  dt_venc DATE, 
  vl_ct NUMERIC(12,4), 
  obs VARCHAR(255), 
  stat CHAR(1), 
  id_vnd INTEGER, 
  id_vnd_parc INTEGER, 
  dt_prev DATE, 
  descr_prev VARCHAR(255), 
  id_nf INTEGER, 
  id_nf_parc INTEGER, 
  tp_doc VARCHAR(5), 
  emit VARCHAR(150), 
  cpf_cnpj VARCHAR(20), 
  id_bnc CHAR(3), 
  ag VARCHAR(20), 
  cnt VARCHAR(20), 
  id_cnt_bnc INTEGER, 
  id_bx_ct INTEGER, 
  org VARCHAR(100), 
  sit_ch VARCHAR(5), 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  cd_ocor VARCHAR(2), 
  descr_ocor VARCHAR(255), 
  dt_ocor DATE, 
  cd_mtv_ocor VARCHAR(2), 
  descr_mtv_ocor VARCHAR(255), 
  lic VARCHAR(255), 
  cmp1 VARCHAR(255)
) INHERITS (public.tb_ct)
WITHOUT OIDS;

ALTER TABLE public.tb_vnd
  ADD COLUMN id_fm_pagto INTEGER;

CREATE OR REPLACE VIEW public.vw_table_size (
    esquema,
    tabela,
    tamanho,
    tamanho_total)
AS
 SELECT x.esquema, x.tabela, 
    pg_size_pretty(pg_relation_size(x.esq_tab::regclass)) AS tamanho, 
    pg_size_pretty(pg_total_relation_size(x.esq_tab::regclass)) AS tamanho_total
   FROM ( SELECT pg_tables.tablename AS tabela, pg_tables.schemaname AS esquema, 
            (pg_tables.schemaname::text || '.'::text) || pg_tables.tablename::text AS esq_tab
           FROM pg_tables
          WHERE pg_tables.schemaname <> ALL (ARRAY['pg_catalog'::name, 'information_schema'::name, 'pg_toast'::name])) x
  ORDER BY pg_total_relation_size(x.esq_tab::regclass) DESC;

ALTER TABLE public.tb_sis_atu
  ADD CONSTRAINT pk_sis_atu 
    PRIMARY KEY (ver);

ALTER TABLE public.tb_part_contr
  ADD CONSTRAINT pk_part_contr 
    PRIMARY KEY (id_part, id_emp, id_part_contr);

ALTER TABLE public.tb_vnd
  ADD CONSTRAINT fk__vnd__fm_pagto FOREIGN KEY (id_fm_pagto)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_contr
  ADD CONSTRAINT fk__part_contr__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_contr
  ADD CONSTRAINT fk__part_contr__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part
  ADD CONSTRAINT fk__part__fm_pagto FOREIGN KEY (id_fm_pagto)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part
  ADD CONSTRAINT fk__part__cond_pagto FOREIGN KEY (id_cond_pagto)
    REFERENCES public.tb_cond_pagto(id_cond_pagto)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_part_contr_af AFTER INSERT OR UPDATE 
ON public.tb_part_contr FOR EACH ROW 
EXECUTE PROCEDURE public.fc_tr_part_contr_af();

