CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
    _log_tab boolean;
    _pk varchar[];
begin
    select _tab in (
        'tb_bairro',
        'tb_bnc',
        'tb_cfop',
        'tb_cnae',
        'tb_cnt_bnc',
        'tb_cond_pagto',
        'tb_conv',
        'tb_cx',
        'tb_dep',
        'tb_est',
        'tb_grd_estq',
        'tb_grp_cfop',
        'tb_grp_item',
        'tb_grp_trib',
        'tb_grp_usr',
        'tb_item',
        'tb_item_emp',
        'tb_item_estq',
        'tb_logr',
        'tb_marca',
        'tb_mod_frete',
        'tb_mod_nf',
        'tb_mtv_dev_ch',
        'tb_munic',
        'tb_nat_op',
        'tb_ncm',
        'tb_op_fnc',
        'tb_org_icms',
        'tb_prod_anp',
        'tb_reg_trib',
        'tb_rel',
        'tb_rota',
        'tb_serv',
        'tb_sis_lay',
        'tb_sis_valid',
        'tb_tp_item',
        'tb_trib_cofins',
        'tb_trib_icms',
        'tb_trib_ipi',
        'tb_trib_pis',
        'tb_uf',
        'tb_und_med',
        'tb_usr',
        'tb_ped',
        'tb_mnt_estq',
        'tb_email',
        'tb_mov_bnc',
        'tb_mov_cx',
        'tb_mov_fnc',
        'tb_vnd',
        'tb_part',
        'tb_ct',
        'tb_bx_ct',
        'tb_nf',
        'tb_nfe'
    ) into _log_tab;
    
    
    delete from tb_sis_uni
    where
        tab = _tab;


    if (_log_tab and _install) then
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        execute 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log after insert or update or delete ' ||
            ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';

        perform fc_add_col('public.' || _tab, 'dt_hr_ult_alt', 'timestamp');
        
        select
            array(
                select 
                    cast(c.column_name as varchar)
                from information_schema.table_constraints tc
                join information_schema.constraint_column_usage as ccu using 
                    (constraint_schema, constraint_name)
                join information_schema.columns as c on 
                    (c.table_schema = tc.constraint_schema and 
                     tc.table_name = c.table_name and 
                     ccu.column_name = c.column_name)
                where 
                    constraint_type = 'PRIMARY KEY' and
                    tc.table_name = _tab
                )
        into _pk;
        
        insert into tb_sis_uni
            (tab, pk)
        values
            (_tab, _pk);
        
        
        return true;
    else 
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;



CREATE OR REPLACE FUNCTION public.fc_tr_log (
)
RETURNS trigger AS
$body$
declare
    _pk varchar[];
    _val varchar[];
    _col_list varchar[];
    _val_list varchar[];
    _id_est integer;
    _i integer;
    _idx integer;
    _count integer;
    _aux varchar;
    
    _dt_hr timestamp;
    
    _app_con varchar;
    
    _est_list refcursor;
    _est record;
    _id_est_con integer;
    _tab record;
    _id_log bigint;
    
    _id_pk_name varchar;
    _id_pk bigint;
    _inc_seq_est integer;
    
    _id_est_local integer;
    _id_est_central integer;
begin
    _app_con := fc_app_con();
    
    if (_app_con = 'NEO_UNI' and tg_table_name <> 'tb_part') then
        return null;
    end if;
    
    _id_est_local := fc_id_est_local();
    _id_est_central := fc_id_est_central();
    
    select pk into _pk
    from tb_sis_uni
    where
        tab = tg_table_name;
        
    if (not found) then
        select
            array(
                select 
                    cast(c.column_name as varchar)
                from information_schema.table_constraints tc
                join information_schema.constraint_column_usage as ccu using 
                    (constraint_schema, constraint_name)
                join information_schema.columns as c on 
                    (c.table_schema = tc.constraint_schema and 
                     tc.table_name = c.table_name and 
                     ccu.column_name = c.column_name)
                where 
                    constraint_type = 'PRIMARY KEY' and
                    tc.table_name = tg_table_name
                )
        into _pk;    
    end if;    
    
    _id_est := fc_id_est_con();
    
    _count := array_upper(_pk, 1);
    
    for _i in 1.._count loop

        if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using new;
        else
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using old;
        end if;
        
        _val[_i] := _aux;
    end loop;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        _dt_hr := new.dt_hr_ult_alt;
    else
        _dt_hr := current_timestamp;
    end if;
    
    --
    -- Central partindo do NEO_UNI (tb_part)
    --
    if (_id_est_local = _id_est_central and _app_con = 'NEO_UNI' and tg_table_name = 'tb_part') then
        _id_est_con := fc_id_est_con();
        
        open _est_list for
            select *
            from tb_est
            where
                tb_est.tp_est <> 'C' and
                tb_est.id_est <> _id_est_con;

    elsif (_id_est_local <> _id_est_central) then
        
        open _est_list for
            select *
            from tb_est
            where
                tb_est.tp_est = 'C';
                
    elsif (_id_est_local = _id_est_central and 
        tg_table_name in ('tb_email', 'tb_mov_bnc', 'tb_mov_cx', 'tb_mov_fnc', 'tb_vnd', 'tb_ct', 'tb_bx_ct', 'tb_nf', 'tb_nfe')) then
        
        
        if (tg_table_name = 'tb_nfe') then
            _id_pk_name := 'id_nf';
        else
            _id_pk_name := replace(tg_table_name, 'tb_', 'id_');
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            execute 'select ($1).' || _id_pk_name || '::text' into _id_pk using new;
        else
            execute 'select ($1).' || _id_pk_name || '::text' into _id_pk using old;
        end if;
        
        _id_est := mod(_id_pk, 100);
        
        if (_id_est <> _id_est_central) then
            open _est_list for
                select *
                from tb_est
                where
                    tb_est.id_est = _id_est;
        else
            return null;
        end if;
        
    else
        
        open _est_list for
            select *
            from tb_est
            where
                tb_est.tp_est <> 'C';
                
    end if;
        
    fetch _est_list into _est;

    while found loop
    
        select id_log into _id_log
        from tb_log
        where
            org = tg_table_name and
            val_pk = _val and
            id_est = _est.id_est and
            sit = 'P';
        
        if not found then
            insert into tb_log
                (id_log, org, op, col_pk, val_pk, id_est, dt_hr, sit)
            values
                (nextval('sq_log'), tg_table_name, substring(tg_op, 1, 1), _pk, _val, _est.id_est, _dt_hr, 'P');
        end if;
            
        fetch _est_list into _est;
        
    end loop;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;