CREATE SEQUENCE public.sq_rom
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
BEGIN
    if (tg_op = 'INSERT') then
        if (new.vl_rest > 0) then
            insert into tb_ct
                (id_emp, id_ct, tp_ct, id_part, parc, qtd_parc, 
                 dt_emis, dt_venc,
                 vl_ct, obs, stat, tp_doc, 
                 org, sit_ch)
            values
                (new.id_emp, nextval('sq_ct'), new.tp_bx, new.id_part, 1, 1,
                new.dt_bx, new.dt_bx,
                new.vl_rest, 'RESTANTE BAIXA ' || new.id_bx_ct, 'P', 'DUP',
                'BX.' || new.id_bx_ct, new.id_bx_ct);
        end if;
    end if;

    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto);
                     
        end if;
        
        select nome into _descr_part
        from tb_part
        where
            id_part = _bx_ct.id_part;
            
        if (_descr_part is null) then
            _descr_part := '';
        end if;
        
        _descr := ifthen(_bx_ct.tp_bx = 'R', 'RECEBIMENTO DE DUPLICATA', 'PAGAMENTO DE DUPLICATA');
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND');
        else
            perform fc_gera_mov_fnc(new.id_emp, _bx_ct.id_cx, _bx_ct.id_usr, _bx_ct.dt_bx, cast(current_time as time), trim(_descr || _descr_part),
                ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_bx_ct);
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and new.tp_doc = 'CH') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, new.id_ct, new.id_part);
        end if;
        
        return new;
    else
        if (old.tp_ct = 'P') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
        end if;
        
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
 
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     id_cnt_bnc, org,
                     obs)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 'NF.' || new.id_nf || '.' || new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr);
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC') then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, _nf.id_nf,
                     _nf.id_part_emt, 'PEND');
            else
                perform fc_gera_mov_fnc(new.id_emp, _nf.id_cx, _nf.id_usr, _nf.dt_op, cast(current_time as time), 'NF ' || _nf.fant_emt || ' ' || _op_fnc.descr,
                    'D', new.vl_parc, 'NF.' || new.id_nf || '.' || new.id_nf_parc, new.id_nf);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _cond_pagto record;
begin
    /*
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        if (new.tp_vnd = 'V') then
            select * into _cond_pagto
            from tb_cond_pagto
            where
                id_cond_pagto = new.id_cond_pagto;
            
            perform fc_gera_mov_fnc(new.id_emp, new.id_cx, new.id_usr, new.dt_vnd, cast(current_time as time), 'VENDA ' || new.nome || ' ' || _cond_pagto.descr,
                'C', new.vl_tot, 'VND', new.id_vnd);
        end if;
    elsif (tg_op = 'DELETE') and (fc_id_est_con() is null) then
        if (old.tp_vnd = 'V') then
            select * into _cond_pagto
            from tb_cond_pagto
            where
                id_cond_pagto = old.id_cond_pagto;

            perform fc_gera_mov_fnc(old.id_emp, old.id_cx, old.id_usr, old.dt_vnd, cast(current_time as time), 'VENDA CANCELADA '  || old.nome || ' ' || _cond_pagto.descr,
               'D', old.vl_tot, 'VND', old.id_vnd);
        end if;
    end if;
    */
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc and
            id_org = old.id_vnd;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _vnd
        from tb_vnd
        where
            id_emp = new.id_emp and
            id_vnd = new.id_vnd;

        if (_vnd.tp_vnd = 'V') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
                _nr_doc := new.nr_doc;
                
                if (_op_fnc.tp_op_fnc = 'DUP') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
            
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     org)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc);
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC') then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd,
                     _vnd.id_cli, 'PEND');
            else
                perform fc_gera_mov_fnc(new.id_emp, _vnd.id_cx, _vnd.id_usr, _vnd.dt_vnd, cast(current_time as time), 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr,
                    'C', new.vl_parc, 'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd);
            end if;
        end if;
        
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_ct
  ADD COLUMN tp_doc VARCHAR(5);

ALTER TABLE public.tb_ct
  ADD COLUMN emit VARCHAR(150);

ALTER TABLE public.tb_ct
  ADD COLUMN cpf_cnpj VARCHAR(20);

ALTER TABLE public.tb_ct
  ADD COLUMN id_bnc CHAR(3);

ALTER TABLE public.tb_ct
  ADD COLUMN ag VARCHAR(20);

ALTER TABLE public.tb_ct
  ADD COLUMN cnt VARCHAR(20);

ALTER TABLE public.tb_ct
  ADD COLUMN id_cnt_bnc INTEGER;

ALTER TABLE public.tb_ct
  ADD COLUMN id_bx_ct INTEGER;

ALTER TABLE public.tb_ct
  ADD COLUMN org VARCHAR(100);

ALTER TABLE public.tb_ct
  ADD COLUMN sit_ch VARCHAR(5);

ALTER TABLE public.tb_nf
  ADD COLUMN id_cx INTEGER;

ALTER TABLE public.tb_nf
  ADD COLUMN id_usr INTEGER;

ALTER TABLE public.tb_part
  ADD COLUMN id_vndr INTEGER;

CREATE TABLE public.tb_rom (
  id_emp INTEGER NOT NULL, 
  id_rom INTEGER NOT NULL, 
  dt_rom DATE, 
  id_vndr INTEGER, 
  obs VARCHAR(255)
) WITHOUT OIDS;

CREATE TABLE public.tb_rom_vnd (
  id_emp INTEGER NOT NULL, 
  id_rom INTEGER NOT NULL, 
  id_vnd INTEGER NOT NULL
) WITHOUT OIDS;

ALTER TABLE public.tb_vnd_parc
  ADD COLUMN id_cnt_bnc INTEGER;

ALTER TABLE public.tb_rom_vnd
  ADD CONSTRAINT pk_rom_vnd 
    PRIMARY KEY (id_emp, id_rom, id_vnd);

ALTER TABLE public.tb_rom
  ADD CONSTRAINT pk_rom 
    PRIMARY KEY (id_emp, id_rom);

ALTER TABLE public.tb_vnd_parc
  ADD CONSTRAINT fk__vnd_parc__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_vnd
  ADD CONSTRAINT fk__rom_vnd__vnd FOREIGN KEY (id_emp, id_vnd)
    REFERENCES public.tb_vnd(id_emp, id_vnd)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom_vnd
  ADD CONSTRAINT fk__rom_vnd__rom FOREIGN KEY (id_emp, id_rom)
    REFERENCES public.tb_rom(id_emp, id_rom)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom
  ADD CONSTRAINT fk__rom__vndr FOREIGN KEY (id_vndr)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_rom
  ADD CONSTRAINT fk__rom__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part
  ADD CONSTRAINT fk__part__vndr FOREIGN KEY (id_vndr)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_nf
  ADD CONSTRAINT fk__nf__usr FOREIGN KEY (id_usr)
    REFERENCES public.tb_usr(id_usr)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_nf
  ADD CONSTRAINT fk__nf__cx FOREIGN KEY (id_emp, id_cx)
    REFERENCES public.tb_cx(id_emp, id_cx)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ct
  ADD CONSTRAINT fk__ct__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ct
  ADD CONSTRAINT fk__ct__bnc FOREIGN KEY (id_bnc)
    REFERENCES public.tb_bnc(id_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_bx_ct_pagto
  ADD CONSTRAINT fk__bx_ct_pagto__bnc FOREIGN KEY (id_bnc)
    REFERENCES public.tb_bnc(id_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_ct_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_ct FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_ct_bf();

