drop view public.vw_vnd_rota;

create view public.vw_vnd_rota
as
select
    id_emp,
    dt_vnd,
    dia_semana,
    id_rota,
    id_vndr,
    descr,
    sum(vl_cred) as vl_cred,
    sum(vl_ch_prz) as vl_ch_prz,
    sum(vl_ch_vst) as vl_ch_vst,
    sum(vl_out) as vl_out,
    sum(qtd_cli) as qtd_cli
from
(
    select 
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        case extract(dow from tb_vnd.dt_vnd)
            when 0 then 'Domingo'
            when 1 then 'Segunda'
            when 2 then 'Tera'
            when 3 then 'Quarta'
            when 4 then 'Quinta'
            when 5 then 'Sexta'
            when 6 then 'Sabado'
        end as dia_semana,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr,
        0 as vl_cred,
        0 as vl_ch_prz,
        0 as vl_ch_vst,
        0 as vl_out,
        count(*) as qtd_cli
    from tb_vnd
    left outer join tb_part on
        (tb_vnd.id_cli = tb_part.id_part)
    left outer join tb_rota on
        (tb_part.id_rota = tb_rota.id_rota)
    group by
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr
        
    union all

    select 
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        case extract(dow from tb_vnd.dt_vnd)
            when 0 then 'Domingo'
            when 1 then 'Segunda'
            when 2 then 'Tera'
            when 3 then 'Quarta'
            when 4 then 'Quinta'
            when 5 then 'Sexta'
            when 6 then 'Sabado'
        end as dia_semana,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr,
        sum(tb_vnd_parc.vl_parc) as vl_cred,
        0 as vl_ch_prz,
        0 as vl_ch_vst,
        0 as vl_out,
        0 as qtd_cli
    from tb_vnd
    left outer join tb_part on
        (tb_vnd.id_cli = tb_part.id_part)
    left outer join tb_rota on
        (tb_part.id_rota = tb_rota.id_rota)
    left outer join tb_vnd_parc on
        (tb_vnd.id_emp = tb_vnd_parc.id_emp and
         tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
    join tb_op_fnc on
        (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc)
    where
        tb_vnd.id_emp = tb_vnd_parc.id_emp and
        tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
        tb_op_fnc.tp_op_fnc = 'CRED'
    group by
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr
        
    union all

    select 
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        case extract(dow from tb_vnd.dt_vnd)
            when 0 then 'Domingo'
            when 1 then 'Segunda'
            when 2 then 'Tera'
            when 3 then 'Quarta'
            when 4 then 'Quinta'
            when 5 then 'Sexta'
            when 6 then 'Sabado'
        end as dia_semana,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr,
        0 as vl_cred,
        sum(tb_vnd_parc.vl_parc) as vl_ch_prz,
        0 as vl_ch_vst,
        0 as vl_out,
        0 as qtd_cli
    from tb_vnd
    left outer join tb_part on
        (tb_vnd.id_cli = tb_part.id_part)
    left outer join tb_rota on
        (tb_part.id_rota = tb_rota.id_rota)
    left outer join tb_vnd_parc on
        (tb_vnd.id_emp = tb_vnd_parc.id_emp and
         tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
    join tb_op_fnc on
        (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc)
    where
        tb_vnd.id_emp = tb_vnd_parc.id_emp and
        tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
        tb_op_fnc.tp_op_fnc in ('CH_PRZ')
    group by
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr

    union all
    
    select 
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        case extract(dow from tb_vnd.dt_vnd)
            when 0 then 'Domingo'
            when 1 then 'Segunda'
            when 2 then 'Tera'
            when 3 then 'Quarta'
            when 4 then 'Quinta'
            when 5 then 'Sexta'
            when 6 then 'Sabado'
        end as dia_semana,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr,
        0 as vl_cred,
        0 as vl_ch_prz,
        sum(tb_vnd_parc.vl_parc) as vl_ch_vst,
        0 as vl_out,
        0 as qtd_cli
    from tb_vnd
    left outer join tb_part on
        (tb_vnd.id_cli = tb_part.id_part)
    left outer join tb_rota on
        (tb_part.id_rota = tb_rota.id_rota)
    left outer join tb_vnd_parc on
        (tb_vnd.id_emp = tb_vnd_parc.id_emp and
         tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
    join tb_op_fnc on
        (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc)
    where
        tb_vnd.id_emp = tb_vnd_parc.id_emp and
        tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
        tb_op_fnc.tp_op_fnc in ('CH_VST')
    group by
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr

    union all

    select 
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        case extract(dow from tb_vnd.dt_vnd)
            when 0 then 'Domingo'
            when 1 then 'Segunda'
            when 2 then 'Tera'
            when 3 then 'Quarta'
            when 4 then 'Quinta'
            when 5 then 'Sexta'
            when 6 then 'Sabado'
        end as dia_semana,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr,
        0 as vl_cred,
        0 as vl_ch_prz,
        0 as vl_ch_vst,
        sum(tb_vnd_parc.vl_parc) as vl_out,
        0 as qtd_cli
    from tb_vnd
    left outer join tb_part on
        (tb_vnd.id_cli = tb_part.id_part)
    left outer join tb_rota on
        (tb_part.id_rota = tb_rota.id_rota)
    left outer join tb_vnd_parc on
        (tb_vnd.id_emp = tb_vnd_parc.id_emp and
         tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
    join tb_op_fnc on
        (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc)
    where
        tb_vnd.id_emp = tb_vnd_parc.id_emp and
        tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
        tb_op_fnc.tp_op_fnc not in ('CRED', 'CH_VST', 'CH_PRZ')
    group by
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr
) as tb
--where
--    id_emp = :id_emp
--[filter]
group by
    id_emp,
    dt_vnd,
    id_vndr,
    dia_semana,
    id_rota,
    descr
    
order by
    dt_vnd