drop view vw_mov_plano_ct;

ALTER TABLE public.tb_tp_contr_frete
  ALTER COLUMN conf TYPE VARCHAR(1000);
  
  
  
CREATE OR REPLACE VIEW public.vw_mov_plano_ct(
    id_emp,
    id_mov_plano_ct,
    org,
    tp_org,
    id_org,
    id_org_item,
    id_plano_ct,
    dt_lanc,
    descr,
    vl_lanc)
AS( ( ( ( (
  SELECT tb_bx_ct.id_emp,
         (('BX_CT.' || tb_bx_ct.id_bx_ct) || '.') || tb_ct.id_ct AS
           id_mov_plano_ct,
         (('BX_CT.' || tb_bx_ct.id_bx_ct) || '.') || tb_ct.id_ct AS
           org,
         'BX_CT' AS tp_org,
         tb_bx_ct.id_bx_ct AS id_org,
         tb_ct.id_ct AS id_org_item,
         tb_ct.id_plano_ct,
         tb_bx_ct.dt_bx AS dt_lanc,
         tb_part.nome AS descr,
         tb_bx_ct__ct.vl_quit AS vl_lanc
  FROM tb_bx_ct
       JOIN tb_bx_ct__ct ON tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp AND
         tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct
       JOIN tb_ct ON tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp AND
         tb_bx_ct__ct.id_ct = tb_ct.id_ct
       JOIN tb_plano_ct _plano_ct ON tb_ct.id_plano_ct =
         _plano_ct.id_plano_ct
       JOIN tb_part ON tb_ct.id_part = tb_part.id_part
  WHERE COALESCE(tb_ct.tp_org, ''::character varying) <> 'CONTR_FRETE'::
    text
  UNION ALL
  SELECT tb_mov_bnc.id_emp,
         'MOV_BNC.' || tb_mov_bnc.id_mov_bnc AS id_mov_plano_ct,
         'MOV_BNC.' || tb_mov_bnc.id_mov_bnc AS org,
         'MOV_BNC' AS tp_org,
         tb_mov_bnc.id_mov_bnc AS id_org,
         NULL::integer AS id_org_item,
         tb_mov_bnc.id_plano_ct,
         tb_mov_bnc.dt_emis AS dt_lanc,
         COALESCE(tb_part.nome || ' - ', '') ||
           tb_mov_bnc.descr AS descr,
         tb_mov_bnc.vl_lanc
  FROM tb_mov_bnc
       JOIN tb_plano_ct _plano_ct ON tb_mov_bnc.id_plano_ct =
         _plano_ct.id_plano_ct
       LEFT JOIN tb_part ON tb_mov_bnc.id_part = tb_part.id_part
  WHERE NOT COALESCE(tb_mov_bnc.org, ''::character varying) ~~ 'BX.%'::
    text)            UNION ALL
      SELECT tb_mov_fnc.id_emp,
             'MOV_FNC.' || tb_mov_fnc.id_mov_fnc AS id_mov_plano_ct,
             'MOV_FNC.' || tb_mov_fnc.id_mov_fnc AS org,
             'MOV_FNC' AS tp_org,
             tb_mov_fnc.id_mov_fnc AS id_org,
             NULL::integer AS id_org_item,
             tb_mov_fnc.id_plano_ct,
             tb_mov_fnc.dt_lanc,
             tb_mov_fnc.descr,
             tb_mov_fnc.vl_lanc
      FROM tb_mov_fnc
           JOIN tb_plano_ct _plano_ct ON tb_mov_fnc.id_plano_ct =
             _plano_ct.id_plano_ct
      WHERE tb_mov_fnc.org IS NULL)              UNION ALL
        SELECT tb_vnd.id_emp,
               (('VND.' || tb_vnd.id_vnd) || '.') ||
                 tb_vnd_parc.id_vnd_parc AS id_mov_plano_ct,
               (('VND.' || tb_vnd.id_vnd) || '.') ||
                 tb_vnd_parc.id_vnd_parc AS org,
               'VND' AS tp_org,
               tb_vnd.id_vnd AS id_org,
               tb_vnd_parc.id_vnd_parc AS id_org_item,
               tb_emp_cnf.val AS id_plano_ct,
               tb_vnd.dt_vnd AS dt_lanc,
               tb_part.nome AS descr,
               tb_vnd_parc.vl_parc AS vl_lanc
        FROM tb_vnd
             JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND
               tb_vnd.id_vnd = tb_vnd_parc.id_vnd
             JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
             JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
             LEFT JOIN tb_emp_cnf ON tb_vnd.id_emp = tb_emp_cnf.id_emp AND trunc
               ((tb_emp_cnf.id_cnf / 100)::double precision) = 161::double
               precision AND (tb_emp_cnf.id_cnf - 16100) = tb_op_fnc.id_op_fnc
        WHERE COALESCE(tb_vnd.canc, false) = false)                UNION ALL
          SELECT tb_bx_ct.id_emp,
                 (((('CONTR_FRETE.' || tb_bx_ct.id_bx_ct) || '.') ||
                   tb_ct.id_ct) || '.') || tb_emp_cnf.id_cnf AS
                   id_mov_plano_ct,
                 (('CONTR_FRETE.' || tb_bx_ct.id_bx_ct) || '.') ||
                   tb_ct.id_ct AS org,
                 'CONTR_FRETE' AS tp_org,
                 tb_bx_ct.id_bx_ct AS id_org,
                 tb_ct.id_ct AS id_org_item,
                 tb_emp_cnf.val AS id_plano_ct,
                 tb_bx_ct.dt_bx AS dt_lanc,
                 tb_part.nome AS descr,
                 CASE tb_emp_cnf.id_cnf
                   WHEN 26101 THEN tb_contr_frete.vl_frete
                   WHEN 26102 THEN tb_contr_frete.vl_inss
                   WHEN 26103 THEN tb_contr_frete.vl_irrf
                   WHEN 26104 THEN tb_contr_frete.vl_ss
                   WHEN 26105 THEN tb_contr_frete.vl_taxa_coop
                   WHEN 26106 THEN tb_contr_frete.vl_dif_frete
                   WHEN 26107 THEN tb_contr_frete.vl_dif_frete *(- 1)::numeric
                   WHEN 26108 THEN tb_contr_frete.vl_desc_fin
                   WHEN 26109 THEN tb_contr_frete.vl_seg
                   WHEN 26110 THEN CASE
                                     WHEN tb_tp_contr_frete.conf ~~
                                       '%[ADTO_T]%' THEN
                                       tb_contr_frete.vl_adto
                                     ELSE 0::numeric
                                   END
                   WHEN 26111 THEN tb_contr_frete.vl_comis1
                   WHEN 26112 THEN tb_contr_frete.vl_taxa_op
                   WHEN 26113 THEN tb_contr_frete.vl_aliq_ldc
                   WHEN 26114 THEN tb_contr_frete.vl_issqn
                   WHEN 26115 THEN tb_contr_frete.vl_out_desp
                   ELSE NULL::numeric
                 END AS vl_lanc
          FROM tb_bx_ct
               JOIN tb_bx_ct__ct ON tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp AND
                 tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct
               JOIN tb_ct ON tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp AND
                 tb_bx_ct__ct.id_ct = tb_ct.id_ct
               LEFT JOIN tb_plano_ct _plano_ct ON tb_ct.id_plano_ct =
                 _plano_ct.id_plano_ct
               JOIN tb_part ON tb_ct.id_part = tb_part.id_part
               JOIN tb_contr_frete ON tb_contr_frete.id_emp = tb_ct.id_emp AND
                 tb_contr_frete.id_contr_frete = tb_ct.id_org
               JOIN tb_emp_cnf ON tb_ct.id_emp = tb_emp_cnf.id_emp AND
                 tb_emp_cnf.id_cnf >= 26101 AND tb_emp_cnf.id_cnf <= 26115
               JOIN tb_tp_contr_frete ON tb_contr_frete.id_tp_contr_frete =
                 tb_tp_contr_frete.id_tp_contr_frete
          WHERE COALESCE(tb_ct.tp_org, ''::character varying) =
            'CONTR_FRETE')
        UNION ALL 
                 SELECT tb_bx_ct.id_emp,
                        (((('RENEG.' || tb_bx_ct.id_bx_ct) || '.')
                          || tb_bx_ct_pagto.id_bx_ct_pagto) || '.') ||
                          tb_emp_cnf.id_cnf AS id_mov_plano_ct,
                        (('RENEG.' || tb_bx_ct.id_bx_ct) || '.') ||
                          tb_bx_ct_pagto.id_bx_ct_pagto AS org,
                        'RENEG' AS tp_org,
                        tb_bx_ct.id_bx_ct AS id_org,
                        tb_bx_ct_pagto.id_bx_ct_pagto AS id_org_item,
                        tb_emp_cnf.val AS id_plano_ct,
                        tb_bx_ct.dt_bx AS dt_lanc,
                        tb_part.nome AS descr,
                        tb_bx_ct_pagto.vl_pagto AS vl_lanc
                 FROM tb_bx_ct
                      JOIN tb_bx_ct_pagto ON tb_bx_ct.id_emp =
                        tb_bx_ct_pagto.id_emp AND tb_bx_ct.id_bx_ct =
                        tb_bx_ct_pagto.id_bx_ct
                      JOIN tb_part ON tb_bx_ct.id_part = tb_part.id_part
                      JOIN tb_emp_cnf ON tb_bx_ct.id_emp = tb_emp_cnf.id_emp AND
                        tb_emp_cnf.id_cnf = 16401
                      JOIN tb_op_fnc ON tb_bx_ct_pagto.id_op_fnc =
                        tb_op_fnc.id_op_fnc
                 WHERE tb_bx_ct.op = 'R')
UNION ALL 
         SELECT tb_bx_ct.id_emp,
                (('MOV_FUNC.' || tb_bx_ct.id_bx_ct) || '.') ||
                  tb_mov_func.id_mov_func AS id_mov_plano_ct,
                (('MOV_FUNC.' || tb_bx_ct.id_bx_ct) || '.') ||
                  tb_mov_func.id_mov_func AS org,
                'MOV_FUNC' AS tp_org,
                tb_bx_ct.id_bx_ct AS id_org,
                tb_mov_func.id_mov_func AS id_org_item,
                tb_mov_func.id_plano_ct,
                tb_bx_ct.dt_bx AS dt_lanc,
                tb_part.nome AS descr,
                tb_mov_func.vl_lanc
         FROM tb_bx_ct
              JOIN tb_bx_ct__ct ON tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp AND
                tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct
              JOIN tb_ct ON tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp AND
                tb_bx_ct__ct.id_ct = tb_ct.id_ct
              JOIN tb_mov_func ON tb_bx_ct.id_emp = tb_mov_func.id_emp AND
                tb_ct.org =('BX_MOV_FUNC.' ||
                tb_mov_func.id_bx_mov_func)
              JOIN tb_plano_ct _plano_ct ON tb_mov_func.id_plano_ct =
                _plano_ct.id_plano_ct
              JOIN tb_part ON tb_mov_func.id_part = tb_part.id_part;