CREATE OR REPLACE FUNCTION public.fc_tr_contr_frete_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    
    _sit varchar;
    _sit_adto varchar;
    
    _id_ct integer;
    _num integer;
    _cte record;
    _tp_contr_frete record;
    _descr varchar;
begin
    if (tg_op = 'INSERT') then
    
        _sit      := 'P';
        _sit_adto := 'P';
        new.num   := fc_get_num_contr_frete(new.id_emp);
        
    elsif (tg_op = 'UPDATE') then
        
        select coalesce(stat, 'P') into _sit 
        from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'CONTR_FRETE' and
            id_org = old.id_contr_frete;
            -- org = 'CONTR_FRETE.' || old.id_contr_frete;
            
        select coalesce(stat, 'P') into _sit_adto
        from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'ADTO.CONTR_FRETE' and
            id_org = old.id_contr_frete;
            
        if (_sit is null) then
            _sit := 'P';
        end if;
        
        if (_sit_adto is null) then
            _sit_adto := 'P';
        end if;
    
    end if;
        
    if (tg_op = 'DELETE') or (tg_op = 'UPDATE' and _sit = 'P') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'CONTR_FRETE' and
            id_org = old.id_contr_frete;
            
    end if;
    
    if (tg_op = 'DELETE') or (tg_op = 'UPDATE' and coalesce(_sit_adto, 'P') = 'P') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'ADTO.CONTR_FRETE' and
            id_org = old.id_contr_frete;
            
    end if;
        
    if (tg_op = 'INSERT') or (tg_op = 'UPDATE' and _sit = 'P') then

        select conf into _tp_contr_frete
        from tb_tp_contr_frete
        where
            id_tp_contr_frete = new.id_tp_contr_frete;
             
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = 'DUP'
        limit 1;
            
        select * into _cte
        from tb_cte
        where
            id_emp = new.id_emp and
            id_cte = new.id_cte;
            
        _id_ct := nextval('sq_ct');
        
        if (strpos(_tp_contr_frete.conf, '[N_CT_PAG]') <= 0) then
        
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                 dt_emis, dt_venc, vl_ct, stat, id_veic,
                 org, tp_org, id_org,
                 id_op_fnc, vl_quit, vl_rest, 
                 vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                 dt_hr_cad, id_usr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst)
            values
                (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, new.id_part, new.num, 1, 1,
                 new.dt_emis, new.dt_venc, new.vl_tot, 'P', _cte.id_veic,
                 'CONTR_FRETE.' || new.id_contr_frete, 'CONTR_FRETE', new.id_contr_frete,
                 _op_fnc.id_op_fnc, 0, new.vl_tot, 
                 new.vl_tot, 0, 0, 0, 0, 
                 new.dt_hr_cad, new.id_usr_cad, new.id_usr_ult_alt, new.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst);
        end if;
                
    end if;
    
    if (tg_op = 'INSERT') or (tg_op = 'UPDATE' and coalesce(_sit_adto, 'P') = 'P') then
        if (coalesce(new.vl_adto, 0) > 0 and new.tp_adto = 'P') then
            
            -- Nao gera o contas a pagar do adiantamento
            if (strpos(_tp_contr_frete.conf, '[ADTO_N_CT_PAG]') <= 0) then
                      
                select * into _op_fnc
                from tb_op_fnc
                where
                    tp_op_fnc = 'DUP'
                limit 1;
                      
                select
                    tb_cte.*,
                    (select num
                     from tb_cte_doc_ant
                     where
                         tb_cte_doc_ant.id_emp = tb_cte.id_emp and
                         tb_cte_doc_ant.id_cte = tb_cte.id_cte
                     limit 1) as num_doc_ant
                into _cte
                from tb_cte
                where
                    id_emp = new.id_emp and
                    id_cte = new.id_cte;
                
                _descr := 'ADIANTAMENTO CTE ' || _cte.num;
                
                if (_cte.num_doc_ant is not null) then
                    _descr := _descr || ' / CTE ANT: ' || _cte.num_doc_ant;
                end if;
                      
                _id_ct := nextval('sq_ct');
                          
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, id_veic, obs,
                     org, tp_org, id_org,
                     id_op_fnc, vl_quit, vl_rest, 
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     dt_hr_cad, id_usr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_plano_ct, id_cnt_cst)
                values
                    (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, new.id_part, new.num, 1, 1,
                     new.dt_emis, new.dt_venc, new.vl_adto, 'P', _cte.id_veic, _descr,
                     'ADTO.CONTR_FRETE.' || new.id_contr_frete, 'ADTO.CONTR_FRETE', new.id_contr_frete,
                     _op_fnc.id_op_fnc, 0, new.vl_adto, 
                     new.vl_adto, 0, 0, 0, 0, 
                     new.dt_hr_cad, new.id_usr_cad, new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     new.id_plano_ct, new.id_cnt_cst);
            end if;
        end if;
                
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_tp_contr_frete
  ADD COLUMN vl_perc_seg NUMERIC(12,4);

ALTER TABLE public.tb_contr_frete
  ADD COLUMN vl_perc_seg NUMERIC(12,4);

