CREATE SEQUENCE public.sq_func
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_func RESTART WITH 4;

CREATE SEQUENCE public.sq_tp_rec
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_tp_rec RESTART WITH 3;

CREATE TABLE public.tb_cbo (
  id_cbo INTEGER NOT NULL, 
  descr VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR, 
  comp_ult_alt VARCHAR, 
  CONSTRAINT pk_cbo PRIMARY KEY(id_cbo)
) ;

CREATE TABLE public.tb_func (
  id_func INTEGER NOT NULL, 
  descr VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR, 
  comp_ult_alt VARCHAR, 
  CONSTRAINT pk_func PRIMARY KEY(id_func)
) ;

CREATE TABLE public.tb_tp_rec (
  id_tp_rec INTEGER NOT NULL, 
  descr VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR, 
  comp_ult_alt VARCHAR, 
  CONSTRAINT pk_tp_rec PRIMARY KEY(id_tp_rec)
) ;

ALTER TABLE public.tb_part
  ADD COLUMN id_func INTEGER;

ALTER TABLE public.tb_part
  ADD COLUMN id_cbo INTEGER;

ALTER TABLE public.tb_part
  ADD COLUMN dt_ini_ctr_exp DATE;

ALTER TABLE public.tb_part
  ADD COLUMN dt_ren_ctr_exp DATE;

ALTER TABLE public.tb_part
  ADD COLUMN dt_fin_ctr_exp DATE;

CREATE TABLE public.tb_part_exam (
  id_part INTEGER NOT NULL, 
  id_part_exam INTEGER NOT NULL, 
  dt_exam DATE, 
  tp_exam VARCHAR(10), 
  dt_val DATE, 
  descr VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR, 
  comp_ult_alt VARCHAR, 
  CONSTRAINT pk_part_exam PRIMARY KEY(id_part, id_part_exam)
) ;

CREATE TABLE public.tb_part_fer (
  id_part INTEGER NOT NULL, 
  id_part_fer INTEGER NOT NULL, 
  dt_aq_i DATE, 
  dt_aq_f DATE, 
  dt_con_i DATE, 
  dt_con_f DATE, 
  dt_con_r DATE, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR, 
  comp_ult_alt VARCHAR, 
  CONSTRAINT pk_part_fer PRIMARY KEY(id_part, id_part_fer)
) ;

CREATE TABLE public.tb_part_rec (
  id_part INTEGER NOT NULL, 
  id_part_rec INTEGER NOT NULL, 
  id_tp_rec INTEGER, 
  vl_rec NUMERIC(12,2), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR, 
  comp_ult_alt VARCHAR, 
  CONSTRAINT pk_part_rec PRIMARY KEY(id_part, id_part_rec)
) ;

CREATE TABLE public.tb_part_sal (
  id_part INTEGER NOT NULL, 
  id_part_sal INTEGER NOT NULL, 
  dt_sal DATE, 
  vl_sal NUMERIC(12,2), 
  descr VARCHAR(255), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR, 
  comp_ult_alt VARCHAR, 
  CONSTRAINT pk_part_sal PRIMARY KEY(id_part, id_part_sal)
) ;

ALTER TABLE public.tb_part_sal
  ADD CONSTRAINT fk__part_sal__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_rec
  ADD CONSTRAINT fk__part_rec__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_rec
  ADD CONSTRAINT fk__part_rec__tp_rec FOREIGN KEY (id_tp_rec)
    REFERENCES public.tb_tp_rec(id_tp_rec)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_fer
  ADD CONSTRAINT fk__part_fer__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part_exam
  ADD CONSTRAINT fk__part_exam__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_part
  ADD CONSTRAINT fk__part__func FOREIGN KEY (id_func)
    REFERENCES public.tb_func(id_func)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;
