CREATE SEQUENCE public.sq_cap_soc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_cap_soc_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _cap_soc record;
    _nr_doc varchar;
    _id_ct integer;
    _op varchar;
    _vl_rest numeric; 
    _vl_quit numeric;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'CAP_SOC' and
            id_org = old.id_cap_soc and
            id_org_item = old.id_cap_soc_pagto;
            
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            tp_org = 'CAP_SOC' and
            id_org = old.id_cap_soc and
            id_org_item = old.id_cap_soc_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
                
        select * into _cap_soc
        from tb_cap_soc
        where
            id_emp = new.id_emp and
            id_cap_soc = new.id_cap_soc;
            
        
        _nr_doc := new.id_cap_soc;
        
        if (_op_fnc.gera_ct) then
                    
            _id_ct := nextval('sq_ct');
                
            if (_cap_soc.op = 'SUB') then
                _op := 'R';
            else
                _op := 'P';
            end if;
                
            if (new.sit = 'P') then
                _vl_rest := new.vl_lanc;
                _vl_quit := 0;
            else
                _vl_rest := 0;
                _vl_quit := new.vl_lanc;
            end if;
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                 dt_emis, dt_venc, vl_ct, stat, 
                 id_cnt_bnc,
                 org, tp_org, id_org, id_org_item,
                 id_op_fnc, vl_quit, vl_rest, 
                 obs,
                 id_plano_ct, id_cnt_cst,
                 vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt)
            values
                (new.id_emp, _id_ct, _op, _op_fnc.tp_op_fnc, _cap_soc.id_part, _nr_doc, new.id_cap_soc_pagto, 0,
                 _cap_soc.dt_emis, new.dt_venc, new.vl_lanc, new.sit, 
                 new.id_cnt_bnc,
                 'CAP_SOC.' || new.id_cap_soc || '.' || new.id_cap_soc_pagto, 'CAP_SOC', new.id_cap_soc, new.id_cap_soc_pagto,
                 new.id_op_fnc, _vl_quit, _vl_rest, 
                 new.obs,
                 _cap_soc.id_plano_ct, _cap_soc.id_cnt_cst,
                 new.vl_lanc, 0, 0, 0, 0, 
                 _cap_soc.id_usr_ult_alt, _cap_soc.dt_hr_ult_alt, _cap_soc.id_usr_ult_alt, _cap_soc.dt_hr_ult_alt, _cap_soc.comp_cad, _cap_soc.comp_ult_alt);
                
        end if;
                
        if (_op_fnc.tp_op_fnc = 'BNC') then
            
            if (_cap_soc.op = 'SUB') then
                _op := 'C';
            else
                _op := 'D';
            end if;
        
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, 
                 id_op_fnc, op, vl_lanc, descr, conc, 
                 id_part, sit_conc,
                 id_plano_ct, id_cnt_cst,
                 org, tp_org, id_org, id_org_item,
                 id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _cap_soc.dt_emis, new.dt_venc, _nr_doc, 
                 new.id_op_fnc, _op, new.vl_lanc, new.obs, false,
                 _cap_soc.id_part, 'PEND',
                 _cap_soc.id_plano_ct, _cap_soc.id_cnt_cst,
                 'CAP_SOC.' || new.id_cap_soc || '.' || new.id_cap_soc_pagto, 'CAP_SOC', new.id_cap_soc, new.id_cap_soc_pagto,
                 _cap_soc.id_usr_ult_alt, _cap_soc.dt_hr_ult_alt, _cap_soc.id_usr_ult_alt, _cap_soc.dt_hr_ult_alt, _cap_soc.comp_cad, _cap_soc.comp_ult_alt);
        end if;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_cap_soc (
  id_emp INTEGER NOT NULL, 
  id_cap_soc INTEGER NOT NULL, 
  id_part INTEGER, 
  dt_emis DATE, 
  vl_tot NUMERIC(12,2), 
  id_plano_ct VARCHAR(100), 
  id_cnt_cst INTEGER, 
  obs VARCHAR(255), 
  tp VARCHAR(10), 
  op VARCHAR(10), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  CONSTRAINT pk_cap_soc PRIMARY KEY(id_emp, id_cap_soc)
) ;

CREATE TABLE public.tb_cap_soc_pagto (
  id_emp INTEGER NOT NULL, 
  id_cap_soc INTEGER NOT NULL, 
  id_cap_soc_pagto INTEGER NOT NULL, 
  dt_venc DATE, 
  id_op_fnc INTEGER, 
  vl_lanc NUMERIC(12,2), 
  obs VARCHAR(255), 
  id_cnt_bnc INTEGER, 
  sit VARCHAR(1), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  CONSTRAINT pk_cap_soc_pagto PRIMARY KEY(id_emp, id_cap_soc, id_cap_soc_pagto)
) ;

CREATE TRIGGER tr_cap_soc_pagto_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_cap_soc_pagto FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_cap_soc_pagto_bf();

CREATE INDEX idx_tp_org ON public.tb_ct
  USING btree (id_emp, tp_org COLLATE pg_catalog."default", id_org);

CREATE INDEX idx_dt_emis ON public.tb_contr_frete
  USING btree (dt_emis);

ALTER TABLE public.tb_cap_soc_pagto
  ADD CONSTRAINT fk__cap_soc_pagto__cap_soc FOREIGN KEY (id_emp, id_cap_soc)
    REFERENCES public.tb_cap_soc(id_emp, id_cap_soc)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cap_soc_pagto
  ADD CONSTRAINT fk__cap_soc_pagto__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cap_soc
  ADD CONSTRAINT fk__cap_soc__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_cap_soc
  ADD CONSTRAINT fk__cap_soc__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;
