SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
    _app_con varchar;
    
    _nat_op record;
    _gera_fin boolean;
    
    _ct record;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    /*
    
    --
    -- Conflito com a auta baixa, comentada para ver se nao vai dar erro em algum outro lugar
    --
    if (tg_op = 'UPDATE') then
        select stat into _ct
        from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'NF' and
            id_org = old.id_nf and
            id_org_item = old.id_nf_parc;
    
        if (_ct.stat = 'Q') then
            return new;
        end if;
    end if;*/

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            tp_org = 'NF' and
            id_org = old.id_nf and
            id_org_item = old.id_nf_parc;
            -- org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            tp_org = 'NF' and
            id_org = old.id_nf and
            id_org_item = old.id_nf_parc;
            -- org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select 
                tb_nf.tp_emis as tp_emis_nf,
                tb_nat_op.* 
            into 
                _nat_op
            from tb_nf
            join tb_nat_op on
                (tb_nf.id_nat_op = tb_nat_op.id_nat_op)
            where
                tb_nf.id_emp = new.id_emp and
                tb_nf.id_nf = new.id_nf;
                
            _gera_fin :=
                (_nat_op.tp_emis_nf = '[P]' and _nat_op.op like '%[NF_EMT__GER_FIN]%') or
                (_nat_op.tp_emis_nf = '[T]' and _nat_op.op like '%[NF_REC__GER_FIN]%');
                
                
            if (_op_fnc.gera_ct and _gera_fin) then
            
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt,  
                     id_cnt_bnc, 
                     org, tp_org, id_org, id_org_item,
                     obs, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct, id_cnt_cst,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c)
                values
                    (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, 'NF', new.id_nf, new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr, new.id_op_fnc, 0, new.vl_parc, 
                     new.id_plano_ct, new.id_cnt_cst,
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt, _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
                if (_op_fnc.auto_bx) then
                    perform fc_bx_ct(new.id_emp, _id_ct);
                end if;
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC' and _gera_fin and (coalesce(_op_fnc.auto_bx, false) = false)) then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, tp_org, id_org, id_org_item,
                     id_part, sit_conc,
                     id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt,
                     id_ct_ctb_d, id_ct_ctb_c,
                     id_plano_ct, id_cnt_cst,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, 'NF', new.id_nf, new.id_nf_parc,
                     _nf.id_part_emt, 'PEND',
                     _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt, _nf.id_usr_ult_alt, _nf.dt_hr_ult_alt,
                     new.id_ct_ctb_d, new.id_ct_ctb_c,
                     new.id_plano_ct, new.id_cnt_cst,
                     new.id_op_fnc);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_item_emp_bf (
)
RETURNS trigger AS
$body$
declare
    _id_emp_matriz integer;
    _cnf_item_alt_prc_filial varchar;
    
    _filial record;
    _app_con varchar;
    
    _cmp_prc_unt_item_agr varchar;
    _dt_ult_cmp date;
begin
    _app_con := fc_app_con();
    
    if (_app_con = 'NEO_UNI') then
        return new;
    end if;
    
    
    if (tg_op = 'UPDATE') then
        if (coalesce(old.vl_cst_rep, 0) <> coalesce(new.vl_cst_rep, 0)) then
            new.vl_ult_cst_rep := old.vl_cst_rep;
        end if;
        
        if (coalesce(old.vl_cst_med, 0) <> coalesce(new.vl_cst_med, 0)) then
            new.vl_ult_cst_med := old.vl_cst_med;
        end if;
        
        if (coalesce(old.vl_prc_vnd, 0) <> coalesce(new.vl_prc_vnd, 0)) then
            new.vl_ult_prc_vnd := old.vl_prc_vnd;
        end if;
        
        
        /*
        if  (colesce(old.vl_cst_rep, 0) <> colesce(new.vl_cst_rep, 0)) or
            (colesce(old.vl_cst_med, 0) <> colesce(new.vl_cst_med, 0)) then
            
            select max(tb_nf.dt_op) into _dt_ult_cmp
            from tb_nf
            join tb_nf_item on
                (tb_nf.id_emp = tb_nf_item.id_emp and
                 tb_nf.id_nf = tb_nf_item.id_nf)
            where
                tb_nf.id_emp = new.id_emp and
                tb_nf_item.id_item = new.id_item and
                tb_nf.tp_emis = '[T]' and
                tb_nf.tp_op = '[E]';
            
            new.dt_ult_cmp := _dt_ult_cmp;
            
        end if;*/
        
    end if;
    

    if (tg_op = 'INSERT') 
        or (tg_op = 'UPDATE'
            and (coalesce(old.vl_cst_med, 0) <> coalesce(new.vl_cst_med, 0)
                 or coalesce(old.vl_cst_rep, 0) <> coalesce(new.vl_cst_rep, 0)
                 or coalesce(old.vl_prc_vnd, 0) <> coalesce(new.vl_prc_vnd, 0))) then
        --
        -- Altera/Insere os preços nas filiais
        --
        _cnf_item_alt_prc_filial := fc_get_emp_cnf(new.id_emp, 07011);
        
        if (lower(_cnf_item_alt_prc_filial) = 'true') then
            _id_emp_matriz := fc_id_emp_matriz();
            if (new.id_emp = _id_emp_matriz) then
                
                for _filial in
                    select id_part
                    from tb_part
                    where
                        tp_part like '%[E]%' and
                        id_part <> new.id_emp
                loop
                    update tb_item_emp set
                        vl_cst_med = new.vl_cst_med,
                        vl_cst_rep = new.vl_cst_rep,
                        vl_ult_cst_med = new.vl_ult_cst_med,
                        dt_ult_cmp = new.dt_ult_cmp,
                        vl_prc_vnd = new.vl_prc_vnd,
                        vl_estq_min = new.vl_estq_min,
                        vl_estq_max = new.vl_estq_max,
                        ender_estq = new.ender_estq,
                        vl_perc_luc = new.vl_perc_luc,
                        vl_out = new.vl_out,
                        vl_perc_desp_op = new.vl_perc_desp_op,
                        vl_desp_op = new.vl_desp_op,
                        vl_luc = new.vl_luc,
                        vl_ult_prc_vnd = new.vl_ult_prc_vnd,
                        vl_ult_cst_rep = new.vl_ult_cst_rep,
                        dt_hr_ult_alt = new.dt_hr_ult_alt,
                        id_usr_ult_alt = new.id_usr_ult_alt,
                        promo = new.promo,
                        vl_prc_vnd_promo = new.vl_prc_vnd_promo
                    where
                        id_item = new.id_item and
                        id_emp = _filial.id_part;
                        
                    if not found then
                        insert into tb_item_emp 
                            (id_item, id_emp, vl_cst_med, vl_cst_rep, vl_ult_cst_med, dt_ult_cmp,
                             vl_prc_vnd, vl_estq_min, vl_estq_max, ender_estq, vl_perc_luc, vl_out,
                             vl_perc_desp_op, vl_desp_op, vl_luc, vl_ult_prc_vnd, vl_ult_cst_rep,
                             dt_hr_ult_alt, id_usr_ult_alt,
                             promo, vl_prc_vnd_promo)
                        values
                            (new.id_item, _filial.id_part, new.vl_cst_med, new.vl_cst_rep, new.vl_ult_cst_med, new.dt_ult_cmp,
                             new.vl_prc_vnd, new.vl_estq_min, new.vl_estq_max, new.ender_estq, new.vl_perc_luc, new.vl_out,
                             new.vl_perc_desp_op, new.vl_desp_op, new.vl_luc, new.vl_ult_prc_vnd, new.vl_ult_cst_rep,
                             new.dt_hr_ult_alt, new.id_usr_ult_alt,
                             new.promo, new.vl_prc_vnd_promo);
                    end if;
                end loop;
                
            end if;
        end if;
    end if;



    if (tg_op = 'UPDATE') then
        if (old.vl_cst_med <> new.vl_cst_med or
            old.vl_cst_rep <> new.vl_cst_rep or
            old.vl_prc_vnd <> new.vl_prc_vnd) then

            insert into tb_item_alt_prc
                (id_emp, id_item_alt_prc, id_item, dt_hr, 
                 vl_cst_rep_ant, vl_cst_rep_atu, 
                 vl_cst_med_ant, vl_cst_med_atu, 
                 vl_prc_vnd_ant, vl_prc_vnd_atu,
                 dt_hr_ult_alt, id_usr_ult_alt, id_est_ult_alt)
            values 
                (new.id_emp, nextval('sq_item_alt_prc'), new.id_item, current_timestamp,
                 old.vl_cst_rep, new.vl_cst_rep,
                 old.vl_cst_med, new.vl_cst_med,
                 old.vl_prc_vnd, new.vl_prc_vnd,
                 new.dt_hr_ult_alt, new.id_usr_ult_alt, new.id_est_ult_alt);


            -- Busca o campo unitario do item agregado
            select fc_get_emp_cnf(new.id_emp, 07016) into _cmp_prc_unt_item_agr; -- CNF_ITEM_PRC_UNT_ITEM_AGR

            -- 
            -- Altera o preco unitario do item agregado que este item compoe
            --
            update tb_item_agr set
                vl_unt = 
                    case _cmp_prc_unt_item_agr 
                        when 'vl_prc_vnd' then new.vl_prc_vnd
                        when 'vl_cst_med' then new.vl_cst_med
                        else new.vl_cst_rep
                    end,
                vl_tot = vl_qtd *
                    case _cmp_prc_unt_item_agr 
                        when 'vl_prc_vnd' then new.vl_prc_vnd
                        when 'vl_cst_med' then new.vl_cst_med
                        else new.vl_cst_rep
                    end,
                dt_hr_ult_alt = new.dt_hr_ult_alt,
                id_usr_ult_alt = new.id_usr_ult_alt
            where
                id_item_agr = new.id_item;
/*            
            update tb_item_emp set
                vl_cst_rep = tb.vl_tot,
                vl_luc = vl_prc_vnd - vl_cst_rep,
                vl_perc_luc = (vl_prc_vnd - vl_cst_rep) * 100 / vl_prc_vnd
            from
            (
                select 
                    tb_item_agr.id_item,
                    sum(tb_item_agr.vl_tot) as vl_tot
                from tb_item_agr
                group by
                    tb_item_agr.id_item
            ) as tb
            where
                tb_item_emp.id_item = tb.id_item and
                tb_item_emp.id_emp = new.id_emp and
                tb_item_emp.id_item <> new.id_item and
                exists 
                    (select 1
                     from tb_item_agr
                     where
                         tb_item_agr.id_item = tb.id_item and
                         tb_item_agr.id_item_agr = new.id_item);
*/
        end if;
    end if;
    
    return new;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

